// CLASSic oBROWSE Class
// By John D. Van Etten
// Written in CLASSic

#include "Classic.ch"
#include "Inkey.ch"

Begin Class oBrowse() From TBrowse() Select From oWin()

  Global:
    Var Header       Type Char
    Var Footer       Type Char
    Var HeaderColor  Type Char
    Var FooterColor  Type Char

    Var nTop    Type Numeric   // Box Cordinates
    Var nLeft   Type Numeric
    Var nBottom Type Numeric
    Var nRight  Type Numeric

    Method Init
    Method Open
    Method Close()
    Method AddColumn             Type Object
    Method AddColumn Message Add Type Object
    Method Column                Type Object
    Method Browse                Type Numeric

  // TBrowse()
    Method TBAdd is Method AddColumn in TBrowse()

  // oWin()
    Var lOpened Inherits from oWin() // Only inherit this Var from oWIN()!
End Class

Method Init( nTop, nLeft, nBottom, nRight, ;
             cColor := "gr+/b", ;
             cHeader, cFooter, cHeadColor, cFootColor ),;
           ( nTop, nLeft, nBottom, nRight ), ;
           ( , cHeader, cHeadColor, cFooter, cFootColor )

  ::Configure()
  ::HeadSep := ""
  ::ColSep := " "

  // Move TBrowse inside of box!
  ::nTop    := :::nTop
  ::nLeft   := :::nLeft
  ::nBottom := :::nBottom
  ::nRight  := :::nRight
  :::nTop    += 2
  :::nLeft   += 2
  :::nBottom -= 2
  :::nRight  -= 2

  ::Header := cHeader
  ::Footer := cFooter
  ::ColorSpec := cColor
  ::HeaderColor := cHeadColor
  ::FooterColor := cFootColor
Return( Self )

Method Open( lForceStable := .t. )

  ::Super[2]:cColor       := ::ColorSpec
  ::Super[2]:Header       := ::Header
  ::Super[2]:cHeaderColor := ::HeaderColor
  ::Super[2]:Footer       := ::Footer
  ::Super[2]:cFooterColor := ::FooterColor

  ::Super[2]:Set( ::nTop, ::nLeft, ::nBottom, ::nRight )
  :::nTop    := ::nTop + 2
  :::nLeft   := ::nLeft + 2
  :::nBottom := ::nBottom - 2
  :::nRight  := ::nRight - 2

  ::Configure()
  ::Invalidate()
  ::RefreshAll()

  ::Super[2]:Open()

  If lForceStable
    ::ForceStable()
  Endif
Return( Self )


Method Close()
  ::Super[2]:Close()
Return( Self )


Method Column( cHeading, bBlock )
  Local oColumn := TBColumnNew( cHeading, bBlock )

Return( oColumn )


Method AddColumn( cHeading, bBlock )
  Local oColumn

  if Valtype( cHeading ) == "O"
    oColumn := cHeading
  else
    oColumn := @:Column( cHeading, bBlock )
  endif

  ::TBAdd( oColumn )
Return( oColumn )

Method Browse( bKey, bRunning, lForce := .f. )
  Local nKey := 0
  Local nLastKey := 0

  if !::Super[2]:lOpened
    ::Open( lForce )
  Elseif lForce
    ::ForceStable()
  endif

  Do While nKey != NIL
    Do While ( nKey := Inkey() ) == 0
      if bRunning != NIL
        Eval( bRunning, Self, :::Stable )
      endif

      if !:::Stable
        :::Stabilize()
        if :::Stable .and. ( :::hitBottom .or. :::hitTop )
          tone( 100, 0 )
        endif
      endif
    Enddo

    nLastKey := nKey

    If Setkey( nKey ) != NIL
      Eval( Setkey( nKey ), ClassName(), ClassLine(), "TBROWSE" )
    elseIf bKey != NIL
      nKey := Eval( bKey, Self, nKey )
    Elseif nKey == K_ESC .or. nKey == K_ENTER
      nKey := NIL
    Endif

    If ISNUM( nKey )
      ::Default( nKey ) // TBROWSE() has a Default key routine!
    else // If UDF block doesn't return a Numeric then process the orig. key
      ::Default( nLastKey ) // TBROWSE() has a Default key routine!
    Endif
  Enddo
Return( nLastKey )
