*:*********************************************************************
*:
*:      Program: CFGCHECK.PRG
*:
*:       System: Function for checking and updating config.sys file.
*:       Author: John F. Rogers
*:       Copyright (c) 1988, RJM Software, Inc.
*:
*:      Purpose: This function will check the config.sys file for
*:               properly set files and buffers.  It will make necessary
*:               changes, if required or create a config.sys file.
*:
*:
*:   Parameters: files_req,buffs_req
*:
*:      Returns: .T.        Config.sys is O.K.     (no changes required)
*:               .F.        Config.sys is not O.K. (changes made)
*:
*:
*:         Uses: TEMPONE.DBF
*:             : TEMPTWO.DBF
*:             : C:\CONFIG.OLD
*:
*: Documented: 5/16/88       20:05                   SNAP! version 2.02a
*:*********************************************************************
FUNCTION configok

PARAMETERS files_req,buffs_req
PRIVATE m_files,m_buff,m_okay

*** initialize private variables
m_okay     = .F.
m_files    = 0
m_buff     = 0

***********************************************************************
*: m_file < 0   - Config.sys file does not exist
*: m_file = 0   - No FILES statement is found
*: m_file > 0   - Number of files currently set
*: m_buff < 0   - Config.sys file does not exist
*: m_buff = 0   - No BUFFERS statement is found
*: m_buff > 0   - Number of buffers currently set
***********************************************************************


*** if config.sys file exists perform following
IF FILE("c:\config.sys")

    CREATE tempone
    *** open temporary work file and append blank
    USE tempone
    APPEND BLANK
    REPLACE field_name WITH 'tempfield',field_type WITH 'C',field_len WITH 254

    *** create second work file from first work file
    CREATE temptwo FROM tempone
    ERASE tempone.dbf
    USE temptwo
    *** append existing config.sys data to temptwo work file
    APPEND FROM c:\config.sys SDF

    *** locate record containing 'files' data
    LOCATE ALL FOR AT( 'FILES=',UPPER(tempfield) ) > 0

    IF FOUND()
        m_len   = LEN(TRIM(tempfield))
        m_files = SUBSTR(tempfield,7,m_len)
        m_files = VAL(m_files)
    ELSE
        *** return following value if 'files=' statement not found
        m_files = 0
    ENDIF

ELSE
    *** return following values if a config.sys file does not exist
    m_files = -1
    m_buff  = -1
ENDIF

*** locate record containing 'buffers' data
LOCATE ALL FOR AT( 'BUFFERS=',UPPER(tempfield) ) > 0

IF FOUND()
    m_len   = LEN(TRIM(tempfield))
    m_buff  = SUBSTR(tempfield,9,m_len)
    m_buff = VAL(m_buff)
ELSE
    *** return following value if 'buffers=' statement not found
    m_buff = 0
ENDIF


*** check if files and buffers are correct
IF m_files < files_req .OR. m_buff < buffs_req

    DO CASE

        *** CONFIG.SYS does not exist
        CASE m_files < 0

            *** create a new CONFIG.SYS file
            SET CONSOLE OFF
            SET ALTERNATE TO C:\config.sys
            SET ALTERNATE ON
            ? 'files='   + LTRIM(STR(files_req))
            ? 'buffers=' + LTRIM(STR(buffs_req))
            SET ALTERNATE OFF
            SET CONSOLE ON

        OTHERWISE

            *** Backup up existing config.sys, and modify
            SET CONSOLE OFF

            *** Backup CONFIG.SYS
            COPY FILE C:\config.sys TO C:\config.old

            *** open temporary workfile
            USE temptwo

            *** A "files=" statement wasn't found in the existing config.sys
            IF m_files = 0
                APPEND BLANK
                REPLACE tempfield WITH 'files=' + LTRIM(STR(files_req))
            ENDIF

            *** A "buffers=" statement wasn't found in the existing config.sys
            IF m_buff  = 0
                APPEND BLANK
                REPLACE tempfield WITH 'buffers=' + LTRIM(STR(buffs_req))
            ENDIF

            *** "files=" statement found, with wrong value
            IF m_files > 0 .AND. m_files < files_req
                LOCATE ALL FOR AT( 'FILES=' , UPPER(tempfield) ) > 0

                IF FOUND()
                    REPLACE tempfield WITH 'files=' + LTRIM(STR(files_req))
                ENDIF

            ENDIF

            *** "buffers=" statement found, with wrong value
            IF m_buff > 0 .AND. m_buff < buffs_req
                LOCATE ALL FOR AT( 'BUFFERS=',UPPER(tempfield) ) > 0

                IF FOUND()
                    REPLACE tempfield WITH 'buffers=' + LTRIM(STR(buffs_req))
                ENDIF

            ENDIF

            *** the CONFIG.SYS file has been corrected. Copy to c:\ and re-boot
            GOTO TOP
            SET ALTERNATE TO C:\config.sys
            SET ALTERNATE ON
            DO WHILE !EOF()

                IF LEN(TRIM(tempfield)) > 0
                    ? TRIM(tempfield)
                ENDIF

                SKIP
            ENDDO

            SET ALTERNATE OFF
            SET CONSOLE ON
            ERASE temptwo.dbf

    ENDCASE
    CLEAR
    *** set up own message here...
    SET COLOR TO N/W
    @ 10,11 CLEAR TO 16,70
    @ 10,11 TO 16,70
    @ 12,13 SAY " Your configuration file (config.sys) has been modified! "
    @ 13,13 SAY "To use new config.sys file your system must be re-booted,"
    @ 14,13 SAY "    by pressing the CTRL-ALT-DEL keys simultaneously.    "

    m_okay = .F.
ELSE
    m_okay = .T.
ENDIF

CLOSE ALTERNATE
RETURN(m_okay)

*: EOF: CFGCHECK.PRG
