/*  CDDLIB.CH Header file   */


/* other include files */
#include "set.ch"              // Clipper SET environment manifest constants
#include "inkey.ch"            // Clipper's INKEY constants
#include "box.ch"              // Clipper's box frames
#include "error.ch"            // Clipper's error codes
#include "dbstruct.ch"         // Clipper's structure
#include "setcurs.ch"          // Clipper's SETCURSOR() references
#include "achoice.ch"          // Clipper's achoice()
#include "getexit.ch"          // Clipper's GET:exitState constants

/*
  General defined commands/translates
*/
#xcommand DEFAULT <p> TO <val> [,<pn> TO <valn>] =>;
         <p> := if(<p> = nil, <val>, <p>);
         [;<pn> := if(<pn> = nil, <valn>, <pn>)]
#xtranslate COMPILE(<v>) =>   &("{||" + <v> + "}")   // compile a code block

/*
  Manifest Constants for VGEN
*/
* misc constants
#define ID_LEN 10             // length of function id
#define ALIAS_LEN 7           // length of data and index aliases

* dd filename suffixes
#define DBF_SUF "D"           // dbfs
#define FLD_SUF "F"           // fields
#define IDX_SUF "I"           // indexes
#define SYS_SUF "S"           // system
#define BRO_SUF "B"           // browses
#define COL_SUF "C"           // browse columns
#define KEY_SUF "K"           // browse keys
#define MEN_SUF "M"           // menus
#define MNK_SUF "N"           // menu keys
#define FID_SUF "O"           // find ids
#define FND_SUF "P"           // find get items
#define SCR_SUF "T"           // screens
#define SGT_SUF "U"           // screen get items
#define SKY_SUF "V"           // screen keys
#define SEQ_SUF "X"           // sequences

* parse_color() constants
#define C_STD 0      // standard
#define C_ENH 1      // enhanced
#define C_BRD 2      // border
#define C_BKG 3      // background (not supported)
#define C_UNS 4      // unselected

* screen get array references
#define GDALIAS      1     // DALIAS
#define GFIELD       2     // FIELD
#define GINTERNAL    3     // INTERNAL
#define GDECLARE     4     // DECLARE
#define GPROMPT      5     // PROMPT
#define GFTYPE       6     // FTYPE
#define GFLEN        7     // FLEN
#define GFDEC        8     // FDEC
#define GPICT        9     // PICT
#define GINIT_EXPR   10    // INIT_EXPR
#define GCOND_VAL    11    // COND_VAL
#define GCOND_ACC    12    // COND_ACC
#define GROW         13    // row
#define GCOL         14    // column
#define GUNS_VIEW    15    // unselected view mode color
#define GUNS_EDIT    16    // unselected edit mode color
#define GENH_EDIT    17    // selected edit mode color
#define GINIT_VAL    18    // initial loaded values NOT A FIELD IN FILE!
#define GINIT_ADD_B  19    // screen add init block
#define GINIT_VIEW_B 20    // screen edit/view init block
#define GMEMVAR_B    21    // screen memvar get/set block
#define GCOND_FULL   22    // cond. for full screen valid
#define GERR_FULL    23    // error message for full screen valid

#define ACCEPT_A     1     // Accept
#define ACCEPT_R     2     // Retry
#define ACCEPT_C     3     // Cancel or escaped
