* CAPNEG1.PRG

* EXAMPLES TO DEMONSTRATE USE OF CAPTAIN SYSTEM AUTHORIZATION FUNCTIONS
*                                        ------
*
* Include this source code at the start of the first .prg of
* your application and change "msystem = 'capncode'" to indicate
* the name of the software you are protecting
* e.g. "msystem = 'Protect-me'"

* This system name must be the same as the Product ID for the product
* (in the products file in CAPN)                                   

* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
* IT IS RECOMMENDED THAT FULL 10 CHARACTER SYSTEM NAMES ARE
* ALWAYS USED (NO TRAILING BLANKS)
* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

msystem = 'capncode'                    && max 10 characters
*  MSYSTEM must be the same as the PRODUCT ID in the CAPN database!

clear
cdrive = ''

do while .t. 
   cret = capnchek(msystem)            && see if already authorized
   if left(cret,1) = '9'               && can not access serialno.dbf
      @ 10,10 say 'Error accessing SERIALNO.DBF'
      wait
      cancel
   elseif left(cret,1) = '2'           && invalid date
      @ 10,10 say 'Invalid System Date'
      wait
      cancel
   elseif left(cret,1) = '4'           && back dating!
      @ 10,10 say 'Invalid System Date - Earlier than last use!'
      wait
      cancel
   elseif left(cret,1) = '0'           && all OK
      cdrive = substr(cret,2,2)
      exit
   elseif left(cret,1) = '3'           && authorization has expired
      cdrive = substr(cret,2,2)
      @ 10,10 say 'Software Authorization has expired!'
   elseif left(cret,1) = '1'           && no registration found
   endif

   if empty(cdrive)
      cdrive = 'C'
      @ 11,10 say 'Enter disk drive for authorization: ' ;
      get cdrive picture '@! A' valid(!(cdrive $ 'AB'))
      read
      if lastkey() = 27
         cancel
      endif
      cdrive = cdrive + ':'

      cret = capnmake(msystem,cdrive)
      if cret = '6'
         @ 12,10 say 'Can not create CAPTAIN directory or files on ' + cdrive + '!'
         wait
         cancel
      elseif cret = '5'
         @ 12,10 say 'Invalid disk drive letter!'
         wait
         cancel
      elseif left(cret,1) = '9'        && can not access serialno.dbf
         @ 12,10 say 'Error accessing SERIALNO.DBF'
         wait
         cancel
      endif
   endif

   cseed = capnget(msystem)            && get seed number
   cauth = 0

   @ 12,10 say 'System to be Authorized is : '
   @ 12,39 say msystem
   @ 13,10 say 'System serial number is    : '
   @ 13,39 say val(cseed) picture '999 999 999 999'
   @ 14,10 say 'Enter Authorization Number : ' 
   @ 14,39 get cauth picture '999 999 999 999'
   @ 15,10 say '(Phone software dealer)'
   read
   if lastkey() = 27
      cancel
   endif
   cauth = str(cauth,12)
   cret = capntest(msystem,cdrive, cseed, cauth)
   if cret = '0'
      exit
   elseif left(cret,1) = '9'           && can not access serialno.dbf
      @ 16,10 say 'Error accessing SERIALNO.DBF'
      wait
      cancel
   endif
   @ 16,10 say 'Invalid authorization!'
   wait
   cancel                              
enddo


