/*******************************************************************************
*  CALC.C   - This program is a floating point electronic calculator written   *
*             in the Dbase III + programming language and translated to        *
*             Turbo C 1.5. The program code documention is in the Dbase PRG    *
*             file.  The program author has placed this program in the         *
*             Public Domain.                                    Dan Kenny 5/88 *
*******************************************************************************/
#include <stdlib.h>
#include <conio.h>
#include <graphics.h>

double operand1=0,
       operand2=0,
       result=0;
       
int    decount=2,
       loperator=61,
       key=0,
       col=54,
       equalsmode=1,
       firstpass=1,
       memexist=0;
       
char   oper2str[14] = "",
       memstr[14] = "",
       picstring[10] = "%13.2f";
       
void   locate(int row,int col);
void   clear(void);
void   initscreen(void);
int    getkey(void);
char   *space(int num);      
void   strccat(char *p,int c);      
char   *strpcat(char *p1, char *p2);
char   *ljust(char *p);
char   *trim(char *p);
void   calcfmt(void);

void main (void)
{

  initscreen();

  clear();
  calcfmt();
  locate(3,54); cprintf(picstring,operand1);      
  locate(4,54); cprintf(picstring,operand2);      
  locate(6,54); cprintf(picstring,result);
  while (key!=27) {
     locate(8,col);
     key = getkey();
     switch(key) {
         case 27: continue;
         case 42:
         case 43:
         case 45:
         case 47:
         case 61: 
         case 13: if (key==13)  
                     key = 61;
                  if (key==45) {
                     if ((oper2str[0]=='\0') && (loperator!=61)) {
                        strcpy(oper2str,"-");
                        locate(8,col); cprintf("-");
                        col++;
                        continue;
                     } 
 
                     if (oper2str[0]=='-') {
                        oper2str[0] = '\0';
                        locate(8,col-1); cprintf(" ");
                        col--;
                        loperator = key;
                        locate(6,68); cprintf("%c",loperator);
                        continue;
                     }
                  }
       
                  if (key == 61) {
                     locate(6,68); cprintf(" ");
                     if ((equalsmode) && (oper2str[0]=='\0')) {
                        loperator = key;
                        continue;
                     }
                     else 
                        equalsmode = 1;
                  }
   
                  if (equalsmode) {
                     if (oper2str[0]=='\0') {                        
                        loperator = key;
                        locate(6,68); cprintf("%c",(key==61) ? ' ' : loperator);
                        continue;
                     }
                     else 
                        if (key != 61) {
                           equalsmode = 0;
                           firstpass = (loperator==61) ? 1 : 0;
                        }
                  }
 
                  if (firstpass) {
                     firstpass = 0; 
                     result = atof(oper2str);
                     loperator = key;
                     operand1 = 0;
                     operand2 = 0;                             
                     locate(3,54); cprintf(strpcat(picstring,"  "),operand1);
                     locate(4,54); cprintf(picstring,result);
                     locate(6,54); cprintf(picstring,result);
                     locate(6,68); cprintf("%c",key);
                     col = 54;
                     locate(8,col); cprintf(space(13));
                     operand1 = result;
                     oper2str[0] = '\0';
                     continue;
                  }
       
                  if (oper2str[0]=='\0') {
                     loperator = key;
                     locate(6,68); cprintf("%c",loperator);
                     continue;
                  }
       
                  operand2 = atof(oper2str);
       
                  switch(loperator) {
                     case 42 : result = operand1 * operand2;
                               break;
                     case 43 : result = operand1 + operand2;
                               break;
                     case 45 : result = operand1 - operand2;
                               break;
                     case 47 : result = operand1 / operand2;
                               break;
                  }
       
                  locate(3,54); cprintf(picstring,operand1);
                  locate(4,54); cprintf(picstring,operand2);
                  locate(6,54); cprintf(picstring,result);
                  locate(3,68); cprintf("%c",loperator);
                  locate(6,68); cprintf("%c",(key==61) ? ' ' : key);
                  loperator = key;
                  col = 54;
                  locate(8,col); cprintf(space(13));
                  operand1 = result;
                  oper2str[0] = '\0';
                  continue;
         case 46:
         case 48:
         case 49:
         case 50:
         case 51:
         case 52:
         case 53:
         case 54:
         case 55:
         case 56:
         case 57: if (strlen(oper2str) >= 12) 
                     cprintf("%c",7);
                  else {
                     strccat(oper2str,key);
                     locate(8,col); cprintf("%c",key);
                     col++;
                  }
                  continue;
        case 8  :
        case 127: if (oper2str[0]=='\0') 
                     cprintf("%c",7);
                  else {
                     oper2str[strlen(oper2str)-1] = '\0';
                     col--;
                     locate(8,col); cprintf(" ");
                  }
                  continue;
       case 186 : operand1 = 0;
                  operand2 = 0;
                  result   = 0;
                  oper2str[0] = '\0';
                  locate(3,54); cprintf(strpcat(picstring,"  "),operand1);
                  locate(4,54); cprintf(picstring,operand2);
                  locate(6,54); cprintf(strpcat(picstring,"  "),result);
                  firstpass = 1;
                  loperator = 61; 
                  col = 54;
                  locate(8,col); cprintf(space(13));
                  continue;
       case 187 : oper2str[0] = '\0';
                  col = 54;
                  locate(8,col); cprintf(space(13));
                  continue;
       case 188 : if (memexist) {               
                     memstr[0] = '\0';                
                     locate(3,30); cprintf(space(20));
                     locate(4,30); cprintf(space(20));
                     locate(5,30); cprintf(space(20));
                     locate(6,30); cprintf(space(20));
                     memexist = 0; 
                  }
                  continue;
       case 189 : strcpy(oper2str,memstr);
                  col = 54;
                  locate(8,col); cprintf(space(13));
                  locate(8,col); cprintf(oper2str);
                  col = col + strlen(oper2str);
                  continue;
       case 190 :                  
       case 191 : if (!memexist) {
                     locate(3,30); cprintf("  Memory Contents    ");
                     locate(4,30); cprintf(" Ŀ   ");
                     locate(5,30); cprintf("                   ");
                     locate(6,30); cprintf("    ");
                     memexist = 1; 
                  }
                  else {
                     locate(5,33); cprintf(space(13));
                  }
                  if (key == 190) 
                     strcpy(memstr,oper2str);
                  else {
                     sprintf(memstr,ljust(picstring),result);
                     strcpy(memstr,trim(memstr));
                  }
                  locate(5,33); cprintf(memstr);
                  continue;
       case 192 : locate(23,2); cprintf("Enter # of decimals: %1d",decount);
                  locate(23,23); 
                  decount = getkey()-48;
                  decount = (decount < 0) ? 0 : (decount > 9) ? 9 : decount;
                  locate(23,23); cprintf("%1d",decount);
                  locate(23,2); cprintf(space(30));
                  if (decount != 0 ) 
                     sprintf(picstring,"%%13.%1df",decount);
                  else 
                     strcpy(picstring,"%13.0f");
                  locate(3,54); cprintf(picstring,operand1);
                  locate(4,54); cprintf(picstring,operand2);
                  locate(6,54); cprintf(picstring,result);
                  continue;
       default  : cprintf("%c",7);
     }
  }
  clear();
}

void locate(int row,int col)
{
   gotoxy(col+1,row+1);
}

void clear(void)
{
   clrscr();
}

void initscreen(void)
{                   
   directvideo = 1;  
}

int getkey(void)
{
   int c;
   
   c = getch();
   if (c == 0)
      c = getch() + 127;
   return(c);
}

char *space(int num)
{
   int i;
   char tempstr[256];
   
   for (i=0; i <= num; i++)
      tempstr[i] = ' ';
   tempstr[i] = '\0';
   return(tempstr);
}

char *trim(char *p)
{
   char tempstr[256],*p1;
        
   p1 = tempstr;
   while (*p == ' ') 
      p++;
   while (*p != '\0') {
      *p1 = *p;
      p1++,p++;
   }         
   p1--,p--;
   while (*p == ' ') 
      p1--,p--;
   p1++;
   *p1 = '\0';
   return(tempstr);
   
}


void   strccat(char *p, int c)
{
   int  i;

   i = strlen(p);
   *(p+i) = c;
   *(p+i+1) = '\0';
}

char *strpcat(char *p1, char *p2)
{
   char tempstr[256];
   
   strcpy(tempstr,p1);
   strcat(tempstr,p2);
   return(tempstr);
   
}

char *ljust(char *p)
{
   char tempstr[256],*p1;
   
   p1 = tempstr;
   
   while (*p != '\0') {
      *p1 = *p;
      if (*p1 == '%') {
         p1++;
         *p1 = '-';
      }
      p++,p1++;
   }
   *p1 = '\0';
   return(tempstr);
}



void calcfmt(void)
{
   locate( 2,0); cprintf("Ŀ                            ");
   locate( 3,0); cprintf(" D-Calculator - Dan Kenny                                                ");
   locate( 4,0); cprintf(" Turbo C ver.   Omaha, Ne                                                ");
   locate( 5,0); cprintf("                               ");
   locate( 6,0); cprintf("                                                                           ");
   locate( 7,0); cprintf("   ͻ                  Ŀ  Ŀ    ");
   locate( 8,0); cprintf("    F1  - Clear                          =                             ");
   locate( 9,0); cprintf("    F2  - Clear Entry                         ");
   locate(10,0); cprintf("    F3  - Clear Mem                             ĿĿĿĿ     ");
   locate(11,0); cprintf("    F4  - Mem Recall                             7  8  9  *      ");
   locate(12,0); cprintf("    F5  - Mem -Entry                           ٳ     ");
   locate(13,0); cprintf("    F6  - Mem -Result                          ĿĿĿĿ     ");
   locate(14,0); cprintf("    F7  - Dec. Width                             4  5  6  -      ");
   locate(15,0); cprintf("    ESC - Exit                                  ٳ     ");
   locate(16,0); cprintf("   ͼ                          ĿĿĿĿ     ");
   locate(17,0); cprintf("                                                   1  2  3         ");
   locate(18,0); cprintf("       Press Numlock                              ٳ        ");
   locate(19,0); cprintf("       for numeric                        Ŀ   ĿĿ +      ");
   locate(20,0); cprintf("       keypad.....                         /       0     .         ");
   locate(21,0); cprintf("                                             ٳ     ");
   locate(22,0); cprintf("                                                       ");
}
