* cal.prg
* last revision: Mon  02-10-1992  12:25:39

* GetADate displays a calendar and lets the user select a date by moving
*  cursor keys.  Client should check lastkey() to see if user escaped

#define main_program

* NB Im not certain that IsLeapYear is completely correct.  There may be
*  I don't have the rules for leap years handy and there may be some
*  rules Ive forgotten

#include math.hdr
#include io.hdr
#include date.hdr
#include system.hdr
#include keys.hdr
#include string.hdr

VARDEF EXTERN && from data.hdr
    BYTE     __color_enhcd
    BYTE     __color_std
    LOGICAL  __cursor
ENDDEF

VARDEF PRIVATE
  uint ccol[7] = 11,16,21,26,31,36,41
  uint rrow[6] =  5, 8,11,14,17,20
  char(9) monthnames[12] = "January", "February", "March", "April", ;
    "May", "June", "July", "August", "September", "October", ;
    "November", "December"

  uint day1_offset  && what cell is the first day of the month in?
  uint lastday      && last day of current month
ENDDEF

procedure DrawSkeleton
  fill(1,10,23,46,&double_box," ",__color_std,__color_std,6)

  *           day    1    2    3    4    5    6    7

  @  3,11 ??      "Sun  Mon  Tue  Wed  Thu  Fri  Sat "
  @  4,10 ??      "͹"
  @  5,10 ??      "                            "
  @  6,10 ??      "                            "
  @  7,10 ??      "͹"
  @  8,10 ??      "                            "
  @  9,10 ??      "                            "
  @ 10,10 ??      "͹"
  @ 11,10 ??      "                            "
  @ 12,10 ??      "                            "
  @ 13,10 ??      "͹"
  @ 14,10 ??      "                            "
  @ 15,10 ??      "                            "
  @ 16,10 ??      "͹"
  @ 17,10 ??      "                            "
  @ 18,10 ??      "                            "
  @ 19,10 ??      "͹"
  @ 20,10 ??      "                            "
  @ 21,10 ??      "                            "
  @ 22,10 ??      "ͼ"

endpro && of proc DrawSkeleton


procedure LightUpCell
  parameters value uint cellno
   * cellno is 1..42
   vardef
     uint r,c
   enddef
   r = i_trunc((cellno - 1) /7)
   c = (cellno - 1) % 7

   *? "r = ", r
   *? "c = ", c
   curcolor(rrow[r],ccol[c],__color_enhcd,4)
   curcolor(rrow[r]+1,ccol[c],__color_enhcd,4)
endpro && of proc LightUpCell

procedure DimCell
  parameters value uint cellno
   * cellno is 1..42
   vardef
     uint r,c
   enddef
   r = i_trunc((cellno - 1) /7)
   c = (cellno - 1) % 7

   *? "r = ", r
   *? "c = ", c
   curcolor(rrow[r],ccol[c], __color_std,4)
   curcolor(rrow[r]+1,ccol[c], __color_std,4)
endpro && of proc DimCell

* STUB!! Im not sure this is correct
function logical IsLeapYear
 parameters value uint yearval
  return (((yearval %     4) = 0) .or. ;
          ((yearval %    25) = 0) .or. ;
          ((yearval %   400) = 0))
endpro && of func IsLeapYear

function uint CalcLastDayOfMonth
 parameters value uint yearval, value uint monthval
  Do case
    case (monthval =  4) .or. (monthval =  6) .or. ;
         (monthval =  9) .or. (monthval = 11)
      return 30
    case (monthval = 2)
      if IsLeapYear(yearval)
        return 29
      else
        return 28
      endif
    otherwise
      return 31
  endcase
endpro && of func CalcLastDayOfMonth

procedure FillCells
 parameters value uint yearval, value uint monthval
  * also sets day1_offset and lastday
  vardef
    uint dayno, startday
    uint r,c
  enddef

  @ 2,11 ?? "                                  " && clear the area
  @ 2,11 ?? monthnames[monthval - 1] + " " +str(yearval,4,0)

  startday =  dow(itod(1,monthval,yearval))
  day1_offset = startday - 1
  lastday = CalcLastDayOfMonth(yearval,monthval)  && side effect

  *@ 5,48 ?? "itod        ",itod(1,monthval,yearval)
  *@ 6,48 ?? "LastDay     ",lastday
  *@ 7,48 ?? "Day1_Offset ",day1_offset
  *@ 8,48 ?? "Startday    ",startday

  for dayno = 1 to startday - 1
     r = i_trunc((dayno - 1) /7)
     c = (dayno - 1) % 7
     @ rrow[r]+1, ccol[c]+1 ?? "  "
  next

  for dayno = startday to startday + lastday
     r = i_trunc((dayno - 1) /7)
     c = (dayno - 1) % 7
     @ rrow[r]+1, ccol[c]+1 ?? (dayno - startday +1):2
  next

  for dayno = (startday + lastday ) to 42
     r = i_trunc((dayno - 1) /7)
     c = (dayno - 1) % 7
     @ rrow[r]+1, ccol[c]+1 ?? "  "
  next
endpro && of proc FillCells

function date GetADate
 parameters value date begindate
  vardef
    uint k
    uint cellno
    date curdate
    uint curmon, curday, curyear
    uint utemp
    logical OrigCursor
  enddef

  OrigCursor = __cursor
  cursor_off
*{}*
  Save_Area(1,10,23,46)
  DrawSkeleton
  curdate = begindate
  fillcells(year(curdate),month(curdate))
  cellno = day(curdate)+day1_offset
  curmon  = month(curdate)
  curyear = year(curdate)
  curday  = day(curdate)
  LightUpCell(cellno)

  * now let the user choose a date
  repeat
    k = get_key()
    do case

      case k = &K_right
        if curday = lastday
          curmon = curmon + 1
          curday = 1
          if curmon > 12
            curmon = 1
            curyear = curyear + 1
          endif
          fillcells(curyear,curmon)
        else
          curday = curday + 1
        endif

      case k = &K_left
        if curday = 1
          curmon = curmon - 1
          if curmon < 1
            curmon = 12
            curyear = curyear - 1
          endif
          fillcells(curyear, curmon)
          curday = lastday
        else
          curday = curday - 1
        endif

      case k = &K_up
        if curday < 8 && we are in the first week
          utemp = curday
          curmon = curmon - 1
          if curmon < 1
            curmon = 12
            curyear = curyear - 1
          endif
          fillcells(curyear, curmon)
          curday = lastday - (7 - utemp)
        else
          curday = curday - 7
        endif

      case k = &K_down
        curday = curday + 7
        if curday > lastday
          curday = curday - lastday
          curmon = curmon + 1
          if curmon > 12
            curmon = 1
            curyear = curyear + 1
          endif
          fillcells(curyear,curmon)
        endif

      case k = &K_pg_down
        curmon = curmon + 1
          if curmon > 12
            curmon = 1
            curyear = curyear + 1
          endif
        fillcells(curyear,curmon)

      case k = &K_pg_up
        curmon = curmon - 1
          if curmon < 1
            curmon = 12
            curyear = curyear - 1
          endif
        fillcells(curyear,curmon)

      case k = &K_c_pg_down
        curyear = curyear + 1
        fillcells(curyear,curmon)

      case k = &K_c_pg_up
        curyear = curyear - 1
        fillcells(curyear,curmon)

    endcase
    if (k <> &K_enter) .and. (k <> &K_esc)
      curdate = itod(curday,curmon,curyear)
      DimCell(cellno)
      cellno = day(curdate)+day1_offset
      LightUpCell(cellno)
    endif
  until (k = &K_esc) .or. (k = &K_enter)

  if (k = &K_enter)
    if OrigCursor
      cursor_on
    else
      cursor_off
    endif
    restore_area
    return curdate
  else
    if OrigCursor
      cursor_on
    else
      cursor_off
    endif
    restore_area
    return itod(1,1,1)
  endif
endpro && of func GetADate

** End of cal.prg
