#include "c5eb.ch"
*- SelectFLD() -------------------------------------------------------------

FUNC SelectFLD

PRIVATE FLDCount,choice,x

* Get number of fields
FLDCount := EB_FLDCount()

* If 0, no fields
IF FLDCount ==0
    RETURN(NULL)
* else, if < 0, an error occurred
ELSEIF FLDCount < 0
    PromptLine("ERROR!  Press any key to continue...")
    Error_msg("Error: EB_FLDCount()",EB_ErrorMsg())
    PromptLine("")
    RETURN(NULL)
ENDIF

* Declare a public array to hold field names and selection flags
* (PUBLIC because we will use it in other non-child functions)
PUBLIC FLDList[FLDCount], menupix[FLDCount]

* Fill array with field names
IF EB_FldNamArray(FLDList) < 1
    PromptLine("ERROR!  Press any key to continue...")
    Error_msg("Error: EB_FldNamArray()",EB_ErrorMsg())
    PromptLine("")
    RETURN(NULL)
ENDIF

* Initialize all selection flags to FALSE (not selected)
AFILL(menupix,FALSE)

* Display box
@ 0,60,19,79 BOX SglFrame
@ 0,61 SAY " Fields "

* Display help prompt
PromptLine("Press [ENTER] to select/unselect, [F1] for Info, [Esc] to Continue")

* Get user selection using ACHOICE()
Object := "FIELD"
choice := ACHOICE(2,62,18,78,FLDList,"","AChoiceFunc")

* Clear prompt line
PromptLine("")

* Kill off unselected field names
FOR x := 1 TO FLDCount
    IF ! menupix[x]
        FLDList[x] := ""
    ENDIF
NEXT

RETURN("OK")



