#include "c5eb.ch"
*- TableInfo() -------------------------------------------------------------

FUNC TableInfo

PARAMETERS TableName

PRIVATE old_area,old_color,CloseIt,TArea,TAlias,TOwner,TPerm,TRecs,;
        screen_buf,prompt_buf

old_area := EB_Select()
CloseIt  := FALSE

* Save current prompt line
prompt_buf := SAVESCREEN(24,0,24,79)

* Show status
PromptLine("Getting Table Info...")

IF PCOUNT() < 1
    TableName := EB_Table()
    IF EMPTY(TableName)
        * Restore the prompt line
        RESTSCREEN(24,0,24,79,prompt_buf)
        RETURN(FALSE)
    ENDIF
    TArea := old_area
ELSE
    IF TYPE("TableName") != "C"
        RETURN(FALSE)
    ENDIF
ENDIF

TArea := EB_AreaOf(TableName)
IF TArea < 1
    IF EB_Select(0) < 1
        PromptLine("ERROR!  Press any key to continue...")
        Error_msg("ERROR: TableInfo()", "No area free to open table")
        * Restore the prompt line
        RESTSCREEN(24,0,24,79,prompt_buf)
        RETURN(FALSE)
    ENDIF
    IF ! EB_Use(TableName)
        PromptLine("ERROR!  Press any key to continue...")
        Error_msg("ERROR: TableInfo()", EB_ErrorMsg())
        * Restore the prompt line
        RESTSCREEN(24,0,24,79,prompt_buf)
        RETURN(FALSE)
    ENDIF
    CloseIt := TRUE
ELSE
    EB_Select(TArea)
ENDIF

TAlias := EB_Alias()
IF EMPTY(TAlias)
    TAlias := "(none)"
ENDIF

TOwner := EB_TblOwner()

TPerm  := EB_TblPerm()

TRecs  := LTRIM(STR(EB_RecCount()))

IF CloseIt
    EB_Use()
ENDIF

EB_Select(old_area)

old_color := SETCOLOR(MsgColor)

screen_buf := SAVESCREEN(7,13,16,65)
@  7,13,16,65 BOX SglFrame
@  7,33 SAY "[ Table Info ]"
@  9,25 SAY "Name:"
@ 11,24 SAY "Alias:"
@ 12,24 SAY "Owner:"
@ 13,19 SAY "Permission:"
@ 14,17 SAY "# of Records:"
@ 16,24 SAY "[ Press any key to continue... ]"

SETCOLOR(MsgHigh)

@  9,31 SAY TableName
@ 11,31 SAY TAlias
@ 12,31 SAY TOwner
@ 13,31 SAY TPerm
@ 14,31 SAY TRecs

PromptLine("Table Information for "+TableName)

INKEY(0)

* Restore old color
SETCOLOR(old_color)

* Restore the screen
RESTSCREEN(7,13,16,65,screen_buf)

* Restore the prompt line
RESTSCREEN(24,0,24,79,prompt_buf)

RETURN(TRUE)


*- IndexInfo() -------------------------------------------------------------

FUNC IndexInfo

PARAMETERS IdxName

PRIVATE old_color,screen_buf,prompt_buf,ICase,IType,IKey,IKeyStr[6],i,pos

* Save current prompt line
prompt_buf := SAVESCREEN(24,0,24,79)

* Show status
PromptLine("Getting Index Info...")

ICase := EB_IdxCase(0,IdxName)

IType := EB_IdxType(0,IdxName)

IKey  := EB_IdxKey(0,IdxName)

AFILL(IKeyStr,NULL)

i := 1

DO WHILE ! EMPTY(IKey)
    IKeyStr[i] := IF(LEFT(IKey,1)=="+", CHR(24), CHR(25))
    pos := AT(";",IKey)

    IF pos ==0
        IKeyStr[i] := IKeyStr[i] + " " + SUBSTR(IKey,2)
        IKey := ""
    ELSE
        IKeyStr[i] := IKeyStr[i] + " " + SUBSTR(IKey,2,pos-2)
        IKey := SUBSTR(IKey,pos+1)
    ENDIF
    i++
ENDDO

old_color := SETCOLOR(MsgColor)

screen_buf := SAVESCREEN(7,13,19,65)
@  7,13,19,65 BOX SglFrame
@  7,33 SAY "[ Index Info ]"
@  9,29 SAY "Name:"
@ 11,18 SAY "Case Sensitive?:"
@ 12,29 SAY "Type:"
@ 13,23 SAY "Key Fields:"
@ 19,24 SAY "[ Press any key to continue... ]"

SETCOLOR(MsgHigh)

@  9,35 SAY IdxName
@ 11,35 SAY IF(ICase, "Yes", "No")
@ 12,35 SAY IType
@ 13,35 SAY IKeyStr[1]
@ 14,35 SAY IKeyStr[2]
@ 15,35 SAY IKeyStr[3]
@ 16,35 SAY IKeyStr[4]
@ 17,35 SAY IKeyStr[5]
@ 18,35 SAY IKeyStr[6]

PromptLine("Index Information for "+IdxName)

INKEY(0)

* Restore old color
SETCOLOR(old_color)

* Restore screen
RESTSCREEN(7,13,19,65,screen_buf)

* Restore the prompt line
RESTSCREEN(24,0,24,79,prompt_buf)

RETURN(TRUE)


*- FieldInfo() -------------------------------------------------------------

FUNC FieldInfo

PARAMETERS Field

PRIVATE old_color,FName,FLabel,FType,FTypeStr,FLen,FReplics,Frequired,FPerm,;
        FDefFlag,FDefValue,FPict,FMask,FFlags,FHighVal,FLowVal,screen_buf,;
        prompt_buf

IF PCOUNT() < 1
    RETURN(FALSE)
ENDIF

* Save current prompt line
prompt_buf := SAVESCREEN(24,0,24,79)

* Show status
PromptLine("Getting Field Info...")

FName := TRIM(Field)
IF EMPTY(FName)
    PromptLine("ERROR!  Press any key to continue...")
    Error_msg("ERROR: Field Name Required!")
    * Restore the prompt line
    RESTSCREEN(24,0,24,79,prompt_buf)
    RETURN(FALSE)
ENDIF

FLabel := EB_FldLabel(Field)
IF FLabel == FName
    FLabel := "(none)"
ENDIF

FType := EB_FldType(Field)
DO CASE
    CASE FType == "PAK"
        FTypeStr := "Packed Numeric Characters"
    CASE FType == "STR"
        FTypeStr := "String"
    CASE FType == "INT"
        FTypeStr := "Integer"
    CASE FType == "LNG"
        FTypeStr := "Long Integer"
    CASE FType == "DBL"
        FTypeStr := "Double Precision Floating Point"
    CASE FType == "BCD"
        FTypeStr := "Binary Coded Decimal (BCD)"
    CASE FType == "DAT"
        FTypeStr := "Date"
    CASE FType == "TIM"
        FTypeStr := "Time"
    CASE FType == "LOG"
        FTypeStr := "Logical"
    CASE FType == "BIN"
        FTypeStr := "Binary"
    OTHERWISE
        FTypeStr := "Unknown"
ENDCASE

IF FType $ "PAK|STR"
    FLen := LTRIM(STR(EB_FldLen(Field)))
ELSE
    FLen := "n/a"
ENDIF

FReplics := LTRIM(STR(EB_FldReplics(Field)))

FRequired := EB_FldRequired(Field)

FPerm := EB_FldPerm(Field)

FDefFlag := EB_FldDFlag(Field)

IF FDefFlag
    FDefValue := EB_FldDefault(Field)
ELSE
    FDefValue := "n/a"
ENDIF

FPict := EB_FldPict(Field)

FMask := EB_FldMask(Field)

FFlags := EB_FldFlags(Field)

IF FType == "DBL"
    FHighVal := LTRIM(STR(EB_FldHigh(Field)))
    FLowVal  := LTRIM(STR(EB_FldLow(Field)))
ELSE
    FHighVal := "n/a"
    FLowVal  := "n/a"
ENDIF

old_color := SETCOLOR(MsgColor)

screen_buf := SAVESCREEN(4,13,21,65)
@  4,13,21,65 BOX SglFrame
@  4,33 SAY "[ Field Info ]"
@  6,25 SAY "Name:"
@  7,24 SAY "Label:"
@  8,25 SAY "Type:"
@  9,23 SAY "Length:"
@ 10,17 SAY "Replications:"
@ 11,20 SAY "Required?:"
@ 12,19 SAY "Permission:"
@ 13,16 SAY "Have Default?:"
@ 14,16 SAY "Default Value:"
@ 15,22 SAY "Picture:"
@ 16,25 SAY "Mask:"
@ 17,24 SAY "Flags:"
@ 18,20 SAY "Min Value:                   <- none if 0.00"
@ 19,20 SAY "Max Value:                   <- none if 0.00"
@ 21,24 SAY "[ Press any key to continue... ]"

SETCOLOR(MsgHigh)

@  6,31 SAY FName
@  7,31 SAY FLabel
@  8,31 SAY FTypeStr
@  9,31 SAY FLen
@ 10,31 SAY FReplics
@ 11,31 SAY IF(FRequired,"Yes","No")
@ 12,31 SAY FPerm
@ 13,31 SAY IF(FDefFlag,"Yes","No")
@ 14,31 SAY FDefValue
@ 15,31 SAY FPict
@ 16,31 SAY FMask
@ 17,31 SAY FFlags
@ 18,31 SAY FLowVal
@ 19,31 SAY FHighVal

PromptLine("Field Information for "+FName)

INKEY(0)

* Restore old color
SETCOLOR(old_color)

* Restore screen
RESTSCREEN(4,13,21,65,screen_buf)

* Restore the prompt line
RESTSCREEN(24,0,24,79,prompt_buf)

RETURN(TRUE)


