#include "c5eb.ch"
****************************************************************************
*
*   LADIES AND GENTLEMEN, THE FUNCTIONS!
*

*- Cls() -------------------------------------------------------------------
*
* Clears the screen using CHR(177) as a screen background.

FUNC Cls

PRIVATE old_color

* Save the old color
old_color := SETCOLOR(BackColor)

* Clear the screen using a fill char and no frame (see def for TxtFrame)
@ 0,0,24,79 BOX TxtFrame

* Draw an empty prompt line
PromptLine("")

* Restore old color
SETCOLOR(old_color)

RETURN(TRUE)


*- Error_msg() -------------------------------------------------------------

FUNC Error_msg

PARAMETERS Msg1, Msg2

PRIVATE old_color,screen_buf,MsgWidth,LCol,RCol

Msg1 := IF(TYPE("Msg1")=="C", TRIM(Msg1), "ERROR!")
Msg2 := IF(TYPE("Msg2")=="C", TRIM(Msg2), NULL)

MsgWidth := MAX(LEN(Msg1),LEN(Msg2))
MsgWidth := MAX(MsgWidth,16)         && allow for width of "Press an key..."

LCol     := INT((80 - (MsgWidth + 6)) / 2)
RCol     := LCol + MsgWidth + 6

screen_buf := SAVESCREEN(9,LCol,15,RCol)
old_color  := SETCOLOR(ErrColor)

@ 9,LCol,15,RCol BOX DblFrame
@ 11,LCol + 3 SAY Msg1
@ 12,LCol + 3 SAY Msg2
@ 14,32 SAY "Press any key..."
INKEY(0)

SETCOLOR(old_color)
RESTSCREEN(9,LCol,15,RCol,screen_buf)

RETURN(TRUE)


*- PromptLine() ------------------------------------------------------------
*
* Display a prompt or instruction (or whatever) on line 24

FUNC PromptLine

PARAMETERS PromptText

PRIVATE old_color

* Save the old color
old_color := SETCOLOR(PromptColor)

* Clear the prompt line
@ 24,0

* Display the prompt text
@ 24,1 SAY PromptText

* Restore the original color
SETCOLOR(old_color)

RETURN(TRUE)


*- Disclaimer() ------------------------------------------------------------

FUNC disclaimer

PRIVATE pcount,line_1,line_2,line_3,footing,top_row,left_col,;
        bottom_row,right_col

scrnbuf := SAVESCREEN(3,19,20,61)
@ 3,19,20,61 BOX DblFrame

@  5,20 SAY " Hey there, fellow ClipperHeads!         "
@  6,20 SAY "                                         "
@  7,20 SAY " This is a sample program to show some   "
@  8,20 SAY " of the features of CLIP2EB - the first  "
@  9,20 SAY " product in the BabelFish Library Series "
@ 10,20 SAY " from SuccessWare 90,Inc.                "
@ 11,20 SAY "                                         "
@ 12,20 SAY " This program is for demonstration       "
@ 13,20 SAY " purposes only, and does not constitute  "
@ 14,20 SAY " a commercial-quality application. That  "
@ 15,20 SAY " is up to you to do.  Feel free to use   "
@ 16,20 SAY " any of this code in your own programs.  "
@ 17,20 SAY "                                         "
@ 18,20 SAY " Have fun!                               "
@ 20,24 SAY "[ Press any key to continue... ]"

INKEY(10)
RESTSCREEN(3,19,20,61,scrnbuf)

RETURN(TRUE)


