Hi!

The below is a 'cool' little routine showing how to move an object around
on the screen (on top of a surface), using a codeblock and the by-ref op.

No boundary checking on this one (figure it out!), but try the cursor 
keys, and move the "<<< USING A CODEBLOCK AND THE '@' OPERATOR >>>" around.

Also, the save/restore screen calls could be modified to ONLY 'invalidate'
the background area that needs to be updated.

If you don't understand how the by-ref operator really works, read up on
it, it might help with problems you didn't quite know how to solve before.
(Like 'returning' multiple values from one function call).  Knock your
socks off!

***
*   PROGRAM: BREF.PRG
*   DATE   : 06/10/91
*   NOTE   : Sample code showing how to use codeblocks and by-reference op
*   NOTICE : Copyright Rognerud-Wilson Software (c) 1991 - Jon Rognerud.
*   COMMENT: Compile with /n/w
***

#include "inkey.ch"

FUNCTION Go
LOCAL nRow := 1		// Starting row position
LOCAL nCol := 1		// Starting col position

LOCAL bBlock		// The codeblock!
LOCAL nInKey		// INKEY() value
LOCAL cBackScreen	// Screen save variable

LOCAL sItem := "<<< USING A CODEBLOCK AND THE '@' OPERATOR >>>"

// notice the '@' guys...
bBlock := { |k, r, c| UpdatePoints(k, @r, @c) }

WHILE .T.	// forever
    cBackScreen := SAVESCREEN( 0, 0, Maxrow(), Maxcol() )

	@ nRow, nCol SAY sItem

	// output coordinates as we move
	@ 0, 70 SAY LTRIM(STR(nRow))+","+LTRIM(STR(nCol))

	nKey := INKEY(0)
	IF nKey != K_ESC
		EVAL(bBlock, nKey, @nRow, @nCol)	// notice the '@' guys...
	ELSE
		EXIT
	END

    RESTSCREEN( 0, 0, Maxrow(), Maxcol(), cBackScreen )

END
RETURN (NIL)

/***
*	UpdatePoints(<nKey>,<nRow>,<nCol>) --> NIL
*
*   Variables 'r' and 'c' update the variables in the routine (codeblock)
*	they were called from (by-ref).
*/
STATIC FUNCTION UpdatePoints(nKey, r, c)
DO CASE
	CASE nKey == K_LEFT
	    c--
	CASE nKey == K_RIGHT
	    c++
	CASE nKey == K_UP
		r--
	CASE nKey == K_DOWN
		r++
END
RETURN (NIL)
