/* color.h */
/*   */
/* Color Attribute has the following breakout                       */
/* BbbbIfff where:                                                  */
/*      ^^^------foreground color value                             */
/*     ^---------intensity setting (only applies to foreground)     */
/*  ^^^----------background color value                             */
/* ^-------------blink value                                        */
/*   */
/* Add the wanted values to get the attribute value.                */
/* For example create Blinking Yellow (foreground) on Blue          */
/* (background)                                                     */
/* nAttribute = FCBlinkOn + BCBlue + FCIntensityOn + FCBrown        */
/* (as intense Brown creates Yellow)                                */
/*   */
/* ------- Foreground Colors ------- */
#define FCBlack   0
#define FCBlue    1
#define FCGreen   2
#define FCCyan    3
#define FCRed     4
#define FCMagenta 5
#define FCBrown   6
#define FCGray    7
#define FCWhite   7
/*   */
/* ------- Intensity ------- */
/* only foreground colors may be made lighter (intense)             */
/* for example Blue with Intense (on) creates a Light Blue          */
/* Foreground                                                       */
#define FCIntensityOn 8
#define FCIntensityOff 0
/*   */
/* ------- Background Colors ------- */
#define BCBlack    0
#define BCBlue    16
#define BCGreen   32
#define BCCyan    48
#define BCRed     64
#define BCMagenta 80
#define BCBrown   96
#define BCGray   112
#define BCWhite  112
/*   */
/* ------- Blink Foreground ------- */
#define FCBlinkOn  128
#define FCBlinkOff   0
/*   */
union {
  unsigned int attrib;
  struct {
    unsigned int f1        : 1;
    unsigned int f2        : 1;
    unsigned int f3        : 1;
    unsigned int intensity : 1;
    unsigned int b1        : 1;
    unsigned int b2        : 1;
    unsigned int b3        : 1;
    unsigned int blink     : 1;
  } bits;
} va;
/*   */
#define BIOS_VIDEO 0x10
/*   */
char *aColors[] = {"Black", "Blue", "Green", "Cyan", "Red", "Magenta",
             "Brown", "Gray", "Black", "Light Blue", "Light Green",
             "Light Cyan", "Light Red", "Light Magenta", "Yellow",
             "White"};

