*********************************************************************
*  Function: BoxExpand.PRG
*  Writer: Kraig Krist/TBCS
*          PO Box 711
*          Annandale, VA 22003-0711
*  Date: September 1993
*  Description: Explode box from a single . (dot) to proper size.
*********************************************************************
*
*   ***** Function Specifications *****
*
*   Passed In: Top, Left, Bottom, Right, Box Frame, Shade Control
*
*   Returns: Nothing
*
*********************************************************************
*           ---- Modification Log ----
*  When:
*   Why:
*********************************************************************
#Include "BOX.CH"
#Include "SETCURS.CH"
EXTERNAL BoxShade
FUNCTION BoxExpand(nTop,nLeft,nBottom,nRight,cBoxFrame,lShade)
*********************************************************************
*  Declare Variables
*********************************************************************
  LOCAL GETLIST := {}
  LOCAL nWLeft, nMRow, nWRight, nMCol, nWTop, nWBottom, lFirstTime
  Local l1stEqual, nHeight, nWidth
*********************************************************************
*  Initialize Variables
*********************************************************************
  nHeight := (nBottom - nTop) + 1
  nWidth := (nRight - nLeft) + 1
  SetCursor(SC_NONE)
  lFirstTime := l1stEqual := .T.
  nMRow := INT(((nTop + nBottom) / 2))
  nMCol := INT(((nLeft + nRight) / 2))
  nWTop := nWBottom := nMRow
  nWLeft := nWRight := nMCol
*********************************************************************
*  Explode Box from single . (dot) to actual size.
*********************************************************************
  Do While (nWTop >= nTop) .or.;
           (nWBottom <= nBottom) .or.;
           (nWLeft >= nLeft) .or.;
           (nWRight <= nRight)
    Do Case
      Case nWTop = nMRow .and. nWLeft = nMCol
        If lFirstTime
          lFirstTime := .F.
          @ nWTop,nWLeft Say Chr(7)
          Loop
        Else
          @ nWTop,nWLeft Say Chr(9)
        EndIf
      Case nWTop = (nMRow - 1) .and. nWLeft = (nMCol - 1)
        Do Case
          Case nHeight = nWidth
            @ nWTop,nWLeft Say Chr(22)
          Case nHeight > nWidth
            @ nWTop,nWLeft Say Chr(220)
          Otherwise
            @ nWTop,nWLeft Say Chr(219)
        EndCase
      Otherwise
        @ nWTop,nWLeft Clear To nWBottom,nWRight
        @ nWTop,nWLeft,nWBottom,nWRight Box cBoxFrame
    EndCase
    If nWTop > nTop
      nWTop--
    EndIF
    If nWBottom < nBottom
      nWBottom++
    EndIF
    If nWLeft > nLeft
      nWLeft--
    Endif
    If nWRight < nRight
      nWRight++
    Endif
    If (nWTop = nTop) .and.;
       (nWBottom = nBottom) .and.;
       (nWLeft = nLeft) .and.;
       (nWRight = nRight)
      If l1stEqual
        l1stEqual := .F.
      Else
        nWTop--
        nWBottom++
        nWLeft--
        nWRight++
      Endif
    Endif
  EndDo
  If lShade
*********************************************************************
*  Shade Option.
*********************************************************************
    BoxShade(nTop,nLeft,nBottom,nRight)
  EndIf
  SetCursor(SC_NORMAL)
RETURN(NIL)
