/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990, 1991, 1992 BecknerVision Inc - All Rights Reserved

    Written by John Wm Beckner        THIS NOTICE MUST NOT BE REMOVED
    BecknerVision Inc
    PO Box 11945                      DISTRIBUTE ONLY WITH SHAREWARE
    Winston-Salem NC 27116            VERSION OF THIS PRODUCT.
    Fax: 919/760-1003

*/

#include "beckner.inc"
#define PMT_DATE     1
#define PMT_AMOUNT   2
#define PRINCIPAL    3
#define INTEREST     4
#define BALANCE      5

FUNCTION Main()
   LOCAL cVersion := "v1.1", nNumPmts := 180, nLoan := 6320.00, GetList := {}
   LOCAL nAPR := 9, dStart := dBegMonth(dSame()), nCtr, aSchedule
   LOCAL nTotalPrinc := 0.00, nTotalInt := 0.00
   CLS
   @ 0,0 SAY 'Beckner Amortization Schedule '+cVersion
   @ 1,0 SAY 'Copyright (c)1990 John Wm Beckner - All Rights Reserved'
   @ 3,0 SAY '# of payments ............' get nNumPmts pict '999'
   @ 4,0 SAY 'Starting balance .........' get nLoan pict '999,999.99'
   @ 5,0 SAY 'First payment due date ...' get dStart
   @ 6,0 SAY 'APR ......................' get nAPR pict '99.99999'
   READ
   aSchedule := mAmortSched(nLoan, nAPR, nNumPmts, dStart)
   CLS
   FOR nCtr := 1 TO nNumPmts
      ? Str(nCtr, 4),                     /* payment number               */;
            aSchedule[nCtr, PMT_DATE],    /* payment due date             */;
            aSchedule[nCtr, PMT_AMOUNT],  /* payment amount due           */;
            aSchedule[nCtr, PRINCIPAL],   /* principal                    */;
            aSchedule[nCtr, INTEREST],    /* interest                     */;
            aSchedule[nCtr, BALANCE]      /* balance due after payment    */
      nTotalPrinc += aSchedule[nCtr, PRINCIPAL]
      nTotalInt   += aSchedule[nCtr, INTEREST]
      vPause()
   NEXT
   ?
   ? 'Totals', nTotalPrinc, nTotalInt
   vAnyKey()
ENDFUNCTION
