/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"
#include "directry.ch"

////////////////
////////////////
//
// Purpose:
//    Creates batch file for creation of Beckner.Lib
//
// Syntax:
//    C> BATSETUP [<cCode>]
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    cCode       appended to CLIPPER command name
//
// Description:
//    Creates batch file for creation of Beckner.Lib.  BecknerVision Inc uses
//    the name CLIPPER5.EXE to differentiate it from our S'87 version, which
//    is where <cCode> comes in.  By specifying BATSETUP 5, the normal
//    CLIPPER command is changed to CLIPPER5.  Also, this program is designed
//    to be run from a batch file called NEWLIB.BAT, which has the following
//    contents:
//
//       CLS
//       loadfix BatSetup %1
//       cd prg
//       Call ObjMake
//       echo off
//       echo WARNING:  This next operation deletes BECKNER.LIB
//       echo before recreating it.
//       echo Press ctrl-C to abort or
//       pause
//       cd ..
//       echo on
//       DEL BECKNER.LIB
//       Lib Beckner @Beckner.lmk>>prn
//       
// Category:
//    Utility Program
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION BatSetup(cNumber)
   LOCAL nRow, aSubDir, aSource, nBatch, nCtr, nSubDirs, nCtr2, nFiles
   LOCAL nLibMake
   ? "Batch Setup for library creation for BECKNER.LIB v1.1"
   ? "Copyright (c)1991, 1993 BecknerVision Inc - All Rights Reserved"
   ?
   iif(cNumber=NIL, cNumber := "", NIL)
   fChDir("PRG")
   nRow := Row()
   @ nRow, 0
   @ nRow, 0 say "Processing subdirectories ..."
   nBatch := fCreate("OBJMAKE.BAT")
   nLibMake := fCreate("..\BECKNER.LMK")
   nSubDirs := len(aSubDir := Directory("*.*", "D"))
   fKill("errs", "\")
   FOR nCtr := 1 to nSubDirs
      IF !"D"$aSubDir[nCtr, F_ATTR]
         LOOP
      ENDIF
      @ nRow, 30
      @ nRow, 30 say aSubDir[nCtr, 1]
      nFiles := len(aSource := Directory(aSubDir[nCtr, 1]+"\*.PRG"))
      IF aSubDir[nCtr, 1]="ASM" .or. Left(aSubDir[nCtr, 1], 1)=="." .or.;
         !"D"$aSubDir[nCtr, 5]
         LOOP
      ENDIF
      fWriteLine(nBatch, "ChDir "+aSubDir[nCtr, 1])
      fWriteLine(nBatch, "Del *.bak")
      fWriteLine(nBatch, "Del *.obj")
      FOR nCtr2 := 1 to nFiles
         fWriteLine(nBatch,;
         "Clipper"+cNumber+" "+aSource[nCtr2, 1]+" -n-m-w-l>>\errs")
         fWriteLine(nLibMake, "+PRG\"+aSubDir[nCtr, 1]+"\"+;
         fExtNew(aSource[nCtr2, 1], "OBJ")+" &")
      NEXT
      fWriteLine(nBatch, "ChDir ..")
   NEXT
   fWriteLine(nLibMake, "+PRG\ASM\BECKNERA;")
   fClose(nBatch)
   fClose(nLibMake)
   fChDir("..")
ENDFUNCTION
