#define LOOPING .y.
#define ENDWHILE END
#define CRLF chr(13)+chr(10)
#define CTRL_Z chr(26)
#define CR chr(13)
#define LF chr(10)
#define FORMFEED chr(12)

#xcommand INT86 <int>                                                   ;
          [AX <ax>]                                                     ;
          [BX <bx>]                                                     ;
          [CX <cx>]                                                     ;
          [DX <dx>]                                                     ;
          [AL <al>]                                                     ;
          [AH <ah>]                                                     ;
          [BL <bl>]                                                     ;
          [BH <bh>]                                                     ;
          [CL <cl>]                                                     ;
          [CH <ch>]                                                     ;
          [DL <dl>]                                                     ;
          [DH <dh>]                                                     ;
      =>  pInt86(<int>, <ax>, <bx>, <cx>, <dx>, <ah>, <al>, <bh>, <bl>,;
                 <ch>, <cl>, <dh>, <dl>)

#command COMPUTE  [INTO ] <tarray>                                      ;
                  FROM <farray>                                         ;
                  [FOR <for>]                                           ;
                  [WHILE <while>]                                       ;
                  [NEXT <next>]                                         ;
                  [RECORD <rec>]                                        ;
                  [<rest:REST>]                                         ;
                  [ALL]                                                 ;
            =>    <tarray> := {},                                       ;
                  aEval(<farray>, {||aAdd(<tarray>, 0)})

////////////////
////////////////
//
// Purpose:
//    
//
// Syntax:
//    SET SAVEBLOCK TO [<bAny>]
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    bAny        Any valid code block
//
// Files:
//    none
//
// Description:
//    Establishes or resets the code block to be executed as a screen saver.
//
// See Also:
//    pSetSaver()
//
// Category:
//    Command
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command USE                    => dbClearRel()                         ;
                                 ; dbCloseArea()

#command CLOSE                  => USE

////////////////
////////////////
//
// Purpose:
//    Adds clauses to @...GET command: MESSAGE, POPUP, EXIT, DATESET, etc
//
// Syntax:
//    <see @...GET command> [MESSAGE <cMsg>] [POPUP <bList>] [DATESET]
//          [EXIT [WITH] <cKey>] [IDLE <bIdle>] 
//          [MEMO [AT] <nTR>, <nTC>, <nBR>, <nBC>]
//
// Formal Arguments: (8)
//    Name        Description
//    ___________ ____________
//    cMsg        Any text
//    bList       Code block defining popup list
//    cKey        Key to cause exit from READ
//    bIdle       Code block to execute during idle time
//    nTR         Top row number for memo
//    nTC         Top column number for memo
//    nTR         Bottom row number for memo
//    nTC         Bottom column number for memo
//
// Files:
//    none
//
// Description:
//    Adds functionality to @...GET command.  The MESSAGE clause causes a
//    message to be placed at the line defined in the SET MESSAGE TO command.
//    The POPUP clause is not active.  The DATESET clause allows the use of
//    the <> and <-> key for changing date values.  The EXIT clause allows a
//    special key to be defined which will cause the exiting of this field.
//    The IDLE clause causes the specified code block to be executed during
//    idle time while within this GET field.  The MEMO clause sets the size
//    and placement of an editing area for a memo.
//
// Category:
//    Command
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command @ <row>, <col> GET <var>                                    ;
            [PICTURE <pic>]                                          ;
            [VALID <valid>]                                          ;
            [WHEN <when>]                                            ;
            [COLOR <color>]                                          ;
            [MESSAGE <message>]                                      ;
            [POPUP <pop>]                                            ;
            [EXIT [WITH] <exitkey>]                                  ;
            [<date: DATESET>]                                        ;
            [IDLE <idleB>]                                           ;
            [MEMO [AT] <memoTR>, <memoTC>, <memoBR>, <memoBC>]       ;
                                                                     ;
         => SetPos( <row>, <col> ); aAdd( GetList,                   ;
            _GET_( <var>, <(var)>, <pic>, <{valid}>, <{when}> ) )    ;
            ; aTail(GetList):reader := {|oGet| vGet(oGet)}           ;
            [ ; aTail(GetList):colorDisp( <color> ) ]                ;
            ; aTail(GetList):cargo := {}                             ;
            [; aAdd(aTail(GetList):cargo, {"M", <"message"> } ) ]    ;
            [; aAdd(aTail(GetList):cargo, {"E", <(exitkey)> } ) ]    ;
            [; aAdd(aTail(GetList):cargo, {"I", <{idleB}> } ) ]      ;
            [; aAdd(aTail(GetList):cargo, {"P", <{pop}> } ) ]        ;
            [; aAdd(aTail(GetList):cargo, {"Z", { <memoTR>, <memoTC>, <memoBR>, <memoBC> } } ) ; aTail(GetList):picture := ""] ;
            [; iif( <.date.>, aAdd(aTail(GetList):cargo, {"D"} ), ) ]

////////////////
////////////////
//
// Purpose:
//    Adds IDLE clause to READ command
//
// Syntax:
//    READ [IDLE <bExec> [TIME <nSecs>]]
//
// Formal Arguments: (2)
//    Name        Description
//    ___________ ____________
//    bExec       Code block to execute during idle time
//    nSecs       Seconds between each execution of <bExec>
//
// Files:
//    none
//
// Description:
//    Adds the IDLE clause to the READ command.  <bExec> is a code block to
//    execute every <nSecs> seconds of idle time during the READ command
//    execution.
//
// See Also:
//    fLocRec()
//
// Category:
//    Command
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command READ [IDLE <bExec> [TIME <nSecs>] ]                         ;
      => iReadIdle( [ <{bExec}> ] [, <nSecs>] )                      ;
       ; ReadModal(GetList)                                          ;
       ; GetList := {}

////////////////
////////////////
//
// Purpose:
//    Gives NIL parameters default values
//
// Syntax:
//    DEFAULT <cVar> TO <xExpr> [, <cVarN> TO <xExprN>]
//
// Formal Arguments: (2)
//    Name        Description
//    ___________ ____________
//    cVar        Parameter
//    xExpr       Default expression
//
// Files:
//    none
//
// Description:
//    Assigns default values to NIL parameters.
//
// Category:
//    Command
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command DEFAULT <var1> TO <val1> [, <varN> TO <valN>]               ;
                                                                     ;
         => iif( <var1> = NIL, <var1> := <val1> ,)                   ;
            [; iif( <varN> = NIL, <varN> := <valN> ,)]

////////////////
////////////////
//
// Purpose:
//    Invokes the fAddRecord() function
//
// Syntax:
//    ADDRECORD [ALIAS <cAlias>]
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    cAlias      Work area name
//
// Files:
//    none
//
// Description:
//    Invokes the fAddRecord() function.
//
// See Also:
//    fAddRecord()
//
// Category:
//    Command
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command ADDRECORD            => fAddRecord()
#command ADDRECORD ALIAS <a>  => <a> -> ( fAddRecord() )

////////////////
////////////////
//
// Purpose:
//    Invokes the fLockRec() function
//
// Syntax:
//    LOCK [ALIAS <cAlias>]
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    cAlias      Work area name
//
// Files:
//    none
//
// Description:
//    Invokes the fLockRec() function.
//
// See Also:
//    fLockRec()
//
// Category:
//    Command
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command LOCK                 => fLockRec()
#command LOCK ALIAS <a>       => <a> -> ( fLockRec() )

/* #xtranslate INDICES => INDEXES */

////////////////
////////////////
//
// Purpose:
//    Initializes variables
//
// Syntax:
//    INITIALIZE <cVar> TO <xExpr> [, <cVarN> TO <xExprN>]
//
// Formal Arguments: (2)
//    Name        Description
//    ___________ ____________
//    cVar        Memory variable or aliased field name
//    xExpr       Initial value
//
// Files:
//    none
//
// Description:
//    Initializes the specified variable if it is currently undefined.
//
// Category:
//    Command
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command INITIALIZE <var1> TO <val1> [, <varN> TO <valN>]            ;
                                                                     ;
         => iif( Type( <"var1"> ) = "U", <var1> := <val1> ,)         ;
            ; [iif( Type( <"varN"> ) = "U", <varN> := <valN> ,)]

////////////////
////////////////
//
// Purpose:
//    Forces a value into a specific type
//
// Syntax:
//    FORCETYPE <xAny> TO <cType> [, <xAnyN> TO <cTypeN>]
//
// Formal Arguments: (2)
//    Name        Description
//    ___________ ____________
//    xAny        Any expression
//    cType       Valid types (see pSetType() for information)
//
// Files:
//    none
//
// Description:
//    Forces the type of an expression to be a specific type.  See pSetSaver()
//    for complete information.
//
// See Also:
//    pSetSaver()
//
// Category:
//    Command
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command FORCETYPE <AnyType1> TO <SetType1> [, <AnyTypeN> TO <SetTypeN>]     ;
            => pSetType({|uNewValue|iif(uNewValue=NIL,                       ;
                        <AnyType1>, <AnyType1> := uNewValue)}, <"SetType1">) ;
             [;pSetType({|uNewValue|iif(uNewValue=NIL,                       ;
                        <AnyTypeN>, <AnyTypeN> := uNewValue)}, <"SetTypeN">)]

////////////////
////////////////
//
// Purpose:
//    Physical end of a FUNCTION
//
// Syntax:
//    ENDFUNCTION
//
// Formal Arguments: (0)
//
// Files:
//    none
//
// Description:
//    Establishes the physical end of a FUNCTION.
//
// See Also:
//    ENDPROCEDURE
//
// Category:
//    Command
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command ENDFUNCTION    => RETURN NIL

////////////////
////////////////
//
// Purpose:
//    Physical end of a PROCEDURE
//
// Syntax:
//    ENDPROCEDURE
//
// Formal Arguments: (0)
//
// Files:
//    none
//
// Description:
//    Establishes the physical end of a PROCEDURE.
//
// See Also:
//    ENDFUNCTION
//
// Category:
//    Command
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command ENDPROCEDURE   => RETURN

////////////////
////////////////
//
// Purpose:
//    Sets or resets the Time-Out value for the screen saver
//
// Syntax:
//    SET SAVETIME TO [<nSeconds>]
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    nSeconds    Idle time before screen saver is invoked
//
// Files:
//    none
//
// Description:
//    Sets the amount of time before the screen saver is invoked during READs.
//
// See Also:
//    pSetSaver()
//
// Category:
//    Command
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET SAVETIME TO <n>                 => pSetSaver( <n> )
#command SET SAVETIME TO                     => pSetSaver( 0 )

////////////////
////////////////
//
// Purpose:
//    Establishes the SAVETIME code block
//
// Syntax:
//    SET SAVEBLOCK TO [<bAny>]
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    bAny        Any valid code block
//
// Files:
//    none
//
// Description:
//    Establishes or resets the code block to be executed as a screen saver.
//
// See Also:
//    pSetSaver()
//
// Category:
//    Command
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET SAVEBLOCK TO <todo>             => pSetSaver( , <{todo}> )
#command SET SAVEBLOCK TO                    => pSetSaver( , Default() )

////////////////
////////////////
//
// Purpose:
//    Defines a block of code which may be EXITed or LOOPed
//
// Syntax:
//    BEGIN BLOCK
//    END[ ]BLOCK
//
// Formal Arguments: (0)
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       BEGIN BLOCK
//         /* any code */
//       END BLOCK
//    ENDFUNCTION
//
// Files:
//    none
//
// Description:
//    Defines a block of code.  Within this block of code, you may issue
//    LOOP and EXIT commands.  The block does not automatically repeat.
//
// See Also:
//    WHILE LOOPING
//
// Category:
//    Command
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command BEGIN BLOCK    => WHILE LOOPING
#command ENDBLOCK       => EXIT; ENDWHILE
#command END BLOCK      => EXIT; ENDWHILE

////////////////
////////////////
//
// Purpose:
//    Invokes the fBrowse() function
//
// Syntax:
//    BROWSE [ALIAS <cAlias>]
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    cAlias      Work area name [current]
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       CreateTest()
//       BROWSE
//       CLOSE Test
//    ENDFUNCTION
//
//    #include "alias.ch"
//    STATIC FUNCTION CreateTest()
//       fCreateDbf("Test/Name/C/32/Balance/N/12/2/Date/D/Over21/L/Notes/M")
//       USE Test NEW EXCLUSIVE
//       ADDRECORD ALIAS Test
//       Test->Name    := "Abbott, Jake"
//       Test->Balance := 0.00
//       Test->Date    := CtoD("9/26/94")
//       Test->Over21  := .y.
//       Test->Notes   := ""
//       ADDRECORD ALIAS Test
//       Test->Name    := "Beckner, John Wm"
//       Test->Balance := 15000.00
//       Test->Date    := CtoD("9/26/94")
//       Test->Over21  := .y.
//       Test->Notes   := "These are notes!"
//       ADDRECORD ALIAS Test
//       Test->Name    := "Beckner, Elizabeth Anne"
//       Test->Balance := 0.58
//       Test->Date    := CtoD("12/18/96")
//       Test->Over21  := .n.
//       Test->Notes   := ""
//       ADDRECORD ALIAS Test
//       Test->Name    := "Beckner, Joseph Alan"
//       Test->Balance := 1.68
//       Test->Date    := CtoD("6/10/98")
//       Test->Over21  := .n.
//       Test->Notes   := "These are too!"
//       ADDRECORD ALIAS Test
//       Test->Name    := "Zumundi, Beavis"
//       Test->Balance := 123.45
//       Test->Date    := CtoD("")
//       Test->Over21  := .y.
//       Test->Notes   := ""
//       GO TOP
//    ENDFUNCTION
//
// Files:
//    (current work area)
//
// Description:
//    Invokes the fBrowse() function.
//
// See Also:
//    fBrowse()
//
// Category:
//    Command
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command BROWSE               => fBrowse()
#command BROWSE ALIAS <a>     => <a> -> ( fBrowse() )

////////////////
////////////////
//
// Purpose:
//    Writes a blank line to a low-level file
//
// Syntax:
//    WRITE LINE TO <nFile>
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    nFile       File handle
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       LOCAL nFile := fCreate("testtest.txt")
//       WRITE LINE TO nFile
//       fClose(nFile)
//    ENDFUNCTION
//
// Files:
//    (<cFile>)
//
// Description:
//    Writes a blank line to a low-level file.
//
// See Also:
//    fWriteLine()
//
// Category:
//    Command
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command WRITE LINE TO <nFile> ;
         => fWrite( <nFile> , CRLF )

////////////////
////////////////
//
// Purpose:
//    Writes data to a low-level file
//
// Syntax:
//    WRITE [LINE] <cData> TO <nFile>
//
// Formal Arguments: (2)
//    Name        Description
//    ___________ ____________
//    cData       Any character data
//    nFile       File handle
//
// Examples:
//    #include "beckner.inc"
//    FUNCTION TestIt()
//       LOCAL nFile := fCreate("testtest.txt"), cData := "Line 1"
//       WRITE LINE cData TO nFile
//       fClose(nFile)
//    ENDFUNCTION
//
// Files:
//    (<cFile>)
//
// Description:
//    Writes data to a low-level file.  If the LINE clause is specified, then
//    a carriage return/line feed sequence is sent after the data.
//
// See Also:
//    fWriteLine()
//
// Category:
//    Command
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command WRITE [<line: LINE>] <cLine> TO <nFile> ;
         => fWrite( <nFile> , <cLine> +iif( <.line.> , CRLF, "") )
