/*
   Watch.prg       Event watcher subsystem

                   STRADA.LIB component

                   La Strada del la Dolce Vita
                   The Guide to Windows for Clipper Programmers
                   Craig Yellick / Rev 1.0a / July'93
*/

#include "dolce.ch"
#include "strada.ch"

// do not include ATSAY.CH

static aWM_
static aLabel := {}
static aXparam := {}

procedure WatchInit()
local  cClr := setcolor("W/N")
  cls
  @ 1, 0 say " _____ Mouse-moves. Button: Left-Right. Mouse in __________ at x,y: _____ _____"
  @ 3, 0 say " Event  Window      Message                                                    "
  @ 4, 0 say " Count  Handle      Number & Description            Parameter       X-Pos Y-Pos"
  @ 5, 0 say " -----  ----------  ------------------------------  --------------  ----- -----"
  WatchUpdate("INIT", row())
  aLabel := {}
  aXparam := {}
  setcolor(cClr)
return


procedure WatchUpdate( hWnd, nMsg, nParam, x, y )

static nCnt, nMove, nRow
local  cClr, n, cLabel
local  cType, isXparam, p1, p2, p3, p4

  //  Special initialization signal
  if valtype(hWnd) == "C"
    nCnt  := 0
    nMove := 0
    nRow  := nMsg
    return
  endif

  cClr := setcolor("W/N")

  //  Non-event note
  if hWnd == -999
    if nRow < 24
      nRow++
    else
      scroll(6,0,24,79, 1)
    endif
    @ nRow, 5 say " [ " +procname(2) + ":" ;
                + lstr(procline(2)) + " ] " color "N/BG"
    @ nRow, col() + 1 say nMsg color "BG/N"
    setcolor(cClr)
    return
  endif

  nCnt++

  //  Associate window handle with descriptive label (if any)
  if (len(aLabel) > 0) .and. ;
     ((n := ascan(aLabel, { |a| a[1] == hWnd } )) != 0)
    cLabel := aLabel[n, 2]
  else
    cLabel := str(hWnd, 10)
  endif

  if (nMsg == WM_MOUSEMOVE)
    @ 1, 01 say str(++nMove, 5)
    @ 1, 49 say padr(alltrim(cLabel), 10, ".")
    @ 1, 68 say str(x, 5)
    @ 1, 74 say str(y, 5)

  elseif (nMsg == WM_LBUTTONDOWN)
    @ 1, 28 say "Left" color "I"

  elseif (nMsg == WM_LBUTTONUP)
    @ 1, 28 say "Left"

  elseif (nMsg == WM_RBUTTONDOWN)
    @ 1, 33 say "Right" color "I"

  elseif (nMsg == WM_RBUTTONUP)
    @ 1, 33 say "Right"

  else
    if nRow < 24
      nRow++
    else
      scroll(6,0,24,79, 1)
    endif

    @ nRow, 1 say str(nCnt, 5)
    ?? "  " + padr(cLabel,10)
    ?? "  " + padr(str(nMsg,3) + " " + WM_Descr(nMsg), 30)

    if nMsg == WM_SYSCOMMAND
      ?? "  " + padr(SYS_Descr(nParam), 14)
    else
      if (len(aLabel) > 0) .and. ;
         ((n := ascan(aLabel, { |a| a[1] == nParam } )) != 0)
        ?? "  " + padr(aLabel[n,2], 14)
      else
        ?? "  " + str(nParam, 14)
      endif
    endif
    ?? "  " + str(x, 5)
    ?? " "  + str(y, 5)

    //  Check to see if hWnd and nParam combo needs X-param
    //  info displayed.
    //
    isXparam := (len(aXparam) > 0) .and.   ;
                ((n := ascan(aXparam,      ;
                { |a| (a[1] == hWnd) .and. ;
                      (a[2] == nMsg) .and. ;
                      (a[3] == nParam) } )) != 0)

    if isXparam
      if nRow < 24
        nRow++
      else
        scroll(6,0,24,79, 1)
      endif
      @ nRow, 1 say space(8) + (cType := aXparam[n, 4]) + " >"
      p2 := GetXparam(2)
      p3 := GetXparam(3)

      //  XX: No interpretation, show all parameters
      if cType == "XX"
        ?? " 1: " + lstr(GetXParam(1))
        ?? " 2: " + lstr(p2)
        ?? " 3: " + lstr(p3)
        ?? " 4: " + lstr(GetXParam(4))

      //  Edit control notifications
      elseif cType == "EN"
        ?? " 3: " + lstr(p2) + " " + EN_Descr(p2)

      //  Listbox notifications
      elseif cType == "LBN"
        ?? " 2: " + lstr(p2) + " " + LBN_Descr(p2)

      //  Pushbutton notifications
      elseif cType == "BN"
        // !!!

      //  Combo-box notifications
      elseif cType == "CBN"
        // !!!

      //  Scroll-bar notifications
      elseif cType == "SB"
        // !!!

      endif
    endif

  endif
  setcolor(cClr)
return


procedure WatchNote(xNote)
  WatchUpdate(-999, xNote)
return

procedure WatchAssoc(h, cLabel)
  aadd(aLabel, {h, cLabel})
return

procedure WatchXparam(hWnd, nMsg, nParam, cType)
  default cType to "XX"
  aadd(aXparam, {hWnd, nMsg, nParam, cType})
return

procedure WatchKill()
  aLabel := {}
  aWM_   := {}
return


function EN_Descr( nParam )
local cDescr := "?=" + lstr(nParam)
  if     nParam == EN_SETFOCUS   ; cDescr := "set focus"
  elseif nParam == EN_KILLFOCUS  ; cDescr := "kill focus"
  elseif nParam == EN_CHANGE     ; cDescr := "change"
  elseif nParam == EN_UPDATE     ; cDescr := "update"
  elseif nParam == EN_ERRSPACE   ; cDescr := "err space"
  elseif nParam == EN_MAXTEXT    ; cDescr := "max text"
  elseif nParam == EN_HSCROLL    ; cDescr := "h-scroll"
  elseif nParam == EN_VSCROLL    ; cDescr := "v-scroll"
  endif
return cDescr


function LBN_Descr( nParam )
local cDescr := "?=" + lstr(nParam)
  if     nParam == LBN_SETFOCUS   ; cDescr := "set focus"
  elseif nParam == LBN_KILLFOCUS  ; cDescr := "kill focus"
  elseif nParam == LBN_ERRSPACE   ; cDescr := "err space"
  elseif nParam == LBN_SELCHANGE  ; cDescr := "sel change"
  elseif nParam == LBN_SELCANCEL  ; cDescr := "sel cancel"
  elseif nParam == LBN_DBLCLK     ; cDescr := "2-click"
  endif
return cDescr


function SYS_Descr( nParam )
local cDescr := "?=" + lstr(nParam)
  if     nParam == -4096 ; cDescr := "size"
  elseif nParam == -4080 ; cDescr := "move"
  elseif nParam == -4064 ; cDescr := "minimize"
  elseif nParam == -4048 ; cDescr := "maximize"
  elseif nParam == -4032 ; cDescr := "next window"
  elseif nParam == -4016 ; cDescr := "prev window"
  elseif nParam == -4000 ; cDescr := "close"
  elseif nParam == -3984 ; cDescr := "V scroll"
  elseif nParam == -3968 ; cDescr := "H scroll"
  elseif nParam == -3952 ; cDescr := "mouse menu"
  elseif nParam == -3936 ; cDescr := "key menu"
  elseif nParam == -3824 ; cDescr := "arrange"
  elseif nParam == -3808 ; cDescr := "restore"
  elseif nParam == -3792 ; cDescr := "task list"
  endif
return cDescr


function WM_Descr( nMsg )
local cDescr := ""
  if aWM_ == nil
    InitWMdescr()
  endif
  if nMsg == 0
    cDescr := "null"
  elseif nMsg > len(aWM_)
    cDescr := "<no descr>"
  else
    cDescr := aWM_[ nMsg ]
    if cDescr == nil
      cDescr := "<no descr>"
    endif
  endif
return cDescr



static procedure InitWMdescr()
  aWM_ := array(1000)
  aWM_[   1 ] := "create"
  aWM_[   2 ] := "destroy"
  aWM_[   3 ] := "move"
  aWM_[   5 ] := "size"
  aWM_[   6 ] := "activate"
  aWM_[   7 ] := "set focus"
  aWM_[   8 ] := "kill focus"
  aWM_[  10 ] := "enable"
  aWM_[  11 ] := "set redraw"
  aWM_[  12 ] := "set text"
  aWM_[  13 ] := "get text"
  aWM_[  14 ] := "get text length"
  aWM_[  15 ] := "paint"
  aWM_[  16 ] := "close"
  aWM_[  17 ] := "query end session"
  aWM_[  18 ] := "quit"
  aWM_[  19 ] := "query open"
  aWM_[  20 ] := "erase bkgnd"
  aWM_[  21 ] := "sys color change"
  aWM_[  22 ] := "end session"
  aWM_[  24 ] := "show window"
  aWM_[  25 ] := "ctl color"
  aWM_[  26 ] := "win ini change"
  aWM_[  27 ] := "dev mode change"
  aWM_[  28 ] := "activate app"
  aWM_[  29 ] := "font change"
  aWM_[  30 ] := "time change"
  aWM_[  31 ] := "cancel code"
  aWM_[  32 ] := "set cursor"
  aWM_[  33 ] := "mouse activate"
  aWM_[  34 ] := "child activate"
  aWM_[  35 ] := "queue sync"
  aWM_[  36 ] := "get minmax info"
  aWM_[  38 ] := "paint icon"
  aWM_[  39 ] := "icon erase bkgnd"
  aWM_[  40 ] := "next dialog control"
  aWM_[  42 ] := "spooler status"
  aWM_[  43 ] := "draw item"
  aWM_[  44 ] := "measure item"
  aWM_[  45 ] := "delete item"
  aWM_[  46 ] := "vKey to item"
  aWM_[  47 ] := "char to item"
  aWM_[  48 ] := "set font"
  aWM_[  49 ] := "get font"
  aWM_[  55 ] := "query drag icon"
  aWM_[  57 ] := "compare item"
  aWM_[  65 ] := "compacting"
  aWM_[  71 ] := "position changed"
  aWM_[ 129 ] := "nc create"
  aWM_[ 130 ] := "nc destrory"
  aWM_[ 131 ] := "nc calc size"
  aWM_[ 132 ] := "nc hit test"
  aWM_[ 133 ] := "nc paint"
  aWM_[ 134 ] := "nc activate"
  aWM_[ 135 ] := "get dialog code"
  aWM_[ 160 ] := "nc mouse move"
  aWM_[ 161 ] := "nc L button down"
  aWM_[ 162 ] := "nc L button up"
  aWM_[ 163 ] := "nc L button 2-click"
  aWM_[ 164 ] := "nc R button down"
  aWM_[ 165 ] := "nc R button up"
  aWM_[ 166 ] := "nc R button 2-click"
  aWM_[ 167 ] := "nc M button down"
  aWM_[ 168 ] := "nc M button up"
  aWM_[ 169 ] := "nc M button 2-click"
  aWM_[ 256 ] := "key first"
  aWM_[ 256 ] := "key down"
  aWM_[ 257 ] := "key up"
  aWM_[ 258 ] := "char"
  aWM_[ 259 ] := "dead char"
  aWM_[ 260 ] := "sys key down"
  aWM_[ 261 ] := "sys key up"
  aWM_[ 262 ] := "sys char"
  aWM_[ 263 ] := "sys dead char"
  aWM_[ 264 ] := "key last"
  aWM_[ 272 ] := "init dialog"
  aWM_[ 273 ] := "command"
  aWM_[ 274 ] := "sys command"
  aWM_[ 275 ] := "timer"
  aWM_[ 276 ] := "H scroll"
  aWM_[ 277 ] := "V scroll"
  aWM_[ 278 ] := "init menu"
  aWM_[ 279 ] := "init menu popup"
  aWM_[ 287 ] := "menu select"
  aWM_[ 288 ] := "menu char"
  aWM_[ 289 ] := "enter idle"
  aWM_[ 512 ] := "mouse first"
  aWM_[ 512 ] := "mouse move"
  aWM_[ 513 ] := "L button down"
  aWM_[ 514 ] := "L button up"
  aWM_[ 515 ] := "L button 2-click"
  aWM_[ 516 ] := "R button down"
  aWM_[ 517 ] := "R button up"
  aWM_[ 518 ] := "R button 2-click"
  aWM_[ 519 ] := "M button down"
  aWM_[ 520 ] := "M button up"
  aWM_[ 521 ] := "M button 2-click"
  aWM_[ 992 ] := "DDE initiate"   // and WM_DDE_FIRST?
  aWM_[ 993 ] := "DDE terminate"
  aWM_[ 994 ] := "DDE advise"
  aWM_[ 995 ] := "DDE unadvise"
  aWM_[ 996 ] := "DDE ack"
  aWM_[ 997 ] := "DDE data"
  aWM_[ 998 ] := "DDE request"
  aWM_[ 999 ] := "DDE poke"
  aWM_[1000 ] := "DDE execute"   // and WM_DDE_LAST ?
return

// eof Watch.prg
