#include "dolce.ch"
#include "common.ch"

#define BLACK_ON_WHITE {RGBColor(0,0,0),RGBColor(255,255,255)}

FUNCTION MAIN()

   LOCAL nError
   LOCAL hSession                     // Handle to the main session Window
   LOCAL hVideo                       // Handle to Video Window
   LOCAL hWnd
   LOCAL cFoo
   LOCAL GetList := {}
   LOCAL nMsg
   LOCAL nParam
   LOCAL x,y
   LOCAL cCmd
   LOCAL hDDE
   LOCAL cNum

   nError := InitExec("TESTSERV")

   UnRecDDEServer("DFServer","GimmeANum")
   RecDDEServer("DFServer","GimmeANum")

   cls
   hSession := OpenSess("Test Server Application",{50,25,500,500})

   MessageBox("This is a simple message box.", "Hello-3",MB_OK,hSession)

   hWnd := hVideo := CreateWIndow("Hello",{60,30,300,300},)

   nError := TextOut(hWnd,{60,30},SYSTEM_FONT,;
                     BLACK_ON_WHITE,;
                     "Hello World")

   nError := TextOut(hWnd,{60,50},ANSI_FIXED_FONT,;
                     BLACK_ON_WHITE,;
                     "This is a Window!")

   // Go into our message loop
   WHILE TRUE
       nMsg := GetMessage(@hVideo,@nMsg,@nParam,@x,@y,@cCmd)
       DO CASE
          CASE nMsg == 0
              ReleaseSlice()
          CASE nMsg == WM_SYSCOMMAND .AND. nParam == SC_CLOSE
              EXIT
          // Handle DDE from other application
         CASE nMsg == WM_DDE_INITIATE
             nError := TextOut(hWnd,{60,60},SYSTEM_FONT,;
                          BLACK_ON_WHITE,"DDE Initiate!")
          CASE nMsg == WM_DDE_TERMINATE
             nError := TextOut(hWnd,{60,60},SYSTEM_FONT,;
                          BLACK_ON_WHITE,"DDE Terminate!")
          CASE nMsg == WM_DDE_REQUEST
             nError := TextOut(hWnd,{60,60},SYSTEM_FONT,;
                          BLACK_ON_WHITE,"DDE Request!  ")
            cNum := "42"
            PokeDDE(hDDE,"GimmeANum",cNum)
          CASE nMsg == WM_DDE_ADVISE
             nError := TextOut(hWnd,{60,60},SYSTEM_FONT,;
                          BLACK_ON_WHITE,"DDE Advise!   ")
          CASE nMsg == WM_DDE_UNADVISE
             nError := TextOut(hWnd,{60,60},SYSTEM_FONT,;
                          BLACK_ON_WHITE,"DDE Un-Advise!")
          CASE nMsg == WM_DDE_ACK
             nError := TextOut(hWnd,{60,60},SYSTEM_FONT,;
                          BLACK_ON_WHITE,"DDE Un-Advise!")
          CASE nMsg == WM_DDE_DATA
             nError := TextOut(hWnd,{60,60},SYSTEM_FONT,;
                          BLACK_ON_WHITE,"DDE ACK!      ")
          CASE nMsg == WM_DDE_POKE
             nError := TextOut(hWnd,{60,60},SYSTEM_FONT,;
                          BLACK_ON_WHITE,"DDE Poke      ")
          CASE nMsg == WM_DDE_EXECUTE
             nError := TextOut(hWnd,{60,60},SYSTEM_FONT,;
                          BLACK_ON_WHITE,"DDE Execute!  ")

       ENDCASE

   END

   UnRecDDEServer("DFServer","GimmeANum")

   EndExec()

RETURN NIL
