FUNCTION asize
* Purpose..: Returns number of elements in an array file
* Author...: Joseph D. Booth
* Copyright: 1988 Joseph D. Booth
* Returns..: Number of elements in array file,
*            0 if invalid file or file not found
* Syntax...: ASIZE( <expC> ) - where expC is the file name
*
* ---------------------------------------------------------------------------
PARAMETER file_name
PRIVATE retval,fn,hw,fid
retval = 0
IF FILE(file_name)                               && Does file exist ?
   fn = FOPEN(file_name,0)                       && Open it on a handle
   IF fn >=0                                     && If opened OK,
      fid = SPACE(8)                             && read the first 8 characters
      hw  = FREAD(fn,@fid,8)
      IF hw = 8                                  && If read 8 characters, and
         IF LEFT(fid,3) = "JBA"                  && first 3 are JBA, then the
            retval = VAL( SUBS(fid,4,5) )        && next five contain the size
         ENDIF                                   && of the array when it was
      ENDIF                                      && saved.
   FCLOSE(fn)                                    && Close the file
   ENDIF
ENDIF
RETURN retval                                    && Return 0 or size
* ---------------------------------------------------------------------------

