FUNCTION Arest
* Purpose: Restore an array from a disk file
* Returns: .T. if successful , .F. otherwise
* Syntax.: AREST( @<expC>,<expC1> ) - where expC is array name
*                                     expC1 is file to restore from
PARAMETER whatarray,file_name
PRIVATE retval,fn,hw,fid,t1,t2,tmp1,tmp2,k,tmp3
retval = .F.
IF FILE(file_name)
   fn = FOPEN(file_name,0)
   IF fn >=0
      fid = SPACE(28)
      hw = FREAD(fn,@fid,28)
      IF hw = 28
         * read rest of file
         IF LEFT(fid,3) = "JBA"
            t1 = VAL(SUBS(fid,9,10))
            t2 = VAL(SUBS(fid,19,10))
            tmp1 = SPACE(t1)
            tmp2 = SPACE(t2)
            hw = FREAD(fn,@tmp1,t1)
            IF hw = t1
               hw = FREAD(fn,@tmp2,t2)
               IF t2 = hw
                  retval = .T.
                  hw = LEN(tmp1)/6
                  FOR k = 1 TO MIN( hw,LEN(whatarray) )
                      wtype = LEFT(tmp1,1)
                      wsize = VAL( SUBS(tmp1,2,5) )
                      tmp1 = SUBS(tmp1,7)
                      tmp3 = LEFT(tmp2,wsize)
                      tmp2 = SUBS(tmp2,wsize+1)
                      DO CASE
                         CASE wtype = "C"
                            whatarray[k]=tmp3
                         CASE wtype = "N"
                            whatarray[k]=VAL(tmp3)
                         CASE wtype = "D"
                            whatarray[k]=CTOD(tmp3)
                         CASE wtype = "L"
                            whatarray[k]=IF(tmp3="T",.T.,.F.)
                      ENDCASE
                  NEXT
               ENDIF
            ENDIF
         ENDIF
      ENDIF
   FCLOSE(fn)
   ENDIF
ENDIF
RETURN retval
* ---------------------------------------------------------------------------

