#include "slvrclip.ch"

FUNCTION AutoBaud(nPort, nMaxTime, lSetBaudRate)

/* 
**
**
   #include "slvrclip.ch"

   AutoBaud(nPort, nMaxTime, lSetBaudRate) -> nBaudRate

   This function is designed to be called after the modem (in auto-answer mode)
   answers the phone or dialing the phone to CONNECT to another mode.  When
   two modem CONNECT, they may negotiate a baud rate and drop from your
   current UART baud rate setting to a lower baud rate.  This function will
   read the modem response in VERBOSE mode or NON-VERBOSE mode for the 
   CONNECT baud rate.  The function will optionally call the SWSetBaud()
   function based on the (lSetBaudRate) parameter.  The function returns
   the detected baud rate.

   Parameters

      nPort		:= Port vale for the open COM port.
      nMaxTime		:= Number od seconds to wait for a response.
      lSetBaudRate	:= Optional setting of the baud rate.

   Copyright (c) 1991 SilverWare Inc.


**
**
*/

LOCAL cResponseString, nReturnCode, nBaud, lBaudDetected

nMaxTime	:= SWGetSec() + nMaxTime
nBaud 		:= SWCTIMEDOUT
lBaudDetected	:= SWFALSE

do while SWTRUE

   if SWGetSec() > nMaxTime	/* Timer check */
      nBaud := SWCTIMEDOUT
      exit
   endif

   if !SWRXEmpty(nPort)

      nReturnCode := SWMGetResp(nPort,@cResponseString,2)

      /* Check VERBOSE and NON-VERBOSE return strings */

      do case
         case cResponseString == "CONNECT"       .or. cResponseString == "1"
             nBaud := 300
	     lBaudDetected := SWTRUE
         case cResponseString == "CONNECT 1200"  .or. cResponseString == "5"
             nBaud := 1200
	     lBaudDetected := SWTRUE
         case cResponseString == "CONNECT 2400"  .or. cResponseString == "10"
             nBaud := 2400
	     lBaudDetected := SWTRUE
         case cResponseString == "CONNECT 4800"  .or. cResponseString == "11"
             nBaud := 4800
	     lBaudDetected := SWTRUE
         case cResponseString == "CONNECT 9600"  .or. cResponseString == "12"
             nBaud := 9600
	     lBaudDetected := SWTRUE
         case cResponseString == "CONNECT 19200" .or. cResponseString == "14"
             nBaud := 19200
	     lBaudDetected := SWTRUE
      endcase

      /* Set optional baud rate */

      if lBaudDetected == SWTRUE
         if lSetBaudRate == SWTRUE
            ?SWSetBaud(nPort,nBaud)
         endif
         exit
      endif

   endif
enddo

RETURN(nBaud)
