***************************************************************************
**
** LOOKUP.PRG
**              Generic lookup module for Clipper Summer 87.
**
**              This .prg was produced using Wallsoft's PICKDRVR.TEM
**              with only one slight change by Brian Abbott
**
**              The Change:
**              Works like Pickdrvr except that if an <esc> is hit
**              to exit, then the record that was selected when called
**              is restored, otherwise, the currently selected record
**              remains selected (a la pickdrvr)
**
** Revised      05-05-89 Brian Abbott
**                       Brian Abbott Consulting
**                       (205) 244-7840
** Parameters:
**
**  t,l,b,r     top, left, bottom, right of display region
**  linex       line display expression
**  locolor     color to display unselected items in (optional)
**  hicolor     color to display selected items in (optional)
**  autoseek    allow autoseek? flag (can be .T.,.F. or unpassed)
**  hotkeys     a string of keys that provoke LOOKUP to exit (optional)
**  outkey      on exit from LOOKUP, outkey is set to key that exited (opt)
**  rowoff      initial row offset of hilited item (also set on exit)
**
**
***************************************************************************

PARAM t, l, b, r, linex, locolor, hicolor, autoseek, hotkeys, outkey, rowoff

PRIVATE drows, dcols                && # display rows, # display columns
PRIVATE currow, thisrow             && row save variables
PRIVATE rec1, recN                  && recno() save variables
PRIVATE saverec, toprec, oldrec     && ditto
PRIVATE key                         && keyhit holder
PRIVATE redisp, slide               && redisplay flags
PRIVATE trash                       && self-explanatory, haha
PRIVATE seekbuf                     && autoseek buffer
PRIVATE anyhots

** parameter check/setup
**
IF type('locolor') <> 'C'           && set colors if unpassed
  locolor = "W/N"
ENDIF
IF type('hicolor') <> 'C'
  hicolor = "N/W"
ENDIF
IF type('rowoff') <> 'N'
  rowoff = 0
ENDIF

IF type('autoseek') = 'L'           && if they passed autoseek flag
  IF autoseek                       && and it's .T.
    seekbuf = ''                    && init seek buffer
  ENDIF
ENDIF

anyhots = (type('hotkeys') <> 'U')  && flag hotkey passed/unpassed

saverec = recno()                   && in case this was important
oldrec = recno()                    && go back here is <esc> is hit
GO TOP                              && snag some important recno()s
rec1 = recno()
GO BOTTOM
recN = recno()
GO saverec                          && back to where we started

drows = b-t+1                       && number of displayed rows
dcols = r-l+1                       && number of displayed columns
currow = t                          && current row at top of window
slide = 0                           && no initial slide

SKIP -rowoff                        && set up row offset stuff
redisp = -1-rowoff                  && initial display, leave hilite at top

SET CURSOR OFF

SET COLOR TO &locolor

DO WHILE .T.

  DO CASE                           && display stuff from flags set below

    CASE slide <> 0                 && slide 1 row up or down
      scroll(t, l, b, r, slide)     && do hardware scroll
      currow = iif(slide <0, t, b)  && set currow for hilite below
      slide = 0                     && unset slide

    CASE redisp < 0                 && redisplay, leaving current rec at top
      toprec = recno()              && save top rec
      thisrow = t                   && display rows from t to b
      DO WHILE thisrow <= b .AND. .NOT. eof()
        @ thisrow, l SAY &linex
        SKIP
        thisrow = thisrow +1
      ENDDO
      DO WHILE thisrow <= b         && in case empty rows after eof()
        @ thisrow, l SAY space(dcols)
        thisrow = thisrow +1
      ENDDO
      GO toprec                     && go back to top
      thisrow = redisp
      currow = t                    && set currow for hilite later
      DO WHILE thisrow < -1
        SKIP
        currow = currow +1
        thisrow = thisrow +1
      ENDDO
      redisp = 0                    && unset redisp

    CASE redisp > 0                 && redisplay, leaving current rec at bot
      thisrow = t                   && display rows from t to b
      DO WHILE .NOT. eof() .AND. thisrow <= b
        @ thisrow, l SAY &linex
        SKIP
        thisrow = thisrow +1
      ENDDO
      DO WHILE thisrow <= b         && in case empty rows after eof()
        @ thisrow, l SAY space(dcols)
        thisrow = thisrow +1
      ENDDO
      thisrow = thisrow -1
      SKIP -1
      DO WHILE redisp > 1
        thisrow = thisrow -1           && set currow for hilite, below
        redisp = redisp -1
      ENDDO
      currow = thisrow
      redisp = 0

  ENDCASE

  SET COLOR TO &hicolor             && hilite current item
  @ currow, l SAY &linex
  SET COLOR TO &locolor

  key = inkey(0)                    && get keyhit
  CLEAR TYPEAHEAD                   && need all the speed we can get

  IF anyhots
    FOR i = 1 to len(hotkeys)
      IF key = hotkeys[i]
        rowoff = currow-t           && set row offset
        outkey = key                && set exit key
**         SET CURSOR ON
        RETURN
      ENDIF
    NEXT
  ENDIF

  DO CASE                           && key hit action loop

    CASE key = 13                   && car. ret. -- leave recno() where it is
      EXIT

    CASE key = 27                   && esc - go back to recno selected when called
      GO oldrec
      EXIT

    CASE key = 5                    && up
      IF recno() = rec1             && at top?
        ?? chr(7)
      ELSE
        **  unhilite current selection
        @ currow, l SAY &linex
        SKIP -1                     && decrement selected record
        IF currow > t               && not the top displayed row
          currow = currow - 1       && just decrement
        ELSE                        && top displayed row
          slide = -1                && set slide flag
        ENDIF
      ENDIF

    CASE key = 24                   && down
      IF recno() = recN             && at bottom of file?
        ?? chr(7)
      ELSE
        **  unhilite current selection
        @ currow, l SAY &linex
        SKIP                        && increment selected record
        IF currow < b               && not the last displayed row
          currow = currow + 1       && just increment
        ELSE                        && bottom displayed row
          slide = 1                 && set slide flag
        ENDIF
      ENDIF

    CASE key = 18                   && page up
      SKIP t - currow - drows       && skip to top of prec page
      IF bof()                      && beep if at top
        ?? chr(7)
      ENDIF
      redisp = -1                   && redisp, leaving hilite at top

    CASE key = 3                    && page down
      SKIP t -currow +(2*drows) -1  && skip to there we want bot. of new page
      IF eof()                      && ran out of file
        ?? chr(7)
        SKIP -drows                 && skip to 1 page above eof()
        redisp = 1                  && redisp, leaving hilite at bottom
      ELSE                          && ok
        SKIP 1-drows                && skip to 1 page above eof()
        redisp = -1                 && redisp, leaving hilite at top
      ENDIF

    CASE key = 1                    && home, easy
      GO TOP
      redisp = -1

    CASE key = 6                    && end, pretty easy
      GO BOTTOM
      SKIP 1-drows
      redisp = 1

    CASE .NOT. autoseek             && all below here is autoseek stuff
      ?? chr(7)                     && squawk
      LOOP

    CASE key > 32 .AND. key < 127   && printable char, try seeking
      saverec = recno()             && save current record pos
                                    ** add letter to seek buffer
      seekbuf = seekbuf + upper(chr(key))
      SEEK seekbuf                  && give it a shot
      IF eof()                      && naah, beep & retreat
        ?? chr(7)
        seekbuf = substr(seekbuf,1,len(seekbuf)-1)
        GO saverec
      ELSE
        SKIP -(currow-t)
        redisp = -1-(currow-t)          && redisp
      ENDIF

    CASE key = 8                    && backspace
      IF empty(seekbuf)             && seek buffer's empty
        ?? chr(7)
        LOOP
      ENDIF
      seekbuf = substr(seekbuf,1,len(seekbuf)-1)
      SEEK seekbuf                  && we know it's here
      redisp = -1

  ENDCASE

ENDDO

outkey = key                        && set exit key
rowoff = currow-t                   && set row offset

** SET CURSOR ON

RETURN



