/****************************************************************
*  ATCI.C                                                       *
*                                                               *
*  By        : Leonard Zerman                                   *
*  Notice    : Placed into the Public Domain by Leonard Zerman  *
*  Date      : 05/01/1990                                       *
*  Version   : 1.00                                             *
*  Revision  : None                                             *
*  Syntax    : ATCI(<search str>, <searched str>, [<start pos>])*
*  Returns   : Position of search str in searched str starting  *
*              at start pos case insensitive. Pos default to 1  *
*  Compile   : CL /AL /Gs /Zl /FPa /oalt /c atci.c              *
*  Operation :                                                  *
*  Notes     : nandef.h and extend.h must be in current dir     *
****************************************************************/

#define islower(p)  ('a' <= (p) && (p) <= 'z')
#define toupper(p)  (islower(p) ? ((p) - ('a' - 'A')) : (p))
#define ERROR       -1

#define CLIPPER                 /* define for use with Clipper */

#ifdef CLIPPER                  /* if CLIPPER function */
#undef CLIPPER                  /* redefine in extend.h */
#include "nandef.h"             /* Clipper defines */
#include "extend.h"             /* Extend System declares */
CLIPPER ATCI(void);
#endif

unsigned int atci(char * search_str, 
                  char * searched_str, unsigned int start_pos);
int strnicmp(char * str1, char * str2, unsigned int cmp_len);

/*-----------------------* C Function *------------------------*/

unsigned int atci(char * search_str, 
                  char * searched_str, unsigned int start_pos)
{
   char c;
   unsigned int i;
   unsigned int search_len;
   unsigned int searched_len;

   if ((search_len = strlen(search_str)) == 0)
      return (0);
   if ((searched_len = strlen(searched_str)) == 0)
      return (0);
   if ((search_len > searched_len) || (start_pos > searched_len))
      return (0);

   c = toupper(*search_str);      /* upper case first char */
   searched_str += start_pos;

   for (i = start_pos; i < searched_len; i++, *searched_str++)
   {
      if (toupper(*searched_str) == c)  /* match ? */
      {
         if (strnicmp(search_str, searched_str, search_len) == 0)
            return (i + 1);
      }
   }
   return (0);     /* return position */
}


int strnicmp(char * str1, char * str2, unsigned int cmp_len)
{
   while(toupper(*str1) == toupper(*str2) && cmp_len != 0)
   {
      if (*str1 == '\0')
         return (0);

      str1++;
      str2++;
      cmp_len--;
   }
   if (cmp_len != 0) 
      return (*str1 - *str2);
   return (0);
}

/*-----------------* Clipper callable function *---------------*/

CLIPPER ATCI(void)
{
   int pcount;
   unsigned int start_pos;
   char * search_str;
   char * searched_str;

   pcount = PCOUNT;

   if (!((pcount >= 2) && ISCHAR(1) && ISCHAR(2)))
   {
        _retni(ERROR);  /* NO, return ERROR */
        return;
   }

   if (pcount > 2)
   {
      if (!ISNUM(3))
      {
           _retni(ERROR);  /* NO, return ERROR */
           return;
      }
      start_pos = (unsigned int) _parnl(3); /* get start pos */
   }
   else
      start_pos = 1;    /* default for optional parameter */

   search_str   = _parc(1);  /* get search string */
   searched_str = _parc(2);  /* get searched string */
   _retnl((long)atci(search_str, searched_str, start_pos - 1));
}

/*------------------------* EOF ATCI.C *-----------------------*/
