/*
   ASAP - Another System Analysis Product
   (c) Copyright 1989 - 1991, The Leylan Factor

   distribute freely with this header intact

   compile : clipper <file> /m/n/w
*/

#include "asap.ch"

#define THERMO 1
#define DEGREE 2

STATIC nTempRow, nTempCol, nTempLen, nTempWid, cTempHue, cTempBox
STATIC nDegrRow, nDegrCol, aTempMsg, nTempPtr, nTempLo, nTempHi
STATIC nTempInc, nTempCnt, nTempMax


FUNCTION TempNew( nRow, nCol, nLen, nWid, cHue, nRow2, nCol2, cBox )
  
   nTempRow := nRow
   nTempCol := nCol
   nTempLen := nLen
   nTempWid := nWid
   cTempHue := cHue
   cTempBox := cBox

   nDegrRow := nRow2
   nDegrCol := nCol2

   aTempMsg := { { "S", "  F " } ,;
                 { "Y", "     " } ,;
                 { "S", "- 220" } ,;
                 { "T", "- 210" } ,;
                 { "E", "- 200" } ,;
                 { "M", "- 190" } ,;
                 { " ", "- 180" } ,;
                 { "T", "- 170" } ,;
                 { "E", "- 160" } ,;
                 { "M", "- 150" } ,;
                 { "P", "- 140" } ,;
                 { "E", "- 130" } ,;
                 { "R", "- 120" } ,;
                 { "A", "- 110" } ,;
                 { "T", "- 100" } ,;
                 { "U", "-  90" } ,;
                 { "R", "-  80" } ,;
                 { "E", "-  70" } }

   nTempPtr := 17
   nTempLo  := 3
   nTempHi  := 18
   nTempInc := -1

   nTempCnt := 0
   nTempMax := 10

   RETURN NIL


FUNCTION TempShow
   LOCAL nCnt

   @ nTempRow, nTempCol, nTempRow + nTempLen, nTempCol + nTempWid ;
      BOX cTempBox COLOR cTempHue

   FOR nCnt := 1 TO LEN( aTempMsg )
      @ nTempRow + nCnt, nTempCol + 1 ;
         SAY aTempMsg[ nCnt, THERMO ] COLOR cTempHue
   NEXT

   FOR nCnt := nTempPtr TO LEN( aTempMsg )
      @ nTempRow + nCnt, nTempCol + 1 ;
         SAY aTempMsg[ nCnt, THERMO ] COLOR CO_WHITE_RED
   NEXT

   FOR nCnt := 1 TO LEN( aTempMsg )
      @ nDegrRow + nCnt, nDegrCol + 1 ;
         SAY aTempMsg[ nCnt, DEGREE ] COLOR cTempHue
   NEXT

   @ nDegrRow + nTempPtr, nDegrCol + 1 ;
      SAY aTempMsg[ nTempPtr, DEGREE ] COLOR BLINK( BRIGHT( CO_RED_BLACK ) )
  
   RETURN NIL


FUNCTION TempEvent
   LOCAL xColor

   IF nTempCnt <= nTempMax

      nTempCnt++

   ELSE

      xColor := SETCOLOR( IF( nTempInc < 0, CO_WHITE_RED, cTempHue ) )

      @ nTempRow + nTempPtr - nTempInc, nTempCol + 1 ;
         SAY aTempMsg[ nTempPtr - nTempInc, THERMO ]

      @ nTempRow + nTempPtr, nTempCol + 1 ;
         SAY aTempMsg[ nTempPtr, THERMO ] COLOR CO_WHITE_RED

      @ nDegrRow + nTempPtr - nTempInc, nDegrCol + 1 ;
         SAY aTempMsg[ nTempPtr - nTempInc, DEGREE ] COLOR cTempHue

      @ nDegrRow + nTempPtr, nDegrCol + 1 ;
         SAY aTempMsg[ nTempPtr, DEGREE ] COLOR BLINK( BRIGHT( CO_RED_BLACK ))

      IF ( nTempPtr <= nTempLo ) .OR. ( nTempPtr >= nTempHi )
         nTempInc := -nTempInc
      ENDIF

      nTempPtr += nTempInc

      nTempCnt := 0

      SETCOLOR( xColor )

   ENDIF
  
   RETURN NIL

