/*
   ASAP - Another System Analysis Product
   (c) Copyright 1989 - 1991, The Leylan Factor

   distribute freely with this header intact

   compile : clipper <file> /m/n/w
*/

#include "asap.ch"

STATIC nRamRow, nRamCol, nRamLen, nRamWid, cRamHue, cRamTxt, cRamBox
STATIC nRamCnt, nRamMin, nRamMax, nRamInc, nRamErr, nRamRnd


FUNCTION RamNew( nRow, nCol, nLen, nWid, cHue, cTxt, cBox )

   nRamRow := nRow
   nRamCol := nCol
   nRamLen := nLen
   nRamWid := nWid
   cRamHue := cHue
   cRamTxt := cTxt
   cRamBox := cBox
   nRamCnt := 12345678
   nRamMin := 12345678
   nRamMax := 99999999
   nRamInc := ( PI ^ 8 )
   nRamErr := 20
   nRamRnd := Randomize( SECONDS() / 100 )

   RETURN NIL


FUNCTION RamShow

   @ nRamRow, nRamCol, nRamRow + nRamLen, nRamCol + nRamWid ;
      BOX cRamBox COLOR cRamHue

   @ nRamRow, nRamCol + 2 SAY cRamTxt

   RETURN NIL


FUNCTION RamEvent

   nRamRnd := Random( nRamRnd )

   @ nRamRow + 1, nRamCol + 12 SAY nRamCnt PICT "9999 9999" COLOR cRamHue

   @ nRamRow + 1, nRamCol + 23 ;
      SAY nRamErr( INT( nRamRnd / ( 32768 / nRamErr )) ) COLOR cRamHue

   nRamCnt := IF( nRamCnt + nRamInc >= nRamMax, nRamMin, nRamCnt + nRamInc )

   RETURN NIL


STATIC FUNCTION nRamErr( nErr )
   LOCAL cRet   := "OK     "
   LOCAL nPitch := 100

   DO CASE

   CASE nErr == 0
      cRet := "Parity "
   CASE nErr == 2
      cRet := "CMOS   "
   CASE nErr == 4
      cRet := "Failure"
   CASE nErr == 6
      cRet := "Retry  "
   OTHERWISE
      nPitch  := 25

   ENDCASE

   TONE( nPitch, 1 )

   RETURN cRet

