/*
   ASAP - Another System Analysis Product
   (c) Copyright 1989 - 1991, The Leylan Factor

   distribute freely with this header intact

   compile : clipper <file> /m/n/w
*/

#include "asap.ch"

STATIC nDiskRow, nDiskCol, nDiskLen, nDiskWid, cDiskBox, cDiskHue, cDiskTxt
STATIC nDiskCnt, nDiskMin, nDiskMax, nDiskInc, cDiskChr, nDiskTpt, nDiskSpt


FUNCTION DiskNew( nRow, nCol, nLen, nWid, cHue, cTxt, cBox )

   nDiskRow := nRow
   nDiskCol := nCol
   nDiskLen := nLen
   nDiskWid := nWid
   cDiskHue := cHue
   cDiskTxt := cTxt
   cDiskBox := cBox
   nDiskCnt := 987654
   nDiskMin := 987654
   nDiskMax := 111111
   nDiskInc := -( PI ^ 6 )
   cDiskChr := ""
   nDiskTpt := 1
   nDiskSpt := 1

   RETURN NIL
            


FUNCTION DiskShow

   @ nDiskRow, nDiskCol, nDiskRow + nDiskLen, nDiskCol + nDiskWid ;
      BOX cDiskBox COLOR cDiskHue

   @ nDiskRow, nDiskCol + 2 SAY cDiskTxt

   @ nDiskRow + 2, nDiskCol + 3 SAY " Track :"
   @ nDiskRow + 3, nDiskCol + 3 SAY "Sector :"

   RETURN NIL


FUNCTION DiskEvent

   @ nDiskRow + 2, nDiskCol + 12 ;
      SAY PADL( SUBS( STR( nDiskCnt, 6 ), 1, 3 ), 5, "0" ) COLOR cDiskHue

   @ nDiskRow + 3, nDiskCol + 12 ;
      SAY PADL( SUBS( STR( nDiskCnt, 6 ), 4, 3 ), 5, "0" ) COLOR cDiskHue
  
   IF nDiskSpt == 1
      @ nDiskRow + 2, nDiskCol + 20 SAY REPL( cDiskChr, 10 ) COLOR cDiskHue

      @ nDiskRow + 2, nDiskCol + 19 + nDiskTpt ;
         SAY cDiskChr COLOR BRIGHT( CO_RED )

      nDiskTpt := IF( nDiskTpt >= 10 , 1, nDiskTpt + 1 )
   ENDIF
  
   @ nDiskRow + 3, nDiskCol + 20 SAY REPL( cDiskChr, 10 ) COLOR cDiskHue

   @ nDiskRow + 3, nDiskCol + 19 + nDiskSpt ;
      SAY cDiskChr COLOR BRIGHT( CO_RED )
  
   nDiskSpt := IF( nDiskSpt >= 10, 1, nDiskSpt + 1 )

   nDiskCnt := IF( nDiskCnt + nDiskInc <= nDiskMax, nDiskMin, ;
                   nDiskCnt + nDiskInc )
  
   RETURN NIL

