*-------------------------------------------------------*
*   DEMO.PRG                                            *
*   Array Get Demonstration Program                     *
*                                                       *
*   Written by  Jim Senkler                             *
*               More than Computers                     *
*               (73777,253)                             *
*               January 1991                            *
*                                                       *
*-------------------------------------------------------*---------------*
*        Modification History                                           *
*                                                                       *
*-----------------------------------------------------------------------*


*       Included CLIPPER files


*       Included MtC files

#include "GETS.CH"


*       Local defines

*       Externals

*       File wide statics  (these belong to my UT_GET.PRG utility library
*                           program, see below)

    STATIC gets_updated := .F., exit_read := .F.,  cur_getlist := NIL



*       File-wide memvars

*       Mainline Procedure

    procedure main()
      local start := 0, count := 0, ix
      local array[10], a_gets1 := {}, a_gets2 := {}
      afill(array,space(10))
      clear screen
      setpos(maxrow() + 1, maxcol() + 1)             // shut off _GET_() display
      ADD GET @ 2,5 SAY "Start get:" GET start TO a_gets1 PICTURE "99";
            NAME "Start get" VALID start > 0
      ADD GET @ 3,5 SAY "How many: " GET count TO a_gets1 PICTURE "99";
             VALID ck_count(@count, start)
      do while .T.
        clear screen
        disp_says(a_gets1)
        disp_gets(a_gets1)
        read_gets(a_gets1)
        setpos(maxrow() + 1, maxcol() + 1)          // shut off _GET_() display
        for ix = start to start + count - 1
           ADD GET @ 4 + ix, 5 SAY "Get No. " + str(ix,2) GET array[ix];
                  TO a_gets2 NAME "ARRAY[" + str(ix,2) + "]";
                  AVALID ck_array()
        next ix
        disp_says(a_gets2,1,count)
        disp_gets(a_gets2,1,count)
        read_gets(a_gets2,1,count)
        asize(a_gets2[GT_SAYS],0)
        asize(a_gets2[GT_GETS],0)
        @ 24, 5 say "Press any key.  Escape ends." ; inkey(0)
        if lastkey() == 27
          exit
        endif
      enddo
    return


*       Check count

    function ck_count(count, start)
      if count == 0
        count ++
      endif
      if start + count > 10
        count := 11 - start
      endif
    return .T.


*       Frivolous valid function to show what can be done with arrays

    function ck_array(get_no, get_obj)    // get_no, and get_obj are parameters
                                          // passed by eval(get:PostBlock)
      if get_no == 1
        devpos(get_obj:row, get_obj:col)  // display "Ann" in the get location
        devout("Ann")
      else
        get_obj:buffer := padr("fred",len(get_obj:buffer))  // assign "fred"
                                                            // to the variable
        get_obj:assign()
      endif
    return .T.




*-----------------------------------------------------------------------*
*  Functions from my UT_GET.PRG utility library program                 *
*                                                                       *
*  Add_Get(), Disp_Says(), and Disp_Gets() are original routines.       *
*  Read_Gets(), ExitRead(), Gets_Updated(), and Cur_GetList(), are      *
*  modified routines taken from Nantucket's GETSYS.PRG.                 *
*                                                                       *
*                                                                       *
*                                                                       *
*-----------------------------------------------------------------------*



*       Included Clipper headers

#include "INKEY.CH"
#include "SET.CH"
#include "SETCURS.CH"


*       Local defines

#define K_UNDO          K_CTRL_U

*     bounce direction for Read_Gets

#define FORWARD     1
#define BACKWARD   -1



*       Add to get list

    function add_get(a_gets, row, col, prompt, get_obj, varname, cValid)
      local loc
      if len(a_gets) == 0
        asize(a_gets,2)
        a_gets[GT_GETS] := {}
        a_gets[GT_SAYS] := {}
      endif
      if prompt <> NIL                              // add a say
        aadd(a_gets[GT_SAYS],{row, col, prompt})
        col += len(prompt) + 1
      endif
      if get_obj <> NIL                             // add a get
        get_obj:row := row
        get_obj:col := col
        if varname <> NIL                           // replace the name
          get_obj:name := varname
        endif
        if cValid <> NIL                            // create custom valid block
          loc := at("(",cValid)
          if loc <> 0
            cValid := substr(cValid, 1, loc) + "get_no, get_obj, " +;
                      substr(cValid, loc  + 1)
          else
            cValid += "(get_no, get_obj)"
          endif
          get_obj:postBlock := &("{ |x, y, get_no, get_obj| " + cValid + "}")
        endif
        aadd(a_gets[GT_GETS],get_obj)
      endif
    return NIL


*       Display the says on the screen

    function disp_says(a_gets, start, count)
      start := iif(start == NIL, 1, start)
      count := iif(count == NIL, len(a_gets[GT_SAYS]), count)
      aeval(a_gets[GT_SAYS], { |say| devpos(say[SY_ROW], say[SY_COL]),;
                                     devout(say[SY_PROMPT]) }, start, count)
    return NIL


*       Display the gets on the screen

    function disp_gets(a_gets, start, count)
      start := iif(start == NIL, 1, start)
      count := iif(count == NIL, len(a_gets[GT_GETS]), count)
      aeval(a_gets[GT_GETS], { |get| get:display() }, start, count)
    return NIL


*       Read gets

    function Read_Gets(a_gets, start, count)
      local a_getlist := {}, get, cur_get := 1, next_get, no_gets,;
            lastkey := 0, char
      local old_readvar, old_getlist, old_cursor, rg_updated
      local exit_get, exit_keystroke
      local set_block, direction := FORWARD

      start := iif(start == NIL, 1, start)
      count := iif(count == NIL, len(a_gets[GT_GETS]), count)
      aeval(a_gets[GT_GETS], { |get| aadd(a_getlist, get) }, start, count)
      if ( Empty(a_getlist) )
        return NIL                              // NOTE
      end
        
      exit_read := .F.                          // set CLEAR GETS flag off
      gets_updated := rg_updated := .F.         // set updated flag off
      old_readvar := ReadVar("")                // set and save ReadVar()
      old_getlist := cur_getlist                // save cur_getlist
      old_cursor := set(_SET_CURSOR,SC_NORMAL)  // set and save cursor
      no_gets := Len(a_getlist)

/*
*   READ loop
*/
      do while (cur_get <> 0 .and. ! exit_read)
        get := cur_getlist := a_getlist[cur_get]           // set current get
        ReadVar(Upper(get:name))                           // set ReadVar()

/*
*   GET loop
*/
        get:setFocus()                         // Give get object focus
        exit_get := .F.

        do while (! exit_get)
          if (get:typeOut)                    // no editable positions
            if ((next_get := cur_get + 1) > Len(a_getlist) )
              next_get := 0
            endif
            exit_keystroke := .T.           // skip keystrokes
          else
            exit_keystroke := .F.
          endif

/*
*   keystroke processing loop
*/
          do while (! exit_keystroke)
            lastkey := Inkey(0)

/*
*   process Set key
*/
            if ( (set_block := SetKey(lastkey)) <> NIL )
              if (get:changed)     // if changed
                get:assign()       // write buffer to Get var
              endif
              Eval(set_block, ProcName(2), ProcLine(2), ReadVar())
              get:updateBuffer()     // re-read Get Var and display
              if (exit_read)         // if CLEAR GETS was issued in SET KEY
                exit                 // exit Keystroke loop
              endif
              loop              // Goto start of Keystroke loop
            endif

/*
*   key processing switch
*/
            do case
            case (lastkey == K_UP)
              direction := BACKWARD
              exit_keystroke := .T.
              if ((next_get := cur_get - 1) == 0)      // at the top
                next_get := no_gets
                exit_keystroke := .T.
              endif
            case (lastkey == K_DOWN)
              direction := FORWARD
              exit_keystroke := .T.
              if ((next_get := cur_get + 1) == no_gets + 1)     // at the bottom
                next_get := 1
                exit_keystroke := .T.
              endif
            case (lastkey == K_ESC)
              if ( Set(_SET_ESCAPE) )
                get:undo()
                exit_keystroke := .T.
                exit_read := .T.
              endif
            case (lastkey == K_PGUP)
              direction := FORWARD
              next_get := 1
              exit_keystroke := .T.
            case (lastkey == K_PGDN)
              direction := BACKWARD
              next_get := no_gets
              exit_keystroke := .T.
            case (lastkey == K_ENTER)
              direction := FORWARD
              exit_keystroke := .T.
              if ((next_get := cur_get + 1) == no_gets + 1 )
                next_get := 0
              end
            case (lastkey == K_UNDO)
              get:undo()
            case (lastkey == K_INS)
              Set( _SET_INSERT, ! Set(_SET_INSERT) )
              Set( _SET_CURSOR, iif(Set( _SET_INSERT), SC_INSERT, SC_NORMAL))
            case (lastkey == K_HOME)
              get:home()
            case (lastkey == K_END)
              get:end()
            case (lastkey == K_RIGHT)
              get:right()
            case (lastkey == K_LEFT)
              get:left()
            case (lastkey == K_CTRL_D)
              get:right()
            case (lastkey == K_CTRL_S)
              get:left()
            case (lastkey == K_CTRL_RIGHT)
              get:wordRight()
            case (lastkey == K_CTRL_LEFT)
              get:wordLeft()
            case (lastkey == K_CTRL_F)
              get:wordRight()
            case (lastkey == K_CTRL_A)
              get:wordLeft()
            case (lastkey == K_BS)
              get:backSpace()
            case (lastkey == K_DEL)
              get:delete()
            case (lastkey == K_CTRL_T)
              get:delWordRight()
            case (lastkey == K_CTRL_Y)
              get:delEnd()
            otherwise
              if (lastkey >= 32 .and. lastkey <= 127)
                char := Chr(lastkey)
                if (get:type == "N" .and. char == ".")
                  get:toDecPos()                       // go to decimal point
                else
                  if ( Set(_SET_INSERT) )              // send it to the get
                    get:insert(char)
                  else
                    get:overstrike(char)
                  endif
                endif
                if (get:typeOut .and. ! Set(_SET_CONFIRM) )
                  exit_keystroke := .T.
                  if ((next_get := cur_get + 1) == no_gets + 1 )
                    next_get := 0
                  endif
                endif
              endif
            endcase
          enddo                   // end of keystroke processing loop

          if (exit_read)
            exit                                  // Exit READ loop
          endif
          if (get:badDate())
            get:home()                            // goto start of buffer
            loop                                  // Go to start of READ loop
          endif
          if (get:changed)                        // assign get var
            gets_updated := rg_updated := .T.
            get:assign()
          endif
          get:reset()                             // reset editing and redisplay

/*
*   Post edit vailidation
*/
          if (Valtype(get:postBlock) == "B")
            exit_get := Eval(get:postBlock, get:varGet(), get:changed,;
                             cur_get, get)             // cur_get and get added
            get:updateBuffer()      // in case var was reassigned in valid code
            gets_updated := rg_Updated  // if nested read changed global update
          else
            exit_get := .T.        // no valid clause
          endif
        enddo                   // end of GET editing loop

        get:killFocus()                // take away from it the focus
        cur_get := next_get            // set getList index for next edit
      enddo                     // end of READ loop

      set(_SET_CURSOR,old_cursor)      // reset cursor
      exit_read := .F.                 // reset CLEAR GETS flag
      cur_getlist := old_getlist       // reset cur_getlist
      ReadVar(old_readvar)             // reset readvar
    return gets_updated


*       Clear gets

    procedure ExitRead()
      exit_read := .T.
    return


*       Assign or return static gets_updated variable

    function Gets_Updated(value)
    return iif(value == NIL, gets_updated, gets_updated := value)


*       Assign or return static cur_getlist variable

    function Cur_GetList(value)
    return iif(value == NIL, cur_getlist, cur_getlist := value)
