* AMORT.PRG - Loan Amortization Program
*
* Developed by Ed Keim  
* 128 Fairway Drive, Dillsburg, PA 17019
* 
* 
*
* Written for dBASE III PLUS 
* Required files: AMORT.PRG, AMORT.DBF and AMORT.FRM
*
* This program will give you an idea of what your loan payments
* will be,  your lender will determine your exact payments.....
*                                                                
*
*
CLEAR
SET TALK OFF
* -------> COLOR OPTION  -  SET COLOR TO N/W,G/ ,X
@ 1,4 TO 3,75 DOUBLE
@ 2,5 SAY REPLICATE(CHR(1),70)
* -------> RESTORE COLOR -  SET COLOR TO W/B,G/ ,X
@ 2,26 SAY '  Loan Amortization Program  '
*
* ----------> SET UP VARIABLES
PRINCE=0
INTER=0
M_INTER=0
TERM=0
PMT=0
*
@  5,8 SAY 'Enter the loan amount ............................:' GET PRINCE 
PICTURE '999999999.99'
@  7,8 SAY 'Enter the interest rate percentage ...............:' GET M_INTER 
PICTURE '99.999'
@  7,67 SAY '%'
@  9,8 SAY 'Enter the total number of monthly payments .......:' GET TERM 
PICTURE '9999'
READ
STORE M_INTER / 100 / 12 TO INTER
STORE PRINCE * INTER/(1-(1+INTER)^-TERM) TO PMT
STORE PRINCE TO M_PRIN
@ 11,16 SAY 'Your monthly loan payment is  :' + 
STR(PMT,9,2)
*
USE AMORT
SET SAFETY OFF
ZAP
SET SAFETY ON
TALLY = 0
DO WHILE TALLY < TERM
  TALLY = TALLY + 1
  APPEND BLANK
ENDDO
*
GO TOP 
  DO WHILE .NOT. EOF()
* ---------------> CALCULATE INTEREST
STORE PRINCE * INTER TO HOLD_A
* ---------------> CALCULATE PRINCIPAL
STORE PMT - HOLD_A TO HOLD_B
* ---------------> CALCULATE MORT_LEFT
STORE PRINCE - HOLD_B TO HOLD_C
*
IF HOLD_C < 0
STORE 0 TO HOLD_C
ENDIF
*
REPLACE MO_PAYMENT WITH ROUND(PMT,3) 
REPLACE PRINCIPAL WITH ROUND(HOLD_B,3)
REPLACE INTEREST WITH ROUND(HOLD_A,3)
REPLACE MORT_LEFT WITH ROUND(HOLD_C,3)
STORE HOLD_C TO PRINCE
SKIP
ENDDO
*
SUM INTEREST TO M_INT
STORE M_PRIN + M_INT TO M_PAY
@ 13,16 SAY 'Total interest on loan ----- = ' + 
STR(M_INT,9,2)
@ 14,16 SAY 'Total interest + principal - = ' + 
STR(M_PAY,9,2)
*
?
?
WAIT SPACE(19) + 'Press any key to continue .........'
@ 17,4 TO 21,75
CLEAR GETS
SELECTION = 0
@ 18,20 SAY 'Press <     > to quit.' GET SELECTION PICTURE '9' RANGE 0,2
@ 18,28 SAY CHR(17)+CHR(196)+CHR(217)
@ 19,20 SAY 'Press the # 1 to print loan schedule.' 
@ 20,20 SAY 'Press the # 2 to run program again.'
READ
DO CASE
   CASE SELECTION = 0
     SET TALK ON
     CLOSE ALL
     CLEAR
     RETURN
   CASE SELECTION = 1
     CLEAR
     REPORT FORM AMORT TO PRINT 
     SET TALK ON
     CLOSE ALL
     RETURN   
   CASE SELECTION = 2
     SET TALK ON
     CLOSE ALL
     CLEAR
     DO AMORT
ENDCASE
