* AEENCODE.PRG - CLIPPER 5.01 Functions to ENCODE and DECODE STRINGS
* Written By   - Milton F. Shaw Jr.
*                (c) Copyright 1992, Auto Exec Inc., ALL RIGHTS RESERVED
*************************************************************************
* Released to Public Domain by Auto Exec BBS (508) 833-0508
*                A Great Source for Information on
*                Clipper, FoxPro, dBase, 'C' & more
*************************************************************************
*Compile with: CLIPPER AEENCODE /N
*Usage:  ENCODE(<string>,<numeric>)
*        where:
*                <string>= string to encode
*                <numeric>=encode adjustment value (2-9)
*
*Usage: DECODE(<string>,<numeric>)
*       where:
*                <string>=string to decode
*                <numeric>=encode adjustment value (2-9)
*                          MUST MATCH VALUE USED IN ENCODE
*************************************************************************
FUNCTION ENCODE(thestring,adjval)
*************************************************************************

LOCAL counter:=0,in_length:=0,next_char:='',out_string:=''
ADJVAL:=IF(ADJVAL=NIL,3,if(ADJVAL<10,ADJVAL,3))
IF thestring !=NIL
        thestring:=ALLTRIM(THESTRING)
        in_length:=LEN(thestring)

        * REVERSE STRING, ADD ADJVAL to each character and double it
        FOR counter=1 to in_length
                next_char=substr(thestring,counter *-1,1)
                if asc(next_char) <128-ADJVAL
                     out_string:=out_string+chr((asc(next_char)+ADJVAL)*2)
                endif
        NEXT
ENDIF
RETURN out_string


**********************************************************************
FUNCTION DECODE(thestring,adjval)
**********************************************************************
local counter:=0,in_length:=0, out_string:=''
adjval:=IF(ADJVAL=NIL,3,IF(ADJVAL<10,ADJVAL,3))
IF thestring !=NIL
        thestring:=ALLTRIM(THESTRING)
        in_length:=len(thestring)

        for counter= 1 to in_length
         out_string:=out_string+chr((asc(substr(thestring,counter*-1,1))/2)-ADJVAL)
        next
ENDIF
RETURN out_string


