*  DSPFLD UDFS
*  Purpose: Allows user to select record from fields scrolled in window
*  
*  Author: David W. Benson
*  Copyright (C) 1988 2nd Story Computing   
*                All rights reserved
*
*      Note: DSPFLD1 - uses dbedit
*            DSPFLD2 - uses achoice
*            Both udf's assumes dbf and index in use before calling.
*            Select the udf using a clipper function that is
*            already in your code.  In other words, don't use
*            dspfld1 if you are not currently linking in dbedit
*            or your load module will increase by about 10k.
*                    
*            In the examples; BILL_TO  char 30
*                             CUST_NO  char  5    
*
*      Calling:  Both versions are called with disp coord, field names, and hdr string
*
*      Example:  clear
*                use customer index billto
*                dspfld1(03, 01, 11, 32, "BILL_TO", "CUST_NO", "Cust no: ")
*                @ 12,1 say 'Record '+iif(recno > 0, ltrim(str(recno)), 'unselected')
*                ?
*                return
*
FUNCTION dspfld1
parameter t, l, b, r, fld1, fld2, hdr_str
private field_list
public recno

recno = 0

@ t, l clear to b, r
@ t, l, b, r box "Ŀ"
@ t + 2, l say ""
@ t + 2, r say ""                            

goto top

t = t + 2                    
l = l + 1
b = b - 1
r = r - 1

declare field_list[1]
   field_list[1] = fld1

goto top

dbedit(t, l, b, r, field_list, "ufunc1", "", "", "")

return iif(recno = 0, .f., .t.)
*

FUNCTION ufunc1
parameters mode, fld_ptr
private ret_val

@ t - 1, l + (r - l - len(hdr_str+&fld2))/2 say hdr_str + &fld2

if mode < 3
   clear typeahead
   return 1
endif

keystroke = lastkey()

clear typeahead

do case
case mode = 3
   ??chr(7)
   @ t + (b - t)/2, l + (r - l)/2 - 4 say "File empty"
   inkey(3)
   ret_val = 0
case keystroke = 27           && esc
   ret_val = 0
   recno = 0
case keystroke = 13           && enter
   recno = recno()
   ret_val = 0
otherwise         
   ret_val = 1
endcase
return (ret_val)
*

FUNCTION dspfld2
parameter t, l, b, r, fld1, fld2, hdr_str
private x, array0, array1, choice
public recno

recno = 0

@ t - 3, l - 1 clear to b + 1, r + 1
@ t - 3, l - 1 to b + 1, r + 1 
@ t - 1, l - 1 say ""
@ t - 1, l say replicate("", (r + 1) - l)
@ t - 1, r + 1 say ""                            

goto top

x = 1
declare array0[x]

do while !eof()

   array0[x] = &fld1 + &fld2 + str(recno())

   declare array1[x]
   acopy(array0, array1)

   x = x + 1
   
   declare array0[x]
   acopy(array1, array0)

   skip

enddo

goto top

@ t - 2, l + (r - l - len(hdr_str+&fld2))/2 say hdr_str + &fld2

choice = achoice(t, l, b, r, array1, .t., "ufunc2")

if choice <> 0
   recno = val(right(array1[choice],7))
   goto recno
endif

return iif(recno = 0, .f., .t.)
*

FUNCTION ufunc2
PARAMETERS mode,element,position                                   
private reply

@ t - 2, l + (r - l - len(hdr_str+&fld2))/2 say hdr_str + substr(array1[element], len(&fld1)+1, len(&fld2))
 
if mode < 3
   clear typeahead
   return 2
endif

keystroke = lastkey()

clear typeahead

do case
case keystroke = 27 .or. ;    && esc
     keystroke =  4 .or. ;    && right arrow
     keystroke = 19           && left arrow
   reply = 0
case keystroke =  1           && Home
   keyboard chr(31)
   reply = 2
case keystroke =  6           && End
   keyboard chr(30)
   reply = 2
case keystroke = 13           && enter
   reply = 1
otherwise                      && any letter
   reply = 3
endcase
return (reply)
*

*  READ TIMEOUT UDF
*  Author: David W. Benson
*  Copyright (C) 1988 2nd Story Computing   
*                All rights reserved
*
*           
*  Call with:  read_to(row, col, wait, kbchar)
*
*             row = row of 1st get in read
*             col = column of 1st get in read
*             wait = time to wait for keyboard input - seconds
*             kbchar = characters to feed to read
*
*             Example: setcolor(xnorm)
*                      @ 10,10 get Mvar
*                      setcolor(xdisp)
*                      read_to(10, 10, 300, chr(13))
*                      if empty(Mvar)
*                         return
*                      endif
*
*                      where: xnorm is normal display without 
*                             unselected color eg. W/N,N/W
*                             xdisp is color of data displayed
*                             after get eg. 'W+/N,N/W,,,W+/N'
*
FUNCTION read_to
parameters r, c, wait, key
private key_press
do while .t.
   clear typeahead
   @ r,c say ''
   key_press = 0
   key_press = inkey(wait)
   do case
   case lastkey() = 302
      do altc
      loop
   case key_press <> 0
      keyboard chr(key_press)
   otherwise
      keyboard key
   endcase
   read
   exit
enddo
return ''
*

*  MENU TIMEOUT UDF
*  Author: David W. Benson
*  Copyright (C) 1988 2nd Story Computing   
*                All rights reserved
*
*  Call with:  menu_to(row, col, prompt_opt, menu_var, wait, kbchar)
*
*              row = row of 1st get in read
*              col = column of 1st get in read
*              wait = time to wait for keyboard input - seconds
*              prompt_opt = prompt string
*              menu_var = menu to variable (must be declared)
*              kbchar = characters to feed to read
*
*                  
*              Example:
*
*                  @ 2,20 prompt 'Edit'
*                  @ 2,26 prompt 'X'
*                  menu_cf1 = 1
*                  menu_to(2, 20, "Edit", "menu_cf1", 10, 'X')
*
FUNCTION menu_to
parameters r, c, pvar, mvar, wait, key
private key_press
mt_clr = setcolor()
mv = &mvar
set cursor off
do while .t.
   clear typeahead
   setcolor(xhigh)
   @ r,c say pvar
   key_press = 0
   key_press = inkey(wait)
   setcolor(mt_clr)
   do case
   case lastkey() = 302
      do altc
      loop
   case key_press = 0
      keyboard key
   otherwise
      @ r,c say pvar
      keyboard chr(key_press)
   endcase
   menu to mv
   exit
enddo
set cursor on
&mvar = mv
return (&mvar)
*
*  Scrolling Date Selector (SDS)
*  Purpose: Allows date selection by scrolling through time
*  
*  Author: David W. Benson
*  Copyright (C) 1988 2nd Story Computing   
*                All rights reserved
* 
*
*  Notes: Keypad (+) and (-) keys change dates
*         UpArrow and DnArrow move between two dates
*         <ENTER> selects date
*         <ESC> aborts selection
*
*
FUNCTION getdates
public Msd, Med
readexit(.t.)
store date() to Msd, Med
gd_clr = setcolor()
set cursor off
setcolor('W+/N,N/W,,,W+/N')
@ 23,03 say 'Enter reporting period' + space(53)
@ 10,27 clear to 13,48
@ 10,27 to 13,48
@ 11,28 say 'Start Date:' 
@ 12,28 say '  End Date:' 
setcolor('W/N,N/W')

do while .t.

   do while .t.
      setcolor('N/W,N/W')
      @ 11,40 say Msd
      setcolor('W+/N,N/W,,,W+/N')
      clear typeahead
      key = 0
      key = inkey(0)
      if key = 43 .or. key = 45
         Msd = Msd + iif(key = 43, 1, -1)
         loop
      endif
      if key >= 48 .and. key <= 57
         set cursor on
         keyboard chr(key)
         @ 11,40 get Msd pict '@K'
         set confirm on
         read
         set confirm off
         set cursor off
         exit
      endif
      if key = 13 .or. key = 24 .or. key = 27
         exit
      endif
   enddo

   if key = 27
      store ctod('  /  /  ') to Msd, Med
      exit
   endif

   @ 11,40 say Msd

   do while .t.
      setcolor('N/W,N/W')
      @ 12,40 say Med
      setcolor('W+/N,N/W,,,W+/N')
      clear typeahead
      key = 0
      key = inkey(0)
      if key = 43 .or. key = 45
         Med = Med + iif(key = 43, 1, -1)
         loop
      endif
      if key >= 48 .and. key <= 57
         set cursor on
         keyboard chr(key)
         @ 12,40 get Med pict '@K'
         set confirm on
         read
         set confirm off
         set cursor off
         key = 13
         exit
      endif
      if key = 5 .or. key = 13 .or. key = 27
         exit
      endif
   enddo

   if key = 13 .or. key = 27
      if key = 27
         store ctod('  /  /  ') to Msd, Med
      endif
      setcolor('N/W,N/W')
      @ 11,40 say Msd
      @ 12,40 say Med
      exit
   endif

   @ 12,40 say Med

enddo

set cursor on
setcolor(gd_clr)
readexit(.f.)
release gd_clr, key
return iif(Msd>Med .or. empty(Msd) .or. empty(Med), .f., .t.)
*

