#TEMPLATE (SmartPrintUtilities, 'The Smart Print Utilities')
#!*****************************************************************************
#! Version: 1.5
#! 
#! Author: George Petrov
#! Dated : 11.05.1996
#! e-Mail: George.Petrov@Princen-IT.nl or 100276,2655 at CompuServe
#!
#!
#!*****************************************************************************
#UTILITY(PrintAllEmbeds, 'Print All Embeds')
#!*****************************************************************************
#!
#DISPLAY('This Utility will dump all your Embeds to a file.')
#DISPLAY('')
#PROMPT('Save to File:',SAVEDIALOG('Pick File','Embed Source|*.EMB')),%SaveToFile
#PREPARE
    #SET(%SaveToFile,%Application & '.EMB')
#ENDPREPARE
#DISPLAY('')
#PROMPT('Print the file after generation',CHECK),%DirectPrint,DEFAULT(0),AT(10)
#DISPLAY('')
#PROMPT('Put every procedure on a new page',CHECK),%ProcedureNewPage,DEFAULT(1),AT(10)
#DECLARE(%ASCIIFileRecord)
#DECLARE(%InstancePrefix)
#DECLARE(%InstanceQueue),MULTI
#DECLARE(%FormFeed)
#!
#SET(%FormFeed,'<12>')
#CREATE(%SaveToFile)
#MESSAGE(%Application,0)
Embeds for %Application
#FOR(%Procedure)
#MESSAGE('Exporting Embeds: ' & %Procedure,2)
#SUSPEND
#?
#?!*****************************************************************************
#?%Procedure (%ProcedureTemplate)
#?!*****************************************************************************
#?
#CREATE(%Application & '.$$$')
#EXPORT(%Procedure)
#CLOSE(%Application & '.$$$')
#OPEN(%Application & '.$$$'),READ
#LOOP
    #READ(%ASCIIFileRecord)
    #IF(%ASCIIFileRecord = %EOF OR %ASCIIFileRecord = '[END]')
        #BREAK
    #ELSIF(%ASCIIFileRecord = '[EMBED]')
        #FREE(%InstanceQueue)
#INSERT(%GetSection,%False)
    #ENDIF
#ENDLOOP
#CLOSE(%Application & '.$$$'),READ
#IF(%ProcedureNewPage)
#?%FormFeed
#ENDIF
#RESUME
#ENDFOR
#CLOSE
#REMOVE(%Application & '.$$$')
#IF(%DirectPrint)
    #PRINT(%SaveToFile,'All Embeds for ' & %Application)
#ENDIF
#!=============================================================================
#GROUP(%GetSection,%AddToEmbedTree)
#READ(%ASCIIFileRecord)
#ADD(%InstanceQueue,%ASCIIFileRecord)
#INSERT(%LoopSections,%AddToEmbedTree)
#!=============================================================================
#GROUP(%GetDefinitionSection)
#LOOP
    #READ(%ASCIIFileRecord)
    #CASE(%ASCIIFileRecord)
    #OF('[END]')
        #BREAK
    #OF('[SOURCE]')
    #OROF('[PROCEDURE]')
    #OROF('[GROUP]')
!=============================================================================
        #SET(%InstancePrefix,'')
        #FOR(%InstanceQueue)
%InstancePrefix %InstanceQueue
            #SET(%InstancePrefix,%InstancePrefix & '    ')
        #ENDFOR
!-----------------------------------------------------------------------------
    #ENDCASE
%ASCIIFileRecord
#ENDLOOP
#!=============================================================================
#GROUP(%LoopSections,%DeleteInstance)
#LOOP
    #READ(%ASCIIFileRecord)
    #IF(%ASCIIFileRecord = %EOF)
        #BREAK
    #ENDIF
    #CASE(%ASCIIFileRecord)
    #OF('[END]')
        #IF(%DeleteInstance AND ITEMS(%InstanceQueue) >= 1)
            #DELETE(%InstanceQueue,ITEMS(%InstanceQueue))
        #ENDIF
        #BREAK
    #OF('[INSTANCES]')
#INSERT(%GetSection,%True)
    #OF('[DEFINITION]')
#INSERT(%GetDefinitionSection)
    #ELSE
        #IF(SUB(%ASCIIFileRecord,1,6) = 'EMBED ')
            #IF(ITEMS(%InstanceQueue) >= 1)
                #DELETE(%InstanceQueue,ITEMS(%InstanceQueue))
            #ENDIF
            #ADD(%InstanceQueue,%ASCIIFileRecord)
            #SET(%DeleteInstance,%False)
        #ELSIF(SUB(%ASCIIFileRecord,1,5) = 'WHEN ')
            #IF(ITEMS(%InstanceQueue) >= 1)
                #DELETE(%InstanceQueue,ITEMS(%InstanceQueue))
            #ENDIF
            #ADD(%InstanceQueue,%ASCIIFileRecord)
            #SET(%DeleteInstance,%True)
        #ENDIF
    #ENDCASE
#ENDLOOP
#!
#!*****************************************************************************
#UTILITY(PrintAllHelpID, 'Print All Help ID''s')
#!*****************************************************************************
#!
#DISPLAY('This Utility will dump all your Help ID''s to a file.')
#DISPLAY('')
#PROMPT('Save to File:',SAVEDIALOG('Pick File','Help ID''s|*.HID')),%SaveToFile
#PREPARE
    #SET(%SaveToFile,%Application & '.HID')
#ENDPREPARE
#DISPLAY('')
#PROMPT('Print the file after generation',CHECK),%DirectPrint,DEFAULT(0),AT(10)
#DISPLAY('')
#PROMPT('Put every procedure on a new page',CHECK),%ProcedureNewPage,DEFAULT(1),AT(10)
#PROMPT('Print each control even if there is no HELP ID',CHECK),%PrintAllControls,DEFAULT(1),AT(10)
#PROMPT('Print CONTROL''s Type',CHECK),%PrintType,DEFAULT(1),AT(20)
#PROMPT('Print CONTROL''s Message',CHECK),%PrintMessage,DEFAULT(1),AT(20)
#PROMPT('Print CONTROL''s ToolTip',CHECK),%PrintToolTip,DEFAULT(1),AT(20)
#DECLARE(%FormFeed)
#DECLARE(%HlpIndent)
#DECLARE(%HCounter)
#DECLARE(%ControlHelpID)
#DECLARE(%ControlMessage)
#DECLARE(%ControlToolTip)
#!
#SET(%FormFeed,'<12>')
#CREATE(%SaveToFile)
#MESSAGE(%Application,0)
Help ID's: for %Application
#FOR(%Procedure)
#MESSAGE('Exporting Help ID''s: ' & %Procedure,2)
#SUSPEND
#?
#?!*****************************************************************************
#?%Procedure (%ProcedureTemplate)
#?!*****************************************************************************
#?
#FOR(%Control)
    #SET(%ControlHelpID,EXTRACT(%ControlStatement,'HLP',1))
    #SET(%ControlMessage,EXTRACT(%ControlStatement,'MSG',1))
    #SET(%ControlToolTip,EXTRACT(%ControlStatement,'TIP',1))
    #IF(%ControlHelpID <> '' OR %PrintAllControls)
        #! There is HelpID
        #SET(%HlpIndent,'')
        #LOOP,FOR(%HCounter,0,%ControlIndent)
            #SET(%HlpIndent,%HlpIndent & '    ')
        #ENDLOOP
#IF(%PrintType)
%HlpIndent %ControlType: %Control
#ELSE
%HlpIndent %Control
#ENDIF
#IF(%PrintMessage)
%HlpIndent    MSG: %ControlMessage
#ENDIF
#IF(%PrintToolTip)
%HlpIndent    TIP: %ControlToolTip
#ENDIF
%HlpIndent    HLP: %ControlHelpID
    #ENDIF
#ENDFOR
#IF(%ProcedureNewPage)
#?%FormFeed
#ENDIF
#RESUME
#ENDFOR
#CLOSE
#IF(%DirectPrint)
    #PRINT(%SaveToFile,'All Help ID''s for ' & %Application)
#ENDIF
#!
#!*****************************************************************************
#UTILITY(PrintProcedureTree, 'Print Procedure Tree')
#!*****************************************************************************
#!
#DISPLAY('This Utility will generate the procedure tree to a text file.')
#DISPLAY('')
#PROMPT('Save to File:',SAVEDIALOG('Pick File','Procedure Tree|*.PTR')),%SaveToFile
#PREPARE
    #SET(%SaveToFile,%Application & '.PTR')
#ENDPREPARE
#DISPLAY('')
#PROMPT('Print the file after generation',CHECK),%DirectPrint,DEFAULT(0),AT(10)
#DISPLAY('')
#PROMPT('Does not print already expanded procedures',CHECK),%NoPrintExpandedProc,DEFAULT(1),AT(10)
#PREPARE
    #IF(%NoPrintExpandedProc = 1)
        #SET(%ProcedureNewPage,0)
    #ENDIF
#ENDPREPARE
#ENABLE(%NoPrintExpandedProc = 0)
#PROMPT('Put every procedure tree on a new page',CHECK),%ProcedureNewPage,DEFAULT(1),AT(20)
#ENDENABLE
#PROMPT('Use Graphics',CHECK),%UseGraphics,DEFAULT(1),AT(10)
#ENABLE(%UseGraphics = 1)
#PROMPT('Use ASCII graphical characters',CHECK),%ASCIIGraph,DEFAULT(1),AT(20)
#ENDENABLE
#INSERT(%ASCIICheck)
#DECLARE(%ProcedureExpanded,%Procedure)
#DECLARE(%FormFeed)
#SET(%FormFeed,'<12>')
#CREATE(%SaveToFile)
#MESSAGE(%Application,0)
Procedure Tree for %Application
#FOR(%Procedure),WHERE(ITEMS(%ProcedureCalled) > 0 AND (%ProcedureExpanded = %False OR NOT %NoPrintExpandedProc))
#MESSAGE('Generating: ' & %Procedure,2)

#INSERT(%PrintProcedure,%Procedure,'','    ')
#IF(%ProcedureNewPage)
%FormFeed
#ENDIF
#ENDFOR
#CLOSE
#IF(%DirectPrint)
    #PRINT(%SaveToFile,'Procedure Tree for ' & %Application)
#ENDIF
#!
#GROUP(%PrintProcedure,%ProcedureToPrint,%ProcedureIndent,%NextIndent)
#DECLARE(%ProcSeparator)
    #FIX(%Procedure,%ProcedureToPrint)
    #SET(%ProcedureExpanded, %True)
    #IF(CLIP(%NextIndent) = '')
        #SET(%ProcSeparator,%CharBL & %CharMin)
    #ELSE
        #SET(%ProcSeparator,%CharTL & %CharMin)
    #ENDIF
    #IF(LEN(%ProcedureIndent) = 0)
        #SET(%ProcSeparator,'*' & %CharMin)
    #ENDIF
    #IF(%ProcedureDescription)
%ProcedureIndent %ProcSeparator %ProcedureToPrint (%ProcedureTemplate) - %ProcedureDescription
    #ELSE
%ProcedureIndent %ProcSeparator %ProcedureToPrint (%ProcedureTemplate)
    #ENDIF
#FOR(%ProcedureCalled)
    #IF(%Procedure)
        #IF(INSTANCE(%ProcedureCalled) = ITEMS(%ProcedureCalled))
#INSERT(%PrintProcedure,%ProcedureCalled,%ProcedureIndent & %NextIndent, '     ')
        #ELSE
#INSERT(%PrintProcedure,%ProcedureCalled,%ProcedureIndent & %NextIndent, ' ' & %CharPipe & '   ')
        #ENDIF
    #ENDIF
#ENDFOR
#!
#GROUP(%ASCIICheck)
#DECLARE(%CharTL)
#DECLARE(%CharMin)
#DECLARE(%CharBL)
#DECLARE(%CharPipe)
#!
#IF(%UseGraphics)
    #IF(%ASCIIGraph)
        #SET(%CharTL,  '')
        #SET(%CharMin, '')
        #SET(%CharBL,  '')
        #SET(%CharPipe,'')
    #ELSE
        #SET(%CharTL,  '+')
        #SET(%CharMin, '-')
        #SET(%CharBL,  '+')
        #SET(%CharPipe,'|')
    #ENDIF
#ELSE
    #SET(%CharTL,  ' ')
    #SET(%CharMin, ' ')
    #SET(%CharBL,  ' ')
    #SET(%CharPipe,' ')
#ENDIF
#!
#!*****************************************************************************
#UTILITY(PrintFileRelationsTree, 'Print File Relations Tree')
#!*****************************************************************************
#!
#DISPLAY('This Utility will generate the file relations tree to a text file.')
#DISPLAY('')
#PROMPT('Save to File:',SAVEDIALOG('Pick File','File Relations Tree|*.FTR')),%SaveToFile
#PREPARE
    #SET(%SaveToFile,%Application & '.FTR')
#ENDPREPARE
#DISPLAY('')
#PROMPT('Print the file after generation',CHECK),%DirectPrint,DEFAULT(0),AT(10)
#DISPLAY('')
#PROMPT('Does not print already expanded files',CHECK),%NoPrintExpandedFile,DEFAULT(1),AT(10)
#PREPARE
    #IF(%NoPrintExpandedFile = 1)
        #SET(%FileNewPage,0)
    #ENDIF
#ENDPREPARE
#ENABLE(%NoPrintExpandedFile = 0)
#PROMPT('Put every file relations tree on a new page',CHECK),%FileNewPage,DEFAULT(1),AT(20)
#ENDENABLE
#PROMPT('Use Graphics',CHECK),%UseGraphics,DEFAULT(1),AT(10)
#ENABLE(%UseGraphics = 1)
#PROMPT('Use ASCII graphical characters',CHECK),%ASCIIGraph,DEFAULT(1),AT(20)
#ENDENABLE
#INSERT(%ASCIICheck)
#DECLARE(%FileExpanded,%File)
#DECLARE(%FormFeed)
#SET(%FormFeed,'<12>')
#CREATE(%SaveToFile)
#MESSAGE(%Application,0)
File Relations Tree for %Application, dictionary %DictionaryFile
#FOR(%File),WHERE(ITEMS(%Relation) > 0 AND (%FileExpanded = %False OR NOT %NoPrintExpandedFile))
#MESSAGE('Generating: ' & %File,2)

#INSERT(%PrintFile,%File,'','    ')
#IF(%FileNewPage)
%FormFeed
#ENDIF
#ENDFOR
#CLOSE
#IF(%DirectPrint)
    #PRINT(%SaveToFile,'File Relations Tree for ' & %Application & ', dictionary ' & %DictionaryFile)
#ENDIF
#!
#GROUP(%PrintFile,%FileToPrint,%FileIndent,%NextIndent)
#DECLARE(%FileSeparator)
#DECLARE(%LastFile)
#DECLARE(%FileCounter)
#DECLARE(%SaveRelation)
    #FIX(%File,%FileToPrint)
    #SET(%FileExpanded, %True)
    #IF(CLIP(%NextIndent) = '')
        #SET(%FileSeparator,%CharBL & %CharMin)
    #ELSE
        #SET(%FileSeparator,%CharTL & %CharMin)
    #ENDIF
    #IF(LEN(%FileIndent) = 0)
        #SET(%FileSeparator,'*' & %CharMin)
    #ENDIF
    #IF(%FileDescription)
%FileIndent %FileSeparator %FileToPrint - %FileDescription
    #ELSE
%FileIndent %FileSeparator %FileToPrint
    #ENDIF
#FOR(%Relation),WHERE(%FileRelationType = '1:MANY')
    #IF(%File)
        #SET(%SaveRelation,INSTANCE(%Relation))
        #SET(%LastFile,%True)
        #LOOP,FOR(%FileCounter,INSTANCE(%Relation)+1,ITEMS(%Relation))
            #SELECT(%Relation,%FileCounter)
            #IF(%FileRelationType = '1:MANY')
                #SET(%LastFile,%False)
                #BREAK
            #ENDIF
        #ENDLOOP
        #SELECT(%Relation,%SaveRelation)
        #IF(%LastFile)
#INSERT(%PrintFile,%Relation,%FileIndent & %NextIndent, '     ')
        #ELSE
#INSERT(%PrintFile,%Relation,%FileIndent & %NextIndent, ' ' & %CharPipe & '   ')
        #ENDIF
    #ENDIF
#ENDFOR
#!
