BIN	  SEGMENT
	  ASSUME CS:BIN, DS:BIN

; RETURNS 1 IF READ ONLY IS SET OR 0 IF IT IS NOT
;
; IF ERRORCODE() = 2 IF FILE IS NOT FOUND

	  DB	    'BIO'
LIBVEC	  DD	    0
	  DW	    BINEND
	  DB	    1
	  DB	    'CHKATTR',0,0,0,0,0,0
	  DW	    CHKATTR
	  DB	    1
	  DB	    1

	  DB  0
CNAME	  DD  0
LEN	  DW  0

	  RTNVAL    DW	      0,0,0
	  FNAME	    DB	      128 DUP (?)
	  DOLSIG    DB	      '$'

CHKATTR	  PROC	    FAR

	SUB	    AX, AX		; CLEAR ERROR()
	CALL	    SETGLOBERR

	MOV	CX, LEN	      ; COPY FILE FROM CLARION STRING
	MOV SI, 0
	LES BX, CNAME

NEXTCHAR:
	MOV AL, ES:[BX]
	MOV FNAME[SI], AL
	INC BX
	INC SI
	DEC CX
	JNZ NEXTCHAR
	MOV FNAME[SI], 0

	LEA	DX, FNAME     ; CALL DOS INTERRUPT TO CHECK ATTRIBUTE
	MOV	AH,43H
	MOV	AL, 0
	INT	21H

	JC	_FAILED	      ; ABORT IF FILE NOT FOUND
	AND	CX, 1	      ; ACCESS READ ONLY ATTRIBUTE FLAG
	XCHG	AX, CX	      ; MOVE VALUE TO RETURNVAL
	MOV	RTNVAL, AX
	MOV	CX,2
	MOV	AX,1
	LEA	BX, RTNVAL
	RET

_FAILED:

	MOV	AX, 2		; SET ERRORLEVEL TO 2 'FILE NOT FOUND'
	CALL	    SETGLOBERR
	MOV	AX, 0H		; RETURN 0 TO PROGRAM
	MOV	RTNVAL, AX
	MOV	CX,2
	MOV	AX,1
	LEA	BX, RTNVAL
	RET

CHKATTR	  ENDP

;----------------------------------------------------
; SETS GLOBAL ERRORCODE()
; AX = ERRORCODE
;----------------------------------------------------
SETGLOBERR	    PROC      NEAR
	  PUSH	    ES
	  PUSH	    DI
	  PUSH	    AX
	  MOV	    AH,0FFh
	  MOV	    AL,29
	  CALL	    DWORD PTR LIBVEC
	  POP	    AX
	  MOV	    ES:[DI],AX
	  POP	    DI
	  POP	    ES
	  RET
SETGLOBERR	    ENDP


BINEND	  DB 0
BIN	  ENDS
	  END

