/*

Ĵ Description Ŀ
									  
   CHKSHARE checks if SHARE.EXE, and or if Windows is running whether	  
   VSHARE.386, is loaded in the permanent environment.	 CHKSHARE can	  
   optionally check the read-only attribute of a specified file (/F=).	  
   CHKSHARE has 3 modes of usage, Interupt Only (/I), Locked File (/L),  
   and Both (/B). Interupt mode simply checks Interupt 2Fh to see if	  
   SHARE is loaded in the AX Registers.  However, when in Windows 3.x,	  
   Interupt 2Fh is controlled by Windows and a check will always show	  
   SHARE.EXE is loaded, wheather it is or not.	 To check for SHARE in	  
   Windows, a Lock File check is required.  A temporary file must be	  
   created, then a call to Interupt 21h Function 5Ch is made to lock a	  
   region of the file. The Function always fails if SHARE is not loaded. 
   This is the preferred check method since it works in both true DOS	  
   and in a DOS session under Windows.	 The disadvantage of the Locked	  
   File method is that you must have file creation rights in the current 
   directory where CHKSHARE is being used.  This is not assured in a	  
   network or advanced operating system environment. If no command line  
   switches are used, the default is to run CHKSHARE in Both (/B) mode.  
   If a file name is entered on the command line (e.g. /F=APPNAME.EXE),  
   CHKSHARE will return wheather this file is set to the DOS read-only	  
   attribute as required on overlaid DOS programs that share files	  
   when SHARE is loaded (this does not apply to VSHARE.386).		  

Ĵ Legal Notice Ŀ
									  
   CHKSHARE is copyrighted(c) 1994 by Robert Butler & Kevin Stilwell	  
   This Program is freeware and may be freely used and distributed,	  
   including as part of a commercial program, as long as you do not	  
   remove the copyright notice, or attempt to sell CHKSHARE.EXE as	  
   a separate program.	 No warranties are expressed or implied.	  
   Robert Butler can be contacted on Compuserv CIS @ 76660,1514.	  
									  


Developed and tested using Borland C-C++ 3.1

*/

#include <dos.h>
#include <fcntl.h>
#include <io.h>
#include <share.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys\locking.h>
#include <sys\stat.h>

#define INT_MULTIPLEX  0x2F

void show_help(void);
int getLock(void);
extern "C" {
int winshare(void);
}

void main(int argc, char *argv[])

{
/* Initialize variables */

	int show_attrib = 0;
	int show_which = 0;
	auto union  REGS  aRegisters;
	auto struct SREGS aSegments;
	char filename[128];
	int attrib;
	int args;

/* Clear screen */
	system("CLS");

/* Check command line switches */

	for( args = 1; args < argc; args++ ) {
		if( argv[args][0] == '/' ) {
			switch(argv[args][1]) {
				case '?':
					show_help();
					return;
				case 'f':
				case 'F':
					show_attrib = args;
					break;
				case 'I':
				case 'i':
					show_which |= 1;
					break;
				case 'L':
				case 'l':
					show_which |= 2;
					break;
				case 'B':
				case 'b':
					show_which |= 3;
					break;
			}
		}
	}
	if(show_which == 0 )
		show_which = 3;

/* Use Interupt Only check to see if SHARE is loaded under DOS */

	if( show_which & 1 ) {
		aRegisters.x.ax = 0x1000;
		segread(&aSegments);
		int86x(INT_MULTIPLEX, &aRegisters, &aRegisters, &aSegments);

		switch (aRegisters.h.al)
		{
			case 0x00:
			   printf("\nSHARE.EXE is not installed.\n");
			   break;
			case 0x01:
			   printf("\nSHARE.EXE is not installed.\n");
			   printf("and it is not OK to install.\n");
			   break;
			default:
			   printf("\nSHARE.EXE is already installed.\n");
		   break;
		}
		printf("(Check made using Interupt Only mode - Not reliable in Windows 3.x)\n");
	}

	if( show_which & 2 ) {
		if( winshare() == 1 )
			printf("\nSHARE.EXE or VSHARE.386 is already installed.\n");
		else
			printf("\nSHARE.EXE or VSHARE.386 is not installed.\n");
	printf("(Check made using Locked File mode - Reliable for DOS and Windows 3.x)\n");
	}

/* Get file name from command line */

	if( show_attrib ) {
		strcpy(filename,&argv[show_attrib][3]);
		strupr(filename);

/* Check attribute of main application file */

		attrib = _chmod(filename,0);

		if (attrib == -1)
			printf("\nUnable to check attribute - File not found.\n");
		else {
			if (attrib & FA_RDONLY)
				printf("\n%s is set to read-only attribute.\n", filename);
			else
				printf("\n%s is not set to read-only attribute.\n", filename);
		 }
	}

	printf("\nType: CHKSHARE \/? for more information.\n\n");

/* Hold screen in case CHKSHARE is being called from another program */

	system("PAUSE");

}

/* Use Locked File test to check for SHARE under Windows */

winshare()
{
	int handle, status;
	char tname[30];
	tmpnam(tname);
	handle = open(tname, O_CREAT, S_IREAD | S_IWRITE);
	if( handle == -1 )
	{
		printf("Unable to open temporary file (using file name: %s).\n", tname);
		printf("Make sure you have file creation rights in current directory.\n");
		return -1;
	}

	status = lock(handle,0L,1L);
	unlock(handle,0L,1L);
	close(handle);
	unlink(tname);
	static int x = status==0;
	return status==0;
}

/* Command line help text (/?)	*/

void show_help()
{
	system("CLS");
	printf("\nCHKSHARE is copyrighted(c) 1994 by Robert Butler and Kevin Stilwell.\n");
	printf("This Program is freeware and may be freely used and distributed,\n");
	printf("including as part of a commercial program, as long as you do not\n");
	printf("remove the copyright notice or sell it as a separate program.\n\n");
	printf("Command Line Switches (use a space between each switch):\n\n");
	printf("  /B  Both modes - Uses both Interrupt Only and Locked File modes (default).\n");
	printf("  /I  Interrupt Only mode - Uses INT 2Fh. DOS only, not reliable in Windows.\n");
	printf("  /L  Locked File mode - Test locks temp file. Reliable in DOS and Windows.\n");
	printf("  /F= File - Checks for read-only attribute of the specified file name.\n");
	printf("             The read-only attribute is required on the main EXE of overlaid\n");
	printf("             DOS programs that open shared files in network or multi-tasking\n");
	printf("             environments if SHARE is loaded (does not apply to VSHARE.386).\n\n");
	printf("Sample Usage: CHKSHARE /L /F=APPNAME.EXE.\n\n");
	printf("NOTE: (1) You must have Network or Operating System file creation rights in\n");
	printf("          the current directory to use CHKSHARE in Locked File (/L) mode.\n");
	printf("      (2) SHARE can be loaded in AUTOEXEC.BAT or CONFIG.SYS, and VSHARE must\n");
	printf("          be loaded in SYSTEM.INI by DEVICE=VSHARE.386 in the [386Enh] area.\n");
	printf("          Check these files to see which of SHARE, VSHARE, or both are loaded.\n");
}
