#include	<stdio.h>
#include 	<stdlib.h>
#include	<string.h>
#include	<dos.h>

#define		INC_CLAMEM_H
#define		INC_CLAERROR_H
#define		INC_CLAARGH_H
#define     INC_CLAMISC_H
#define     INC_CLADATE_H
#define     INC_CLATIME_H
#define     INC_CLASTR_H
#define     INC_CLACNVT_H
#define     INC_CLAVID_H
#include	<cla.h>

#define LEM_STRING  0
#define LEM_WORD    1
#define LEM_LONG    2
#define LEM_REAL    3

#pragma save
#include <pragma.h>
#include <claprag.h>
void		*Lem$vector;
void		Lem$binproc(unsigned routine, unsigned args);
int			BININIT(unsigned flag, unsigned len, char *s);
void		Lem$badlemcall(int);
void		Lem$vector_trap(unsigned);

void pascal Lem$abs2date(long n, struct date *dt);
void pascal Lem$abs2time(long n, struct time *tm);
long pascal Lem$strtolong(char *s, unsigned len);
double pascal Lem$strtoreal(char *s,unsigned len);
void pascal Lem$BEEP(unsigned freq, unsigned dur);
void pascal Lem$clipstr(char *str);
long pascal Lem$time2abs(struct time *tm);
long pascal Lem$date2abs(struct date *dt);
char *pascal Lem$GETMEM(unsigned long val);
int pascal Lem$fullpath(void *xname, void *full);
void pascal Lem$rterr(unsigned err, void *buf);

#pragma restore

typedef struct {
	char			sig[3];
	void			(*vec)();
	unsigned		flen;
	unsigned char	nprocs;
}BINHDR;
typedef struct {
	char			proc_name[13];
	unsigned		proc_offs;
	char			isfunc;
	char			num_parms;
}BINPROCHDR;
typedef struct {
	char			type;	// 0=string, 1=word, 2=long, 3=real
	void			*parm;
	unsigned		len;
}BINPARMHDR;

BINHDR		*Bins[64];
unsigned	Bindex;

int		BININIT(unsigned flag, unsigned len, char *s)
{
	unsigned long	llen;
	int				count;
	char			temp[128], *cp;
	FILE			*fpi;
	BINHDR			*bin;
	
	cp = Cla$getswitch("CLABIN",0);     // environment switch locates BIN files.
	count=0;
	if(cp){
		strcpy(temp,cp);
		count = strlen(temp);
	}
	memcpy(&temp[count],s,len);
	temp[count+len] = 0;
	fpi = fopen(temp,"rb");
	if(!fpi){
        strcat(temp," : Could Not Open .BIN File");
		Cla$rterr(0,temp);
	}
	fseek(fpi,0L,SEEK_END);
	llen = ftell(fpi);
	fseek(fpi,0L,SEEK_SET);

	if(Cla$_LotSize < llen+128) flag = 0;    // VM lots big enough for BIN?
	if(flag)
		bin = GETVM(&bin,llen,0L);      // use VM
	else{
		bin = GETMEM(llen+0xF);      // else use static mem.
	    bin = (BINHDR*)(((unsigned long)bin+0xF)&0xFFFF0000L);
	}

	if(!bin){
		Cla$rterr(0,"Insufficient Memory To Load .BIN");
	}
	count = fread(bin,(unsigned)llen,1,fpi);
	if(!count)
		Cla$rterr(0,"Could Not Read .BIN File");
		
	fclose(fpi);
	bin->vec = Lem$vector_trap;
	Bins[Bindex] = bin;
	Bindex++;
	VIRTUAL(0L);
	return(Bindex<<8);
}


void	Lem$binproc(unsigned binid, unsigned args)
{
	unsigned		lem, item, count, len;
	BINHDR			*bin;
	BINPROCHDR		*proc;
	BINPARMHDR		*parm;	
	typedef struct{
		unsigned	len;
		char		*str;
	}STRING_ARG;
	STRING_ARG		*string_arg;
 	void			*addr;
	char			*gptr;
	
	lem = binid>>8;
	item = binid & 0xFF;
	if(!lem || lem>Bindex)
		Cla$rterr(0,"Call To Invalid or Uninitialized LEM");
	bin = Bins[lem-1];

	bin = CHAIN(bin);
	if(!item || item > bin->nprocs)
		Cla$rterr(0,"Call To Non Existent LEM Routine");
	gptr = (char*)(bin+1);
	proc = (BINPROCHDR*)gptr;
	item--;
	for(count=0; count<item; count++){
		gptr += (sizeof(BINPARMHDR)*proc->num_parms) + sizeof(BINPROCHDR);
		proc = (BINPROCHDR*)gptr;
	}
	Lem$vector = MK_FP(FP_SEG(bin),proc->proc_offs+FP_OFF(bin));

	parm = (BINPARMHDR*)(proc+1);
	gptr = MK_FP(FP_SEG(&args),args);
	for(count=0; count<proc->num_parms; count++){
		switch(parm->type){
		case	LEM_STRING:
			string_arg = (STRING_ARG*)gptr;
			addr = string_arg->str;
			len  = string_arg->len;
			gptr += sizeof(STRING_ARG);
			break;
		case	LEM_WORD:
			addr = gptr;
			len  = 2;
			gptr += len;
			break;
		case	LEM_LONG:
			addr = gptr;
			len  = 4;
			gptr += len;
			break;
		case	LEM_REAL:
			addr = gptr;
			len  = 8;
			gptr += len;
		}
		parm->parm = addr;
		parm->len  = len;
		parm++;
		
	}
	return;
}

void	Lem$badlemcall(int idx)
{
    char buf[255];
    
	if(idx < 0)
        sprintf(buf,"LEM to Library Data Vector: %d Not Supported",idx&0x00FF);
	else
        if (idx > 500)
            sprintf(buf,"LEM Return Type Mismatch: Actual Return=%d", idx-500);
	    else
            sprintf(buf,"LEM to Library Function Vector: %d Not Supported",idx);

	Cla$rterr(0,buf);
}


void Lem$abs2date(long n, struct date *dt)
{
    Cla$abs2date(n,dt);
}

void Lem$abs2time(long n, struct time *tm)
{
    Cla$abs2time(n,tm);
}

long Lem$strtolong(char *string, unsigned len)
{
    return(Cla$strtolong(string,len));
}

double Lem$strtoreal(char *s,unsigned len)
{
    double dd = Cla$strtoreal(s,len);
    return(dd);
}

void Lem$BEEP(unsigned freq, unsigned dur)
{
    Cla$BEEP(freq,dur);
}

void Lem$clipstr(char *str)
{
    Cla$clipstr(str);
}

long Lem$time2abs(struct time *tm)
{
    return(Cla$time2abs(tm));
}

long Lem$date2abs(struct date *dt)
{
    return(Cla$date2abs(dt));
}

char *Lem$GETMEM(unsigned long val)
{
    return(Cla$farcalloc(val,1));
}

int Lem$fullpath(void *xname, void *full)
{
    return(Cla$fullpath(xname,full));
}

void Lem$rterr(unsigned err, void *buf)
{
    Cla$rterr(err,buf);
}



