
   OMIT('***')
   The material herein was written by Gus M. Creces CIS 72073,1724 and is copyright. You
   are free to distribute it as you see fit and to use the code in your programs as long
   as proper credit is given. All comments and suggestions welcome.
   -----------------------------------------
   (C)1996 Gus M. Creces CIS 72073,1724
   Version 1.0 April 30, 1996.
   -----------------------------------------
   PURPOSE:
   This program demonstrates and explains four file information functions which can
   become useful tools in any Clarion programmer's toolkit.

   PROGRAMMING VALUE OF THESE FUNCTIONS:
   Frequently, a programmer encounters the need to determine a file's time or date stamp
   or needs to know the size of a file. I've provided three discrete functions each of which
   returns one of these pieces of information. A fourth function returns all three with
   a single function call.
   The functions are written in pure Clarion, no API calls, external libraries VBX's
   etc. are utilized or required.
   ***


   program

  include('equates')
  include('keycodes')
  include('errors')

InfoType    GROUP,PRE(FTY),TYPE                     !Group structure used with FileInfo
Time         LONG(0)                                ! to contain Time, Date and Size of
Date         LONG(0)                                ! file being tested. Since this is
Size         LONG(0)                                ! a type, it can be used to in the
            END                                     ! FileInfo() prototype.


FileInfoGrp LIKE(InfoType),PRE(INF)                 !A group of Type InfoType.
FileName    STRING(64)                              !String to hold file name being tested.
Toggle      LONG(FALSE)                             !Variable which will be toggled between
                                                    ! True and False.


  MAP                                               !Prototypes of functions/procedures
    FileTime(STRING),LONG                           ! being tested in this program.
    FileDate(STRING),LONG
    FileSize(STRING),LONG
    ShowHide(?,LONG)
    FileInfo(STRING,*InfoType)
  END


WINDOW WINDOW('File Information Functions'),AT(,,247,73),FONT('Arial',8,,FONT:regular),SYSTEM,GRAY,DOUBLE, |
         AUTO
       GROUP,AT(183,25,49,42),BOXED
         BUTTON('Select'),AT(190,33,35,14),USE(?SelectButton),DEFAULT
         BUTTON('Cancel'),AT(190,50,35,14),USE(?CancelButton)
       END
       STRING('File Name:'),AT(7,10,57,11),FONT('Arial',12,0FFH,FONT:bold),TRN,RIGHT(1)
       STRING(@s64b),AT(68,11,169,10),FONT('Arial',10,0800000H,FONT:regular),USE(FileName),TRN,LEFT
       STRING('File Time:'),AT(7,21,57,11),FONT('Arial',12,0FFH,FONT:bold),TRN,RIGHT(1)
       STRING(@T8b),AT(68,22,54,10),FONT('Arial',10,0800000H,FONT:regular),USE(INF:Time),TRN,HIDE,LEFT
       STRING('File Date:'),AT(7,33,57,11),FONT('Arial',12,0FFH,FONT:bold),TRN,RIGHT(1)
       STRING(@D3b),AT(68,34,53,10),FONT('Arial',10,0800000H,FONT:regular),USE(INF:date),TRN,LEFT
       STRING('File Size:'),AT(7,46,57,11),FONT('Arial',12,0FFH,FONT:bold),TRN,RIGHT(1)
       STRING(@N_10b),AT(68,47,59,10),FONT('Arial',10,0800000H,FONT:regular),USE(INF:Size),TRN,LEFT
       STRING('(C) 1996 G.M. Creces'),AT(89,59),FONT('Arial',,0808080H,)
     END


     CODE
     OPEN(Window)
     ACCEPT
       CASE EVENT()
       OF EVENT:OpenWindow
       OF EVENT:CloseWindow orof EVENT:CloseDown
         Break
       OF EVENT:Accepted
         CASE Accepted()
         OF ?SelectButton
           FILEDIALOG('Choose File',FileName,'All Files|*.*',0)  !Have the operator select a file.

           !-------------------------------------------------------------
           !This case structure is incorporated purely to demonstrate
           !that all four functions work as described.  When Toggle=True
           !you can see that only one function call is required to
           !determine the three separate pieces of information about
           !the selected file.
           !-------------------------------------------------------------

           CASE Toggle
           OF False                                              !If Toggle is false
            INF:Time = FileTime(FileName)                        ! then call the three file
            INF:Date = FileDate(FileName)                        ! information functions
            INF:Size = FileSize(FileName)                        ! separately.
           OF True                                               !If Toggle is true
            FileInfo(FileName,FileInfoGrp)                       ! call FileInfo to return
           END                                                   ! the same information
                                                                 ! in one call.
           !-------------------------------------------------------------
           !Toggling between True and False is a useful
           !technique which can be applied again and again
           !in your programs.
           !If toggle is False:
           !Toggle = 1 - 0 (i.e. 1)
           !If toggle is True:
           !Toggle = 1 - 1 (i.e. 0)
           !-------------------------------------------------------------
           Toggle = 1 - Toggle                                   ! Toggle between True/False.
           ShowHide(INF:Time,?INF:Time)                          ! Show/Hide the time field.

         OF ?CancelButton
          Post(EVENT:CloseWindow)                                !When user pushes cancel
    . . .                                                        ! post the close window event.


!-----------------------------------------------
ShowHide  Procedure(xParam,xField)
!Tests contents of incoming parameter. If it
!contains a number or string, it unhides the
!incoming field.  Otherwise the field is hidden.
!-----------------------------------------------
    CODE
    IF xParam THEN                                               !This is not too useful a
       UNHIDE(xField)                                            ! function but it comes in
    ELSE                                                         ! hand hiding time fields
       HIDE(xField)                                              ! with the value zero.
    END                                                          ! STRING(@T3b) does not
                                                                 ! give you a blank field when
                                                                 ! the field is zero because
                                                                 ! zero is interpreted as
                                                                 ! 12:00 midnight.

!-----------------------------------------------
FileTime   function(xFileName)
!Returns the time stamp on incoming file name.
!-----------------------------------------------
DirQueue  QUEUE,PRE(FIL),AUTO                                    !Standard DIRECTORY group.
Name         STRING(13)
Date         LONG
Time         LONG
Size         LONG
Attrib       BYTE
           END

     CODE
     Clear(DirQueue)                                             !Initialize the Queue.
     Directory(DirQueue,xFileName,ff_:Directory)                 !Load matching file info.
     return(FIL:Time)                                            !Return the file time.
                                                                 !Function assumes you haven't
                                                                 ! passed a file parameter with
                                                                 ! a wild card in it. In that
                                                                 ! case, the last file found will
                                                                 ! be reported.


!--------------------------------------------------
FileDate  function(xFileName)
!Returns the date stamp on an incoming file name.
!--------------------------------------------------
DirQueue  QUEUE,PRE(FIL),AUTO                                    !Standard DIRECTORY group.
Name         STRING(13)
Date         LONG
Time         LONG
Size         LONG
Attrib       BYTE
           END
     CODE
     CLEAR(DirQueue)                                             !Initialize the Queue
     DIRECTORY(DirQueue,xFileName,ff_:Directory)                 !Load the matching file info.
     RETURN(FIL:Date)                                            !Return the file date.
                                                                 !Function assumes you haven't
                                                                 ! passed a file parameter with
                                                                 ! a wild card in it. In that
                                                                 ! case, the last file found will
                                                                 ! be reported.

!-----------------------------------------------------
FileSize   FUNCTION(xFileName)
!Returns the file size in bytes, of an incoming file.
!-----------------------------------------------------
DirQueue  QUEUE,PRE(FIL),AUTO                                    !Standard DIRECTORY group.
Name         STRING(13)
Date         LONG
Time         LONG
Size         LONG
Attrib       BYTE
           END

     CODE
     CLEAR(DirQueue)                                             !Initialize the Queue.
     DIRECTORY(DirQueue,xFileName,ff_:Directory)                 !Load the matching file info.
     RETURN(FIL:Size)                                            !Return the file size.
                                                                 !Function assumes you haven't
                                                                 ! passed a file parameter with
                                                                 ! a wild card in it. In that
                                                                 ! case, the last file found
                                                                 ! will be reported.

!-------------------------------------------
FileInfo  PROCEDURE(xFileName,xGroup)
!Returns the file date stamp, time stamp
!and file size all at the same time, in
!the passed group.
!-------------------------------------------
DirQueue  QUEUE,PRE(FIL),AUTO                                    !Standard DIRECTORY group.
Name         STRING(13)
Date         LONG
Time         LONG
Size         LONG
Attrib       BYTE
           END

     CODE
     CLEAR(DirQueue)                                             !Initialize the Queue.
     DIRECTORY(DirQueue,xFileName,ff_:Directory)                 !Load the matching file info.
     xGroup :=: DirQueue                                         !Because xGroup was passed as
                                                                 ! a pointer, the actual data
                                                                 ! in xGroup is modified and
                                                                 ! available to the calling
                                                                 ! program.
                                                                 !Function assumes you haven't
                                                                 ! passed a file parameter with
                                                                 ! a wild card in it. In that
                                                                 ! case, the last file found
                                                                 ! will be reported.
