                     MEMBER('ESTIMATE.clw')       ! This is a MEMBER module
Main PROCEDURE

LocalRequest         LONG,AUTO
OriginalRequest      LONG,AUTO
LocalResponse        LONG,AUTO
WindowOpened         LONG
WindowInitialized    LONG
ForceRefresh         LONG,AUTO
DisplayDayString STRING('Sunday   Monday   Tuesday  WednesdayThursday Friday   Saturday ')
DisplayDayText   STRING(9),DIM(7),OVER(DisplayDayString)
AppFrame             APPLICATION('Estimator 3.0'),AT(0,0,320,200),HVSCROLL,STATUS(-1,80,120,45),SYSTEM,MAX,RESIZE,IMM
                       MENUBAR
                         MENU('&File'),USE(?FileMenu)
                           ITEM('&Print Setup ...'),USE(?PrintSetup),MSG('Setup printer'),STD(STD:PrintSetup)
                           ITEM,SEPARATOR
                           ITEM('E&xit'),USE(?Exit),MSG('Exit this application'),STD(STD:Close)
                         END
                         MENU('&Edit'),USE(?EditMenu)
                           ITEM('Cu&t'),USE(?Cut),MSG('Remove item to Windows Clipboard'),STD(STD:Cut)
                           ITEM('&Copy'),USE(?Copy),MSG('Copy item to Windows Clipboard'),STD(STD:Copy)
                           ITEM('&Paste'),USE(?Paste),MSG('Paste contents of Windows Clipboard'),STD(STD:Paste)
                         END
                         MENU('&Browse'),USE(?BrowseMenu),MSG('Browse data')
                           ITEM('Browse by &Estimate #'),USE(?BrowseEstimate_noItem),MSG('Browse Estimate File')
                           ITEM('Browse by &Customer'),USE(?Item19)
                           ITEM('Browse by &Status'),USE(?Item20)
                           ITEM('Browse &Product File'),USE(?Item16),MSG('Browse Product File')
                         END
                         MENU('&Report'),USE(?ReportMenu),MSG('Print a report')
                           ITEM('Report by &Estimate #'),USE(?ReportEstimate_noItem),MSG('Report by Estimate No')
                           ITEM('&Price List'),USE(?Item18)
                         END
                         MENU('&Window'),MSG('Create and Arrange windows')
                           ITEM('T&ile'),USE(?Tile),MSG('Make all open windows visible'),STD(STD:TileWindow)
                           ITEM('&Cascade'),USE(?Cascade),MSG('Stack all open windows'),STD(STD:CascadeWindow)
                           ITEM('&Arrange Icons'),USE(?Arrange),MSG('Align all window icons'),STD(STD:ArrangeIcons)
                         END
                         MENU('&Help'),MSG('Windows Help')
                           ITEM('&Contents'),USE(?Helpindex),MSG('View the contents of the help file'),STD(STD:HelpIndex)
                           ITEM('&Search for Help On...'),USE(?HelpSearch),MSG('Search for help on a subject'),STD(STD:HelpSearch)
                           ITEM('&How to Use Help'),USE(?HelpOnHelp),MSG('How to use Windows Help'),STD(STD:HelpOnHelp)
                           ITEM('&About Estimator'),USE(?Item17),MSG('About Estimator ....')
                         END
                       END
                     END
  CODE
  LocalRequest = GlobalRequest
  OriginalRequest = GlobalRequest
  LocalResponse = RequestCancelled
  ForceRefresh = False
  CLEAR(GlobalRequest)
  CLEAR(GlobalResponse)
  OPEN(AppFrame)
  WindowOpened=True
  IF NOT INRANGE(AppFrame{Prop:Timer},1,100)
    AppFrame{Prop:Timer} = 100
  END
    AppFrame{Prop:StatusText,3} = CLIP(DisplayDayText[(TODAY()%7)+1]) & ', ' & FORMAT(TODAY(),@D4)
    AppFrame{Prop:StatusText,4} = FORMAT(CLOCK(),@T3)
  ACCEPT
    CASE EVENT()
    OF EVENT:OpenWindow
      Splash_Screen()
      IF NOT WindowInitialized
        DO InitializeWindow
      END
    OF EVENT:GainFocus
      WindowInitialized = True
      DO InitializeWindow
    OF EVENT:Timer
        AppFrame{Prop:StatusText,3} = CLIP(DisplayDayText[(TODAY()%7)+1]) & ', ' & FORMAT(TODAY(),@D4)
        AppFrame{Prop:StatusText,4} = FORMAT(CLOCK(),@T3)
    END
    CASE FIELD()
    OF ?PrintSetup
      CASE EVENT()
      OF EVENT:Accepted
        DO SyncWindow
      END
    OF ?Exit
      CASE EVENT()
      OF EVENT:Accepted
        DO SyncWindow
      END
    OF ?Cut
      CASE EVENT()
      OF EVENT:Accepted
        DO SyncWindow
      END
    OF ?Copy
      CASE EVENT()
      OF EVENT:Accepted
        DO SyncWindow
      END
    OF ?Paste
      CASE EVENT()
      OF EVENT:Accepted
        DO SyncWindow
      END
    OF ?BrowseEstimate_noItem
      CASE EVENT()
      OF EVENT:Accepted
        DO SyncWindow
        IF START(Browse_Estimate,025000).
        ForceRefresh = True
        LocalRequest = OriginalRequest
      END
    OF ?Item19
      CASE EVENT()
      OF EVENT:Accepted
        DO SyncWindow
        IF START(Browse_by_Customer,025000).
        ForceRefresh = True
        LocalRequest = OriginalRequest
      END
    OF ?Item20
      CASE EVENT()
      OF EVENT:Accepted
        DO SyncWindow
        IF START(Browse_by_Status,025000).
        ForceRefresh = True
        LocalRequest = OriginalRequest
      END
    OF ?Item16
      CASE EVENT()
      OF EVENT:Accepted
        DO SyncWindow
        IF START(Browse_Product,025000).
        ForceRefresh = True
        LocalRequest = OriginalRequest
      END
    OF ?ReportEstimate_noItem
      CASE EVENT()
      OF EVENT:Accepted
        DO SyncWindow
        IF START(Report_Estimate,025000).
        ForceRefresh = True
        LocalRequest = OriginalRequest
      END
    OF ?Item18
      CASE EVENT()
      OF EVENT:Accepted
        DO SyncWindow
        IF START(Price_List,025000).
        ForceRefresh = True
        LocalRequest = OriginalRequest
      END
    OF ?Tile
      CASE EVENT()
      OF EVENT:Accepted
        DO SyncWindow
      END
    OF ?Cascade
      CASE EVENT()
      OF EVENT:Accepted
        DO SyncWindow
      END
    OF ?Arrange
      CASE EVENT()
      OF EVENT:Accepted
        DO SyncWindow
      END
    OF ?Helpindex
      CASE EVENT()
      OF EVENT:Accepted
        DO SyncWindow
      END
    OF ?HelpSearch
      CASE EVENT()
      OF EVENT:Accepted
        DO SyncWindow
      END
    OF ?HelpOnHelp
      CASE EVENT()
      OF EVENT:Accepted
        DO SyncWindow
      END
    OF ?Item17
      CASE EVENT()
      OF EVENT:Accepted
        DO SyncWindow
        Splash_Screen 
        ForceRefresh = True
        LocalRequest = OriginalRequest
      END
    END
  END
  DO ProcedureReturn
!---------------------------------------------------------------------------
ProcedureReturn ROUTINE
  IF WindowOpened
    CLOSE(AppFrame)
  END
  IF LocalResponse
    GlobalResponse = LocalResponse
  ELSE
    GlobalResponse = RequestCancelled
  END
  RETURN
!---------------------------------------------------------------------------
InitializeWindow ROUTINE
  DO RefreshWindow
!---------------------------------------------------------------------------
RefreshWindow ROUTINE
  DISPLAY()
  ForceRefresh = False
!---------------------------------------------------------------------------
SyncWindow ROUTINE
!---------------------------------------------------------------------------
