                     MEMBER('ESTIMATE.clw')       ! This is a MEMBER module
Worksheet PROCEDURE
RejectRecord         LONG,AUTO
LocalRequest         LONG,AUTO
LocalResponse        LONG,AUTO
WindowOpened         LONG,AUTO
RecordsToProcess     LONG,AUTO
RecordsProcessed     LONG,AUTO
RecordsPerCycle      LONG,AUTO
RecordsThisCycle     LONG,AUTO
PercentProgress      DECIMAL(4,1)
RecordStatus         BYTE,AUTO
SAV::det:estimate_no LIKE(det:estimate_no),AUTO   ! Save Range Limit Field
Report               REPORT,AT(1021,1010,5958,7906),PRE(RPT),THOUS
Estimate               BREAK(det:estimate_no)
                         HEADER,AT(,,,1844)
                           STRING('Estimate Worksheet'),AT(104,0,2083,313),FONT('Arial',14,0FF0000H,FONT:bold+FONT:italic),USE(?String16)
                           STRING(@n5),AT(5208,0,,),FONT('Arial',12,0FF0000H,FONT:bold+FONT:italic),USE(MAS:estimate_no)
                           STRING(@s30),AT(729,313,,),FONT('Arial',10,,FONT:bold+FONT:italic),USE(MAS:customer)
                           STRING('Date Issued:'),AT(4063,208,,),FONT('Arial',12,,FONT:bold+FONT:italic),USE(?String30)
                           STRING(@D1),AT(5104,208,,),FONT('Arial',12,0FF0000H,FONT:bold+FONT:italic),USE(MAS:date_issued)
                           STRING(@s20),AT(3958,521,,),FONT('Arial',12,0FF0000H,FONT:bold+FONT:italic),USE(MAS:status)
                           STRING('Status:'),AT(3333,521,,),FONT('Arial',12,,FONT:bold+FONT:italic),USE(?String25)
                           STRING(@s30),AT(729,521,,),FONT('Arial',10,,FONT:bold+FONT:italic),USE(MAS:address)
                           STRING(@s15),AT(729,729,,),FONT('Arial',10,,FONT:bold+FONT:italic),USE(MAS:city)
                           STRING(@s2),AT(1875,729,,),FONT('Arial',10,,FONT:bold+FONT:italic),USE(MAS:state)
                           STRING(@K#####-####K),AT(2188,729,,),FONT('Arial',10,,FONT:bold+FONT:italic),USE(MAS:zip)
                           STRING(@s20),AT(729,1042,,),FONT('Arial',10,,FONT:bold+FONT:italic),USE(MAS:contact)
                           STRING(@s20),AT(2500,1042,,),FONT('Arial',10,,FONT:bold+FONT:italic),USE(MAS:phone)
                           STRING('Profit'),AT(5521,1458,,),FONT('Arial',10,,FONT:bold),USE(?String24)
                           LINE,AT(104,1771,5729,0),USE(?Line2),COLOR(0FFH)
                           STRING('Estimate Number:'),AT(3646,0,,),FONT('Arial',12,,FONT:bold+FONT:italic),USE(?String17)
                           LINE,AT(104,1354,5729,0),USE(?Line1),COLOR(0FFH)
                           STRING('Product / Service'),AT(104,1458,,),FONT('Arial',10,,FONT:bold),USE(?String18)
                           STRING('Qty'),AT(1667,1458,,),FONT('Arial',10,,FONT:bold),USE(?String19)
                           STRING('Cost'),AT(2396,1458,,),FONT('Arial',10,,FONT:bold),USE(?String20)
                           STRING('Tot Cost'),AT(2813,1458,,),FONT('Arial',10,,FONT:bold),USE(?String21)
                           STRING('Sell'),AT(3958,1458,,),FONT('Arial',10,,FONT:bold),USE(?String22)
                           STRING('Tot Sell'),AT(4583,1458,,),FONT('Arial',10,,FONT:bold),USE(?String23)
                         END
detail                   DETAIL,AT(,,,563),FONT('Arial',10,,)
                           STRING(@s20),AT(104,104,,),FONT('Arial',10,,),USE(det:Product)
                           STRING(@n5),AT(1563,104,,),FONT('Arial',10,,),USE(det:quantity)
                           STRING(@n10.2),AT(1979,104,,),FONT('Arial',10,,),USE(det:cost)
                           STRING(@n10.2),AT(2708,104,,),FONT('Arial',10,,),USE(det:total_cost)
                           STRING(@n10.2),AT(3542,104,,),FONT('Arial',10,,),USE(det:sell)
                           STRING(@n10.2),AT(4375,104,,),FONT('Arial',10,,),USE(det:total_sell)
                           STRING(@n$-10.2),AT(5208,104,,),FONT('Arial',10,0800000H,FONT:bold),USE(det:profit)
                           STRING('Notes:'),AT(1563,313,,),FONT('Arial',10,,FONT:bold),USE(?String26)
                           STRING(@s35),AT(2083,313,2708,208),FONT('Arial',10,,),USE(det:note)
                           LINE,AT(1563,521,4271,0),USE(?Line3),COLOR(0FF0000H)
                         END
                         FOOTER,AT(,,,417)
                         END
                       END
                       FOOTER,AT(1063,9271,5875,323)
                         STRING('Estimator 3.0 - (c) RDR Limited. 1995'),AT(1771,104,,),FONT('Arial',10,0FF0000H,FONT:bold+FONT:italic),USE(?String31)
                       END
                       FORM,AT(1021,1000,5969,8625)
                       END
                     END
ProgressWindow       WINDOW('Progress...'),AT(,,142,59),CENTER,TIMER(1),GRAY,DOUBLE
                       STRING(''),AT(0,3,141,10),USE(?Progress:UserString),CENTER
                       BOX,AT(15,15,111,12),COLOR(00H),FILL(0FFFFFFH)
                       BOX,AT(21,18,100,6),COLOR(00H),FILL(0C0C0C0H)
                       BOX,AT(21,18,100,6),USE(?Progress:Thermometer),FILL(0FFH)
                       STRING(''),AT(0,30,141,10),USE(?Progress:PctText),CENTER
                       BUTTON('Cancel'),AT(45,42,50,15),USE(?Progress:Cancel)
                     END
  CODE
  LocalRequest = GlobalRequest
  LocalResponse = RequestCancelled
  CLEAR(GlobalRequest)
  CLEAR(GlobalResponse)
  IF Master::Used = 0
    CheckOpen(Master,1)
  END
  Master::Used += 1
  IF detail::Used = 0
    CheckOpen(detail,1)
  END
  detail::Used += 1
  RecordsToProcess = 00050
  RecordsPerCycle = 25
  RecordsProcessed = 0
  PercentProgress = 0
  OPEN(ProgressWindow)
  ?Progress:Thermometer{Prop:Width} = 0
  ?Progress:PctText{Prop:Text} = '0.0% Completed'
    ProgressWindow{Prop:Text} = 'Generating Report'
  ?Progress:UserString{Prop:Text}=''
  ACCEPT
    CASE EVENT()
    OF Event:OpenWindow
      SAV::det:estimate_no = det:estimate_no
      det:estimate_no = SAV::det:estimate_no
      SET(det:Key_estimate_no,det:Key_estimate_no)
      LOOP
        DO GetNextdetail
        DO ValidateRecord
        EXECUTE RecordStatus
          BEGIN
            LocalResponse = RequestCancelled
            BREAK
          END
          CYCLE
        END
        BREAK
      END
      IF LocalResponse = RequestCancelled
        POST(Event:CloseWindow)
        CYCLE
      END
      OPEN(Report)
      Report{Prop:Preview} = PrintPreviewImage
    OF Event:Timer
      LOOP RecordsPerCycle TIMES
        MAS:estimate_no = det:estimate_no                 ! Assign linking field value
        GET(Master,MAS:Key_estimate_no)                   ! Lookup record
        IF ERRORCODE()
          CLEAR(MAS:Record)                               ! Clear record if unsuccessful
        END
        PRINT(RPT:detail)
        LOOP
          DO GetNextRecord
          DO ValidateRecord
          EXECUTE RecordStatus
            BEGIN
              LocalResponse = RequestCancelled
              BREAK
            END
            CYCLE
          END
          BREAK
        END
        IF LocalResponse = RequestCancelled
          LocalResponse = RequestCompleted
          BREAK
        END
        LocalResponse = RequestCancelled
      END
      IF LocalResponse = RequestCompleted
        POST(Event:CloseWindow)
      END
    END
    CASE FIELD()
    OF ?Progress:Cancel
      CASE Event()
      OF Event:Accepted
        LocalResponse = RequestCancelled
        POST(Event:CloseWindow)
      END
    END
  END
  IF LocalResponse = RequestCompleted
    ENDPAGE(Report)
    ReportPreview
    IF GlobalResponse = RequestCompleted
      Report{PROP:FlushPreview} = True
    END
  END
  CLOSE(Report)
  FREE(PrintPreviewQueue)
  DO ProcedureReturn
ProcedureReturn ROUTINE
  Master::Used -= 1
  IF Master::Used = 0 THEN CLOSE(Master).
  detail::Used -= 1
  IF detail::Used = 0 THEN CLOSE(detail).
  IF LocalResponse
    GlobalResponse = LocalResponse
  ELSE
    GlobalResponse = RequestCancelled
  END
  RETURN
!-----------------------------------------------------------------------------
ValidateRecord       ROUTINE
  RecordStatus = Record:OutOfRange
  IF LocalResponse = RequestCancelled THEN EXIT.
  IF ERRORCODE() THEN EXIT.
  IF det:estimate_no <> SAV::det:estimate_no THEN EXIT.
  RecordStatus = Record:OK
  EXIT
GetNextdetail ROUTINE
  LocalResponse = RequestCancelled
  LOOP
    NEXT(detail)
    IF ERRORCODE() THEN EXIT.
    RecordsProcessed += 1
    RecordsThisCycle += 1
    IF PercentProgress < 100
      PercentProgress = (RecordsProcessed / RecordsToProcess)*100
      IF PercentProgress > 100
        PercentProgress = 100
      END
      ?Progress:Thermometer{Prop:Width} = ROUND(PercentProgress,0)
      ?Progress:PctText{Prop:Text} = FORMAT(PercentProgress,@N5.1) & '% Completed'
      DISPLAY()
    END
    BREAK
  END
  LocalResponse = RequestCompleted
  EXIT

GetNextRecord ROUTINE
  DO GetNextdetail
  IF LocalResponse = RequestCompleted THEN EXIT.
