 PROGRAM
   MAP
     CheckOpen(FILE,<BYTE>,<BYTE>)
     ReportPreview
     StandardWarning(LONG,<STRING>,<STRING>,<STRING>,<STRING>),LONG
     RIUpdate:Master(STRING),LONG
     RIDelete:Master,LONG
     RIUpdate:Product(STRING),LONG
     RIDelete:Product,LONG
     RIUpdate:detail(STRING),LONG
     RIDelete:detail,LONG
     RIUpdate:Master:detail(*DECIMAL),LONG
     RIDelete:Master:detail,LONG
     MODULE('ESTIM001.clw')
     Main 
     END
     MODULE('ESTIM002.clw')
     Update_Estimate 
     END
     MODULE('ESTIM003.clw')
     Browse_Estimate 
     Report_Estimate 
     END
     MODULE('ESTIM004.clw')
     Update_Detail 
     END
     MODULE('ESTIM005.clw')
     Browse_Product 
     END
     MODULE('ESTIM006.clw')
     Update_Product 
     END
     MODULE('ESTIM007.clw')
     Splash_Screen 
     END
     MODULE('ESTIM008.clw')
     Price_List 
     END
     MODULE('ESTIM009.clw')
     Worksheet 
     END
     MODULE('ESTIM010.clw')
     Proposal 
     END
     MODULE('ESTIM011.clw')
     Browse_by_Customer 
     END
     MODULE('ESTIM012.clw')
     Browse_by_Status 
     END
   END

   INCLUDE('Equates.CLW')
   INCLUDE('Keycodes.CLW')
   INCLUDE('Errors.CLW')

Sort:Alpha    STRING('  AFANAT'|
                    &'B BFBNBT'|
                    &'C CFCNCT'|
                    &'D DFDNDT'|
                    &'E EFENET'|
                    &'F FFFNFT'|
                    &'G GFGNGT'|
                    &'H HFHNHT'|
                    &'I IFINIT'|
                    &'J JFJNJT'|
                    &'K KFKNKT'|
                    &'L LFLNLT'|
                    &'M MFMNMT'|
                    &'N NFNNNT'|
                    &'O OFONOT'|
                    &'P PFPNPT'|
                    &'Q QN'|
                    &'R RFRNRT'|
                    &'S SFSNST'|
                    &'T TFTNTT'|
                    &'U UFUNUT'|
                    &'V VFVNVT'|
                    &'W WFWNWT'|
                    &'X XFXNXT'|
                    &'Y YFYNYT'|
                    &'Z ZN')
Sort:Alpha:Array    STRING(2),DIM(100),OVER(Sort:Alpha)

Sort:Name     STRING('   ALBAMEARNBAK'|
                    &'BATBENBIABOBBRA'|
                    &'BROBUACACCARCEN'|
                    &'CHRCOECONCORCRU'|
                    &'DASDELDIADONDUR'|
                    &'ELDEVEFELFISFLO'|
                    &'FREFUTGARGIBGOL'|
                    &'GOSGREGUTHAMHEM'|
                    &'HOBHOTINGJASJON'|
                    &'KAGKEAKIRKORKYO'|
                    &'LATLEOLIGLOUMAC'|
                    &'MAQMARMAUMCKMER'|
                    &'MILMONMORNATNOL'|
                    &'OKEPAGPAUPETPIN'|
                    &'PORPULRAUREYROB'|
                    &'ROSRUBSALSCASCH'|
                    &'SCRSHASIGSKISNA'|
                    &'SOUSTESTISUNTAY'|
                    &'TIRTUCVANWACWAS'|
                    &'WEIWIEWIMWOLYOR')
Sort:Name:Array     STRING(3),DIM(100),OVER(Sort:Name)


GlobalRequest     LONG(0),THREAD
GlobalResponse    LONG(0),THREAD
PrintPreviewQueue QUEUE
PrintPreviewImage   STRING(80)
                  END
Master                 FILE,DRIVER('TOPSPEED'),RECLAIM,PRE(MAS),CREATE,THREAD
Key_estimate_no          KEY(MAS:estimate_no),OPT,PRIMARY
Customer_Key             KEY(MAS:customer),DUP,NOCASE,OPT
Status_Key               KEY(MAS:status),DUP,NOCASE,OPT
Record                   RECORD
estimate_no                 DECIMAL(4)
customer                    STRING(30)
address                     STRING(30)
city                        STRING(15)
state                       STRING(2)
zip                         STRING(10)
contact                     STRING(20)
phone                       STRING(15)
date_issued                 STRING(10)
status                      STRING(20)
Profit                      DECIMAL(8,2)
Cost                        DECIMAL(8,2)
Sell                        DECIMAL(8,2)
Project                     STRING(20)
                         END
                       END
Master::Used LONG,THREAD

detail                 FILE,DRIVER('TOPSPEED'),PRE(det),CREATE,THREAD
Key_estimate_no          KEY(det:estimate_no),DUP,OPT
Record                   RECORD
estimate_no                 DECIMAL(4)
Product                     STRING(20)
quantity                    DECIMAL(4)
cost                        DECIMAL(8,2)
total_cost                  DECIMAL(8,2)
sell                        DECIMAL(8,2)
total_sell                  DECIMAL(8,2)
profit                      DECIMAL(8,2)
note                        STRING(35)
                         END
                       END
detail::Used LONG,THREAD

Product                FILE,DRIVER('TOPSPEED'),PRE(PRO),CREATE,THREAD
Key_Product              KEY(PRO:Product),NOCASE,OPT
Record                   RECORD
Product                     STRING(20)
Cost                        DECIMAL(8,2)
Distributor                 STRING(25)
Contact                     STRING(25)
Phone                       STRING(15)
Terms                       STRING(25)
Notes                       STRING(40)
                         END
                       END
Product::Used LONG,THREAD

  CODE
  Main

CheckOpen         PROCEDURE(File,OverrideCreate,OverrideOpenMode)

  CODE
  IF OMITTED(3)
    OPEN(File,42h)                                !Attempt to open the file
  ELSE
    OPEN(File,OverrideOpenMode)
  END
  CASE ERRORCODE()                                ! and check for errors
  OF NoError                                      !Return if no error
  OROF IsOpenErr                                  ! or if already open.
    DO ProcedureReturn
  OF NoFileErr                                    !If file was not found
    IF OMITTED(2)
    ELSIF OverrideCreate = TRUE
      DO CreateFile
    ELSE
      IF StandardWarning(Warn:CreateError,NAME(File)).
    END
  OF InvalidFileErr                               !Invalid Record Declaration
    IF StandardWarning(Warn:InvalidFile,NAME(File)).
  OF BadKeyErr                                    !Key Files must be rebuilt
    IF StandardWarning(Warn:InvalidKey,NAME(File))
      BUILD(File)                              !Rebuild the key files
    END
    IF ERRORCODE()
      IF StandardWarning(Warn:RebuildError,NAME(File)).
    ELSE
      IF OMITTED(3)
        OPEN(File,42h)                            !Attempt to open the file
      ELSE
        OPEN(File,OverrideOpenMode)
      END
    END
  END                                             !End of Case Structure
  IF ERRORCODE()
    IF StandardWarning(Warn:DiskError,NAME(File)) THEN HALT(0,'Disk Error').
  END
  DO ProcedureReturn
ProcedureReturn ROUTINE
  RETURN
CreateFile ROUTINE
  CREATE(File)                                    !Create the file
  IF ERRORCODE()
    IF ERRORCODE() = 90
      IF StandardWarning(Warn:CreateError,NAME(File)).
    ELSE
      IF StandardWarning(Warn:CreateError,NAME(File)).
    END
  END
  IF OMITTED(3)
    OPEN(File,42h)                                !Attempt to open the file
  ELSE
    OPEN(File,OverrideOpenMode)
  END
  IF ~ERRORCODE()                                 !  And return if it opened
    DO ProcedureReturn
  ELSE
    IF StandardWarning(Warn:CreateOpenError,NAME(File)).
  END

ReportPreview        PROCEDURE
LeftPageNumber       SHORT,AUTO
PreviewWindow WINDOW('Print Preview'),AT(,,300,200),CENTER,SYSTEM,GRAY
       BOX,AT(3,3,144,165),COLOR(00H)
       IMAGE(),AT(3,3,144,165),USE(?Image1)
       STRING(@s20),AT(90,171,57,10),USE(?Image1Page),RIGHT
       BOX,AT(150,3,144,165),COLOR(00H)
       IMAGE(),AT(150,3,144,165),USE(?Image2)
       STRING(@s20),AT(243,171,51,10),USE(?Image2Page),RIGHT
       BUTTON('&Previous Page'),AT(3,183,55,12),USE(?PreviewPreviousPage)
       BUTTON('&Next Page'),AT(60,183,55,12),USE(?PreviewNextPage)
       BUTTON('&Print'),AT(183,183,55,12),USE(?PreviewPrint)
       BUTTON('&Close'),AT(240,183,55,12),USE(?PreviewClose)
     END

   CODE
   GlobalResponse = RequestCancelled
   OPEN(PreviewWindow)
   LeftPageNumber = 1
   DO LoadPages
   ACCEPT
     CASE FIELD()
     OF ?PreviewClose
       IF Event() = Event:Accepted
         POST(Event:CloseWindow)
       END
     OF ?PreviewPrint
       IF Event() = Event:Accepted
         GlobalResponse = RequestCompleted
         POST(Event:CloseWindow)
       END
     OF ?PreviewPreviousPage
       IF Event() = Event:Accepted
         LeftPageNumber -= 2
         DO LoadPages
       END
     OF ?PreviewNextPage
       IF Event() = Event:Accepted
         LeftPageNumber += 2
         DO LoadPages
       END
     END
   END
   RETURN

LoadPages ROUTINE
   IF LeftPageNumber = 1
     ?PreviewPreviousPage{Prop:Disable}=True
   ELSE
     ?PreviewPreviousPage{Prop:Disable}=False
   END
   GET(PrintPreviewQueue,LeftPageNumber)
   ?Image1{Prop:Text} = PrintPreviewImage
   ?Image1Page{Prop:Text} = 'Page ' & LeftPageNumber
   IF LeftPageNumber = RECORDS(PrintPreviewQueue)
     ?PreviewNextPage{Prop:Disable}=True
     ?Image2Page{Prop:Text} = ''
     ?Image2{Prop:Hide} = True
   ELSIF LeftPageNumber = RECORDS(PrintPreviewQueue) - 1
     ?PreviewNextPage{Prop:Disable}=True
     GET(PrintPreviewQueue,LeftPageNumber+1)
     ?Image2{Prop:Text} = PrintPreviewImage
     ?Image2Page{Prop:Text} = 'Page ' & LeftPageNumber+1
     ?Image2{Prop:Hide} = False
   ELSE
     ?PreviewNextPage{Prop:Disable}=False
     GET(PrintPreviewQueue,LeftPageNumber+1)
     ?Image2{Prop:Text} = PrintPreviewImage
     ?Image2Page{Prop:Text} = 'Page ' & LeftPageNumber+1
     ?Image2{Prop:Hide} = False
   END


StandardWarning      FUNCTION(WarningID,WarningText1,WarningText2,WarningText3,WarningText4)
ErrorText            STRING(150),AUTO
ReturnValue          LONG
  CODE
  IF ERRORCODE() <> 90
    ErrorText = CLIP(ERROR()) & ' (' & ERRORCODE() & ')'
  ELSE
    ErrorText = CLIP(FILEERROR()) & ' (' & CLIP(FILEERRORCODE()) & ')'
  END
  CASE WarningID
  OF Warn:InvalidFile
    IF MESSAGE('Error: (' & CLIP(ErrorText) & ') accessing ' |
    & CLIP(WarningText1) & '.  Press OK to end this application.'|
    ,'Invalid File',ICON:Exclamation,Button:OK,BUTTON:OK,0).
    HALT(0,'Invalid File!')
  OF Warn:InvalidKey     
    IF MESSAGE(CLIP(WarningText1) & ' key file is invalid.  Do you '|
    &'want to rebuild the key?','Invalid Key',Icon:Question,|
    Button:Yes+Button:No,Button:Yes,0)=Button:No
      HALT(0,'Invalid Key!')
    ELSE
      RETURN(Button:Yes)
    END
  OF Warn:RebuildError   
    IF MESSAGE('Error: (' & CLIP(ErrorText) & ') repairing key for ' |
    & CLIP(WarningText1) & '.  Press OK to end this application.',|
    'Key Rebuild Error',ICON:Exclamation,Button:OK,BUTTON:OK,0).
    HALT(0,'Error Rebuilding Key!')
  OF Warn:CreateError    
    IF MESSAGE('Error: (' & CLIP(ErrorText) & ') creating ' |
    & CLIP(WarningText1) & '.  Press OK to end this application.',|
    'File Creation Error',ICON:Exclamation,Button:OK,BUTTON:OK,0).
    HALT(0,'File Creation Error!')
  OF Warn:CreateOpenError
    IF MESSAGE('Error: (' & CLIP(ErrorText) & ') opening created ' |
    & 'file:' & CLIP(WarningText1) & '.  Press OK to end this application.',|
    'File Creation Error',ICON:Exclamation,Button:OK,BUTTON:OK,0).
    HALT(0,'File Creation Error!')
  OF Warn:ProcedureToDo  
    RETURN(MESSAGE('The Procedure ' & CLIP(WarningText1) & 'has not '|
    &'been defined.','Procedure not defined',ICON:Exclamation,|
    Button:OK,BUTTON:OK,0))
  OF Warn:BadKeyedRec
    RETURN(MESSAGE('Unable to read keyed record.  Error: ' |
    & CLIP(ErrorText) & '.  Insert Aborted',ICON:Exclamation,|
    Button:OK,Button:OK,0))
  OF Warn:OutOfRangeHigh
    RETURN(MESSAGE('The value of ' & CLIP(WarningText1) & ' must'|
    &' be lower than ' & CLIP(WarningText2) & '.','Range Error',|
    ICON:Exclamation,Button:OK,Button:OK,0))
  OF Warn:OutOfRangeLow  
    RETURN(MESSAGE('The value of ' & CLIP(WarningText1) & ' must be'|
    &' higher than ' & CLIP(WarningText2) & '.','Range Error',|
    ICON:Exclamation,Button:OK,Button:OK,0))
  OF Warn:OutOfRange     
    RETURN(MESSAGE('The value of ' & CLIP(WarningText1) & ' must be '|
    &'between ' & CLIP(WarningText2) & ' and ' & CLIP(WarningText3) |
    & '.','Range Error',ICON:Exclamation,Button:OK,Button:OK,0))
  OF Warn:NotInFile
    RETURN(MESSAGE('The value for ' & CLIP(WarningText1) & ' must be '|
    &'found in the ' & CLIP(WarningText2) & ' file.','Field Contents '|
    &'Error',ICON:Exclamation,Button:OK,Button:OK,0))
  OF Warn:RestrictUpdate 
    RETURN(MESSAGE('This record is referenced from the file '|
    & CLIP(WarningText1) & '.  Linking field(s) have been restricted'|
    & ' from change and have been reset to original values.',|
    'Referential Integrity Update Error',ICON:Exclamation,|
    Button:OK,Button:OK,0))
  OF Warn:RestrictDelete 
    RETURN(MESSAGE('This record is referenced from the file '|
    & CLIP(WarningText1) & '.  This record cannot be deleted while'|
    & ' these references exist.','Referential Integrity Delete Error'|
    ,ICON:Exclamation,Button:OK,Button:OK,0))
  OF Warn:InsertError
    RETURN(MESSAGE('An error was experienced during the update of'|
    & ' record.  Error: ' & CLIP(ErrorText) & '.'|
    ,'Record Insert Error'|
    ,ICON:Exclamation,Button:OK,Button:OK,0))
  OF Warn:RIUpdateError
    IF ERRORCODE()
      RETURN(MESSAGE('This record was changed by another station.'|
      ,'Update Operation Error',Icon:Exclamation,|
      Button:OK,Button:OK,0))
    ELSE
      RETURN(MESSAGE('An error (' & CLIP(ErrorText) & ') was experienced'|
      &' when attempting to update a record from the file.  Probable Cause: ' |
      & CLIP(WarningText1) & '.','Update Operation Error',Icon:Exclamation,|
      Button:OK,Button:OK,0))
    END
  OF Warn:UpdateError
    RETURN(MESSAGE('An error was experienced changing this record.  '|
    &'Do you want to try to save again?','Record Update Error',|
    Icon:Exclamation,Button:Yes+Button:No+Button:Cancel,Button:Cancel,0))
  OF Warn:RIDeleteError
    RETURN(MESSAGE('An error (' & CLIP(ErrorText) & ') was experienced'|
    &' when attempting to delete a record from the file ' |
    & CLIP(WarningText1) & '.','Delete Operation Error',Icon:Exclamation,|
    Button:OK,Button:OK,0))
  OF Warn:DeleteError    
    RETURN(MESSAGE('An error was experienced deleting this record.  '|
    &'Do you want to try to save again?','Record Update Error',|
    Icon:Exclamation,Button:Yes+Button:No+Button:Cancel,Button:Cancel,0))
  OF Warn:InsertDisabled 
    RETURN(MESSAGE('This procedure was called to insert a record, '|
    & 'however inserts are not allowed for this procedure.  Press OK '|
    & 'to return to the calling procedure','Invalid Request',|
    Icon:Exclamation,Button:OK,Button:OK,0))
  OF Warn:UpdateDisabled
    RETURN(MESSAGE('This procedure was called to change a record, '|
    & 'however changes are not allowed for this procedure.  Press OK '|
    & 'to return to the calling procedure','Invalid Request',|
    ICON:Exclamation,Button:OK,Button:OK,0))
  OF Warn:DeleteDisabled 
    RETURN(MESSAGE('This procedure was called to delete a record, '|
    & 'however deletions are not allowed for this procedure.  Press OK '|
    & 'to return to the calling procedure','Invalid Request',|
    ICON:Exclamation,Button:OK,Button:OK,0))
  OF Warn:NoCreate       
    IF MESSAGE('The File ' & CLIP(WarningText1) & 'was not found, '|
    &'and creation of the file is not allowed.  Press OK to end '|
    &'this application.','File Creation Not Allowed',ICON:Exclamation,|
    Button:OK,BUTTON:OK,0)
      HALT(0,'File Creation Error!')
    END
  OF Warn:ConfirmCancel  
    RETURN(MESSAGE('Do you want to save the changes to this record?'|
    ,'Update Cancelled',ICON:Question,Button:Yes+Button:No+Button:Cancel,|
    Button:No,0))
  OF Warn:DuplicateKey
    RETURN(MESSAGE('Adding this record creates a duplicate entry '|
    &'for the key:' & CLIP(WarningText1),'Duplicate Key Error',|
    ICON:Exclamation,Button:OK,Button:OK,0))
  OF Warn:AutoIncError
    RETURN(MESSAGE('Attempts to automatically number this record have '|
    &'failed.  Error: ' & CLIP(ErrorText) & '.',|
    'Auto Increment Error',Icon:Exclamation,Button:Cancel+Button:Retry,|
    Button:Cancel,0))
  OF Warn:FileLoadError
    RETURN(MESSAGE(CLIP(WarningText1) & ' File Load Error.  '|
    &'Error: ' & CLIP(ErrorText) & '.','File Load Error',ICON:Exclamation,|
    Button:OK,Button:OK,0))
  OF Warn:ConfirmCancelLoad
    RETURN(MESSAGE('Are you certain you want to stop loading ' |
    & CLIP(WarningText1) & '?','Cancel Request',|
    ICON:Question,Button:OK+Button:Cancel,Button:Cancel,0))
  OF Warn:FileZeroLength
    RETURN(MESSAGE(CLIP(WarningText1) & ' File Load Error.  '|
    &'The file you''ve requested contains no text.','File Load Error',|
    ICON:Exclamation,Button:OK,Button:OK,0))
  OF Warn:EndOfASCIIQueue
    IF WarningText1 = 'Down'
      RETURN(MESSAGE('The end of the viewed file was encountered.  '|
      & 'Do you want to start again from the beginning?',|
      'End of File Error',ICON:Question,Button:Yes+Button:No,Button:Yes,0))
    ELSE
      RETURN(MESSAGE('The beginning of the viewed file was encountered.  '|
      & 'Do you want to start again from the end of the file?',|
      'Beginning of File Error',ICON:Question,Button:Yes+Button:No,|
      Button:Yes,0))
    END
  OF Warn:DiskError
    RETURN(MESSAGE('File (' & CLIP(WarningText1) & ') could not be '|
    & 'opened.  Error: ' & CLIP(ErrorText) & '.','File Access Error'|
    ,Icon:Exclamation,Button:OK,Button:OK,0))
  OF Warn:ProcessActionError
    IF WarningText1 = 'Put'
      RETURN(MESSAGE('An error was experienced when making changes'|
      & ' to the ' & CLIP(WarningText2) & ' file.  Error: '|
      & CLIP(ErrorText),'Process PUT Error',Icon:Exclamation|
      ,Button:OK,Button:OK,0))
    ELSE
      RETURN(MESSAGE('An error was experienced when deleting a record'|
      & ' from the ' & CLIP(WarningText2) & ' file.  Error: '|
      & CLIP(ErrorText),'Process DELETE Error',Icon:Exclamation|
      ,Button:OK,Button:OK,0))
    END
  OF Warn:StandardDelete
    RETURN(MESSAGE('You''ve selected to delete the highlighted record.  '|
    &'Press OK to confirm deletion of this record.',|
    'Confirm Delete',Icon:Question,Button:OK+Button:Cancel,Button:Cancel,0))
  END


!--------------------------------------------------
RIUpdate:Master      FUNCTION(Passed:Buffer)
Process:Buffer       LIKE(MAS:Record),PRE(RP),OVER(Passed:Buffer)
Current:Buffer       LIKE(MAS:Record),PRE(RC)
Current:Position     STRING(512)
  CODE
  Current:Position = POSITION(MAS:Key_estimate_no)
  Current:Buffer = MAS:Record
      IF detail::Used = 0
        CheckOpen(detail,1)
      END
      detail::Used += 1
  LOGOUT(2,Master,detail)
  REGET(MAS:Key_estimate_no,Current:Position)
  IF ERRORCODE()
    IF StandardWarning(Warn:RIUpdateError,'Record Changed/Deleted by Another Station')
      ROLLBACK()
      DO RICloseFiles
      RETURN(1)
    END
  END
  IF MAS:Record <> Passed:Buffer
    IF StandardWarning(Warn:RIUpdateError,'Record Changed by Another Station')
      ROLLBACK()
      REGET(MAS:Key_estimate_no,Current:Position)
      DO RICloseFiles
      RETURN(1)
    END
  END
  MAS:Record = Current:Buffer
  IF RP:estimate_no <> RC:estimate_no
    IF RIUpdate:Master:detail(RP:estimate_no)
      ROLLBACK
      DO RICloseFiles
      RETURN(1)
    END
  END
  PUT(Master)
  IF ERRORCODE()
    IF StandardWarning(Warn:RIUpdateError,'Master')
      ROLLBACK
      DO RICloseFiles
      RETURN(1)
    END
  ELSE
    COMMIT
    DO RICloseFiles
    RETURN(0)
  END
!----------------------------------------------------------------------
RICloseFiles ROUTINE
  detail::Used -= 1
  IF detail::Used = 0 THEN CLOSE(detail).
  EXIT

!--------------------------------------------------
RIDelete:Master      FUNCTION
Current:Position     STRING(512)
  CODE
  Current:Position = POSITION(MAS:Key_estimate_no)
      IF detail::Used = 0
        CheckOpen(detail,1)
      END
      detail::Used += 1
  LOGOUT(2,Master,detail)
  REGET(MAS:Key_estimate_no,Current:Position)
  IF RIDelete:Master:detail()
    ROLLBACK
    DO RICloseFiles
    RETURN(1)
  END
  DELETE(Master)
  IF ERRORCODE()
    IF StandardWarning(Warn:RIDeleteError,'Master')
      ROLLBACK
      DO RICloseFiles
      RETURN(1)
    END
  ELSE
    COMMIT
    DO RICloseFiles
    RETURN(0)
  END
!----------------------------------------------------------------------
RICloseFiles ROUTINE
  detail::Used -= 1
  IF detail::Used = 0 THEN CLOSE(detail).
  EXIT

!--------------------------------------------------
RIUpdate:Product     FUNCTION(Passed:Buffer)
Process:Buffer       LIKE(PRO:Record),PRE(RP),OVER(Passed:Buffer)
Current:Buffer       LIKE(PRO:Record),PRE(RC)
Current:Position     STRING(512)
  CODE
  Current:Position = POSITION(PRO:Key_Product)
  Current:Buffer = PRO:Record
  LOGOUT(2,Product)
  REGET(PRO:Key_Product,Current:Position)
  IF ERRORCODE()
    IF StandardWarning(Warn:RIUpdateError,'Record Changed/Deleted by Another Station')
      ROLLBACK()
      DO RICloseFiles
      RETURN(1)
    END
  END
  IF PRO:Record <> Passed:Buffer
    IF StandardWarning(Warn:RIUpdateError,'Record Changed by Another Station')
      ROLLBACK()
      REGET(PRO:Key_Product,Current:Position)
      DO RICloseFiles
      RETURN(1)
    END
  END
  PRO:Record = Current:Buffer
  PUT(Product)
  IF ERRORCODE()
    IF StandardWarning(Warn:RIUpdateError,'Product')
      ROLLBACK
      DO RICloseFiles
      RETURN(1)
    END
  ELSE
    COMMIT
    DO RICloseFiles
    RETURN(0)
  END
!----------------------------------------------------------------------
RICloseFiles ROUTINE
  EXIT

!--------------------------------------------------
RIDelete:Product     FUNCTION
Current:Position     STRING(512)
  CODE
  Current:Position = POSITION(PRO:Key_Product)
  LOGOUT(2,Product)
  REGET(PRO:Key_Product,Current:Position)
  DELETE(Product)
  IF ERRORCODE()
    IF StandardWarning(Warn:RIDeleteError,'Product')
      ROLLBACK
      DO RICloseFiles
      RETURN(1)
    END
  ELSE
    COMMIT
    DO RICloseFiles
    RETURN(0)
  END
!----------------------------------------------------------------------
RICloseFiles ROUTINE
  EXIT

!--------------------------------------------------
RIUpdate:detail      FUNCTION(Passed:Buffer)
Process:Buffer       LIKE(det:Record),PRE(RP),OVER(Passed:Buffer)
Current:Buffer       LIKE(det:Record),PRE(RC)
Current:Position     STRING(512)
  CODE
  Current:Position = POSITION(det:Key_estimate_no)
  Current:Buffer = det:Record
  LOGOUT(2,detail)
  REGET(det:Key_estimate_no,Current:Position)
  IF ERRORCODE()
    IF StandardWarning(Warn:RIUpdateError,'Record Changed/Deleted by Another Station')
      ROLLBACK()
      DO RICloseFiles
      RETURN(1)
    END
  END
  IF det:Record <> Passed:Buffer
    IF StandardWarning(Warn:RIUpdateError,'Record Changed by Another Station')
      ROLLBACK()
      REGET(det:Key_estimate_no,Current:Position)
      DO RICloseFiles
      RETURN(1)
    END
  END
  det:Record = Current:Buffer
  PUT(detail)
  IF ERRORCODE()
    IF StandardWarning(Warn:RIUpdateError,'detail')
      ROLLBACK
      DO RICloseFiles
      RETURN(1)
    END
  ELSE
    COMMIT
    DO RICloseFiles
    RETURN(0)
  END
!----------------------------------------------------------------------
RICloseFiles ROUTINE
  EXIT

!--------------------------------------------------
RIDelete:detail      FUNCTION
Current:Position     STRING(512)
  CODE
  Current:Position = POSITION(det:Key_estimate_no)
  LOGOUT(2,detail)
  REGET(det:Key_estimate_no,Current:Position)
  DELETE(detail)
  IF ERRORCODE()
    IF StandardWarning(Warn:RIDeleteError,'detail')
      ROLLBACK
      DO RICloseFiles
      RETURN(1)
    END
  ELSE
    COMMIT
    DO RICloseFiles
    RETURN(0)
  END
!----------------------------------------------------------------------
RICloseFiles ROUTINE
  EXIT
!--------------------------------------------------
RIUpdate:Master:detail FUNCTION(RP:MAS:estimate_no)

    CODE
    CLEAR(det:Record,0)
    det:estimate_no = RP:MAS:estimate_no
    SET(det:Key_estimate_no,det:Key_estimate_no)
    LOOP
      NEXT(detail)
      IF ERRORCODE() THEN RETURN(0).
      IF det:estimate_no <> RP:MAS:estimate_no
        RETURN(0)
      END
      det:estimate_no = MAS:estimate_no
      PUT(detail)
      IF ERRORCODE()
        IF StandardWarning(Warn:RIUpdateError,'detail')
          RETURN(1)
        END
      END
    END

!--------------------------------------------------
RIDelete:Master:detail FUNCTION
    CODE
    CLEAR(det:Record,0)
    det:estimate_no = MAS:estimate_no
    SET(det:Key_estimate_no,det:Key_estimate_no)
    LOOP
      NEXT(detail)
      IF ERRORCODE() THEN RETURN(0).
      IF MAS:estimate_no <> det:estimate_no
        RETURN(0)
      END
      DELETE(detail)
      IF ERRORCODE()
        IF StandardWarning(Warn:RIDeleteError,'Master')
          RETURN(1)
        END
      END
    END

