                Member('DOSFUNC.CLW')

!------------------------------------------------------------------------
! Local file
!------------------------------------------------------------------------
TempFile    File,Driver('DOS'),Name(DOSName)
              Record
              END
            END
!------------------------------------------------------------------------
! Local file group
!------------------------------------------------------------------------
FileInfo    Group, Pre(FIL)
FPAD          BYTE,DIM(21)  !Padding
FATTRIB       Byte          !Attribute
FTIME         Ushort        !Time
FDATE         Ushort        !Date
FSIZE         Long          !Size
FNAME         CString(13)   !DosName
            END
!------------------------------------------------------------------------
! Local variables
!------------------------------------------------------------------------
OKFlag         Byte,Auto
CheckFlag      Byte,Auto
xFrom          String(65)
xTo            String(65)
!------------------------------------------------------------------------
! Local equates - 3:rd parameter of DosFindFirst
!------------------------------------------------------------------------
eNormal     EQUATE(0)       !Normal file
eReadOnly   EQUATE(1)       !ReadOnly file
eHidden     EQUATE(2)       !Hidden file
eSystem     EQUATE(4)       !System file
eDirectory  EQUATE(10H)     !Directory
eArchive    EQUATE(20H)     !Archive
!------------------------------------------------------------------------
! Local equates - Function type requested
!------------------------------------------------------------------------
eCopyOne    EQUATE(1)       !Copy one file
eCopyAll    EQUATE(2)       !Copy all files with certain names
eRemoveOne  EQUATE(3)       !Remove one file
eRemoveAll  EQUATE(4)       !Remove all files with certain names
eExistFile  EQUATE(5)       !Does the file exist?
!------------------------------------------------------------------------
! Local equates - Return values
!------------------------------------------------------------------------
eFalse      EQUATE(0)       !Error in function
eTrue       EQUATE(1)       !No error in function
!------------------------------------------------------------------------
! Local functions MAP
!------------------------------------------------------------------------
                MAP
                  Exists(String),Byte                 !Does the file exist?
                  CopyOne(String,String),Byte         !Copy one file
                  CopyAll(String,String,String),Byte  !Copy all files with certain names
                  RemoveOne(String),Byte              !Remove one file
                  RemoveAll(String,String),Byte       !Remove all files with certain names
                END
!------------------------------------------------------------------------
! Function Call Analyzer
!------------------------------------------------------------------------
DOSFunc      FUNCTION(xType,xString1,xString2,xString3)

  CODE
  Case xType
    OF eCopyOne      !Copy one file
    Return(CopyOne(xString1,xString2))

    OF eCopyAll      !Copy all files with certain names
    Return(CopyAll(xString1,xString2,xString3))

    OF eRemoveOne    !Remove one file
    Return(RemoveOne(xString1))

    OF eRemoveAll    !Remove all files with certain names
    Return(RemoveAll(xString1,xString2))

    OF eExistFile    !Does file exist
    Return(Exists(xString1))

    ELSE             !Non existant function requested
    Return(eFalse)
  END

!------------------------------------------------------------------------
! Does the file exist?
!------------------------------------------------------------------------
Exists   Function(xDOSFile)
cDOSFile   CString(65)

   Code
   cDOSFile=xDOSFile
   OKFlag=eTrue
   If DosFindFirst(cDOSFile,FileInfo,eNormal) = 0        !If a file is found
     Return(OKFlag)                                      !Return OK
   ELSE                                                  !else
     Return(eFalse)                                      !Return Error
   END

!------------------------------------------------------------------------
! Copy one file
!------------------------------------------------------------------------
CopyOne      FUNCTION (FromName,ToName)

  CODE
  DOSName = FromName
  Copy(TempFile,ToName)
  If ErrorCode()
    Return(eFalse)
  Else
    Return(eTrue)
  END
!------------------------------------------------------------------------
! Copy all files with certain names to another directory
!------------------------------------------------------------------------
CopyAll    Function(xMask,xFromPath,xToPath)
cMask        CString(65)

   Code
   cMask=xMask
   OKFlag=eTrue
   If DosFindFirst(cMask,FileInfo,eNormal) = 0           !If a file is found
     Loop                                                !  process it and all other files
       xFrom   = Clip(xFromPath) & '\' & clip(Fil:FName) !Set source
       xTo     = Clip(xToPath)   & '\' & clip(Fil:FName) !Set destination
       CheckFlag = CopyOne(xFrom,xTo)                    !Copy file
       If Not CheckFlag then OKFlag=CheckFlag.           !If error, set return flag
       If DOSFindNext(FileInfo)                          !If no more files
         Break                                           !  break out of loop
       END
     END
   END
   Return(OKFlag)                                      !Return OK or Error

!------------------------------------------------------------------------
! Remove one file
!------------------------------------------------------------------------
RemoveOne    FUNCTION (xName)

  CODE
  DOSName = xName
  Remove(TempFile)
  If ErrorCode()
    Return(eFalse)
  Else
    Return(eTrue)
  END

!------------------------------------------------------------------------
! Remove all files with certain names
!------------------------------------------------------------------------
RemoveAll    Function(xMask,xPath)
cMask        CString(65)

   Code
   cMask=xMask
   OKFlag=eTrue
   If DosFindFirst(cMask,FileInfo,eNormal) = 0        !If a file is found
     Loop                                              !  process it and all other files
       xFrom = Clip(xPath) & '\' & clip(Fil:FName)     !Set DOS file name
       CheckFlag = RemoveOne(xFrom)                    !Remove file
       If Not CheckFlag then OKFlag=CheckFlag.         !If error, set return flag
       If DOSFindNext(FileInfo)                        !If no more files
         Break                                         !  break out of loop
       END
     END
   END
   Return(OKFlag)                                      !Return OK or Error
