     PROGRAM

!--------------------------------------------------------------------------------!
!                        DOS Functions                                           !
!--------------------------------------------------------------------------------!
! This program is FREEWARE and available to all interested CW developers.        !
! It can be compiled as a LIB or as a DLL or simply included as a source file.   !
! It will work with any version of CW (after recompilation) and possibly also    !
! with CDD. It will not work as a stand-alone EXE, but if you are a hand coder   !
! like myself you could easily add some code to test it as an EXE.               !
!--------------------------------------------------------------------------------!
!                                                                                !
!  Developed by:                                                                 !
!                                                                                !
!     Ragnar Hellspong                                                           !
!     KundSystem AB                                                              !
!     Mrdvgen 48                                                               !
!     S-167 56 BROMMA                                                            !
!     SWEDEN                                                                     !
!                                                                                !
!     Telephone and Fax: +46 8 704 21 25                                         !
!     CIS ID: 100044,1214                                                        !
!                                                                                !
!--------------------------------------------------------------------------------!
!  Put in the CIS TopSpeed Forum Library on April 26, 1996 after seeing a number !                         !
!  of questions on how to do the things that this program does through a simple  !
!  function call:                                                                !
!                                                                                !
!    Does a file exist?                                                          !
!    Copy one file                                                               !
!    Copy all files with certain names (mask)                                    !
!    Remove one file                                                             !
!    Remove all files with certain names (mask)                                  !
!                                                                                !
!--------------------------------------------------------------------------------!
!  Instructions for use                                                          !
!--------------------------------------------------------------------------------!
!  Four files are provided:                                                      !
!                                                                                !
!    DOSFunc.CLW        !Main program source code file                           !
!    DOSFunc1.CLW       !Member source code file                                 !
!    DOSFunc.PRJ        !Project file - neccessary only if DOSFUNC is compiled   !
!                       !as a LIB or as a DLL                                    !
!    DOSFunc.EXP        !Export file - neccessary only if DOSFUNC is compiled    !
!                       !as a DLL                                                !
!                                                                                !
!  To include DOSFunc as source code in an application, add the function         !
!  declarations to your own MAP and the variable DOSName as a global variable.   !
!  Add DOSFunc1.CLW as an External Source File and the DOS File Driver as a      !
!  Database Driver to your project.                                              !
!                                                                                !
!  To include DOSFunc as a LIB or as a DLL, compile it as a LIB or a DLL and add !
!  this to your own MAP:                                                         !
!                                                                                !
!    Module('DosFunc.LIB')                                                       !
!      DOSFunc(Byte,String,<String>,<String>),Byte                               !
!    END                                                                         !
!                                                                                !
!  In both cases add DOSFunc.LIB as a Library and Object File and the DOS File   !
!  Driver as a Database Driver to your project.                                  !
!                                                                                !
!  In all these cases, if you want to make your source code readable, add the    !
!  the following global Equates and use them in the calls to DOSFunc:            !
!                                                                                !
!  eCopyOne    EQUATE(1)       !Copy one file                                    !
!  eCopyAll    EQUATE(2)       !Copy all files with certain names                !
!  eRemoveOne  EQUATE(3)       !Remove one file                                  !
!  eRemoveAll  EQUATE(4)       !Remove all files with certain names              !
!  eExistFile  EQUATE(5)       !Does the file exist?                             !
!                                                                                !
!  These equates are used in the instructions below, but they are by no means    !
!  neccessary - you could simply use 1, 2 ,3, 4 and 5 instead.                   !
!--------------------------------------------------------------------------------!
!  How to call DOSFUNC                                                           !
!--------------------------------------------------------------------------------!
!                                                                                !
!  DOSFunc() covers the following tasks:                                         !
!                                                                                !
!  1. Copy one file                                                              !
!       First parameter:    1 or eCopyOne                                        !
!       Second parameter:   Full DOS filename of file to copy                    !
!       Third parameter:    Full DOS filename of destination file                !
!       Forth parameter:    <Not used>                                           !
!                                                                                !
!    Example:                                                                    !
!                                                                                !
!    ReturnValue=DOSFunc(eCopyOne,'C:\MyDir\MyFile.Dat','C:\SaveDir\MyFile.Sav') !
!                                                                                !
!  2. Copy all files with certain names                                          !
!       First parameter:    2 or eCopyAll                                        !
!       Second parameter:   Mask for files to copy                               !
!       Third parameter:    DOS Directory name of from-directory                 !
!       Forth parameter:    DOS Directory name of to-directory                   !
!                                                                                !
!    Example:                                                                    !
!                                                                                !
!    ReturnValue=DOSFunc(eCopyAll,'IDX*.K*','C:\MyDir','C:\SaveDir'              !
!                                                                                !
!  3. Remove one file                                                            !
!       First parameter:    3 or eRemoveOne                                      !
!       Second parameter:   Full DOS filename of file to remove                  !
!       Third parameter:    <Not used>                                           !
!       Forth parameter:    <Not used>                                           !
!                                                                                !
!    Example:                                                                    !
!                                                                                !
!    ReturnValue=DOSFunc(eRemoveOne,'C:\SaveDir\OldFiles\MyFile.Old')            !
!                                                                                !
!  4. Remove all files with certain names                                        !
!       First parameter:    4 or eRemoveAll                                      !
!       Second parameter:   Mask for files to remove                             !
!       Third parameter:    DOS Directory name of directory for files            !
!       Forth parameter:    <Not used>                                           !
!                                                                                !
!    Example:                                                                    !
!                                                                                !
!    ReturnValue=DOSFunc(eRemoveAll,'*.DAT','C:\MyDir')                          !
!                                                                                !
!  5. Does a file exist?                                                         !
!       First parameter:    5 or eExistFile                                      !
!       Second parameter:   Full DOS filename of file                            !
!       Third parameter:    <Not used>                                           !
!       Forth parameter:    <Not used>                                           !
!                                                                                !
!    Example:                                                                    !
!                                                                                !
!    ReturnValue=DOSFunc(eExistFile,'C:\MyDir\MyFile.Dat')                       !
!                                                                                !
!  In all these cases ReturnValue=1 indicates that the operation was successful  !
!  and ReturnValue=0 indicates an Error. The normal way to use a function like   !
!  DOSFunc is to skip the variable ReturnValue all together and use the          !
!  following form instead:                                                       !
!                                                                                !
!  If DOSFunc(eRemoveAll,'*.DAT','C:\MyDir') !Remove all .DAT files from MyDir   !
!    !Everything OK                                                              !
!  else                                                                          !
!    !Report an Error                                                            !
!  END                                                                           !
!                                                                                !
!  If you like to improve DOSFunc() one way could be through the addition of     !
!  Error reporting in DOSFunc1.Clw. This is what I do myself, but to avoid       !
!  language problems I removed all Error messages from the uploaded version.     !
!--------------------------------------------------------------------------------!

DOSName       String(65)

   MAP
     Module('DosFunc1.CLW')
       DOSFunc(Byte,String,<String>,<String>),Byte
     END
     MODULE('TopSpeed C Library')
       DosAccess(*CSTRING,SHORT),SHORT,RAW,NAME('_access')
       DosRemoveFile(*CSTRING),SHORT,RAW,NAME('_remove')
       DosRenameFile(*CSTRING,*CSTRING),SHORT,RAW,NAME('_rename')
       DosMkDir(*CSTRING),SHORT,RAW,NAME('_mkdir')
       DosRmDir(*CSTRING),SHORT,RAW,NAME('_rmdir')
       DosFindFirst(*CSTRING,*GROUP,SHORT),SHORT,RAW,NAME('_findfirst')
       DosFindNext(*GROUP),SHORT,RAW,NAME('_findnext')
     END
   END

   CODE

