ARSGLCTL     FILE,PRE(GL),NAME(GLNAME),RECLAIM,PROTECT,CREATE
	       OWNER('MjamesA'),ENCRYPT
CODE_KEY       KEY(GL:GL_CODE),NOCASE
NAME_KEY       KEY(GL:GL_NAME),DUP,NOCASE
RECORD	       RECORD
GL_CODE		 STRING(12)			 !General Ledger Account Name
GL_NAME		 STRING(25)			 !General Ledger Account Name
DB_TODAY	 DECIMAL(11,2)			 !Debits Today
CR_TODAY	 DECIMAL(11,2)			 !Credits Today
DB_MONTH	 DECIMAL(11,2)			 !Debits Month
CR_MONTH	 DECIMAL(11,2)			 !Credits Month
	     . .

ARSCTL	     FILE,PRE(CTL),NAME(CTLNAME),RECLAIM,PROTECT,CREATE
	       OWNER('MjamesA'),ENCRYPT
RECORD	       RECORD
FIN_CHG		 DECIMAL(5,2)			 !Finance Charge Percentage
MIN_FC		 DECIMAL(4,2)			 !Minimum Finance Charge
DEFAULT_FC	 STRING(12)			 !Finance Charge G/L Account
ARS_GL		 STRING(12)			 !ARS G/L Account
CASH_GL		 STRING(12)			 !Cash G/L Account
CHK_ACCT	 STRING(12)			 !CHECKS G/L ACCOUNT
DIST_INC	 STRING(1)			 !Distribute Income?
DR_INCOME	 STRING(12)			 !Default Drs. Income
HY_INCOME	 STRING(12)			 !Default Hygenists Income
CASH_DISC	 STRING(12)			 !CASH DISCOUNT ACCOUNT
WEL_DISC	 STRING(12)			 !WELFARE DISCOUNT ACCOUNT
PRO_DISC	 STRING(12)			 !PROFESSIONAL DISCOUNT ACCOUNT
SR_DISC		 STRING(12)			 !SR CITIZEN DISCOUNT ACCOUNT
INS_DISC	 STRING(12)			 !INSURANCE DISCOUNT ACCOUNT
VA_DISC		 STRING(12)			 !VETERANS DISCOUNT ACCOUNT
OTH_DISC	 STRING(12)			 !OTHER DISCOUNTS ACCOUNT
BAD_DEBT	 STRING(12)			 !BAD DEBT EXPENSE
PRINT_NAME	 STRING(1)			 !Print Name on Statement?
	     . .

ARSINFO	     FILE,PRE(INF),NAME(INFNAME),RECLAIM,PROTECT,CREATE
	       OWNER('MjamesA'),ENCRYPT
RECORD	       RECORD
CO_RPT		 STRING(60)			 !Company Report Name
CO_DISP		 STRING(30)			 !Company Screen Display Name
CO_ADDR1	 STRING(30)			 !Company Address Line 1
CO_ADDR2	 STRING(30)			 !Company Address 2
CO_CITY		 STRING(25)			 !Company City
CO_STATE	 STRING(2)			 !Company State
CO_ZIP		 LONG				 !Company Zip Code
EIN		 STRING(20)			 !Doctor's EIN Number
LICENSE		 STRING(20)			 !Dr.'s License Number
PRINTER_1	 STRING(40)			 !Printer Name
PRINT1_TYPE	 STRING(1)			 !Printer Type
PRINT_LOC1	 STRING(4)			 !Printer Location
PRINTER_2	 STRING(40)			 !Printer 2 Type
PRINT2_TYPE	 STRING(1)			 !Printer Type
PRINT_LOC2	 STRING(4)			 !Printer Location
NEXT_PATIENT	 SHORT				 !Next Patient Account Number
	     . .

PROCEDUR     FILE,PRE(PRC),NAME(PRCNAME),RECLAIM,PROTECT,CREATE
	       OWNER('MjamesA'),ENCRYPT
CODE_KEY       KEY(PRC:CODE),NOCASE
NAME_KEY       KEY(PRC:NAME),DUP,NOCASE
RECORD	       RECORD
CODE		 SHORT				 !Procedure Code
NAME		 STRING(30)			 !Procedure Name
BILL_AMT	 DECIMAL(6,2)			 !Procedure Billing Amount
BILL_YTD	 DECIMAL(11,2)			 !Billings Year to Date
BILL_JAN	 DECIMAL(11,2)			 !Billings for January
BILL_FEB	 DECIMAL(11,2)			 !Billings for February
BILL_MAR	 DECIMAL(11,2)			 !Billings for March
BILL_APR	 DECIMAL(11,2)			 !Billings for April
BILL_MAY	 DECIMAL(11,2)			 !Billings for May
BILL_JUN	 DECIMAL(11,2)			 !Billings for June
BILL_JUL	 DECIMAL(11,2)			 !Billings for July
BILL_AUG	 DECIMAL(11,2)			 !Billings for August
BILL_SEP	 DECIMAL(11,2)			 !Billings for September
BILL_OCT	 DECIMAL(11,2)			 !Billings for October
BILL_NOV	 DECIMAL(11,2)			 !Billings for November
BILL_DEC	 DECIMAL(11,2)			 !Billings for December
AMT_YTD		 LONG				 !Units Year to Date
AMT_JAN		 SHORT				 !Units for January
AMT_FEB		 SHORT				 !Units for February
AMT_MAR		 SHORT				 !Units for March
AMT_APR		 SHORT				 !Units for April
AMT_MAY		 SHORT				 !Units for May
AMT_JUN		 SHORT				 !Units for June
AMT_JUL		 SHORT				 !Units for July
AMT_AUG		 SHORT				 !Units for August
AMT_SEP		 SHORT				 !Units for September
AMT_OCT		 SHORT				 !Units for October
AMT_NOV		 SHORT				 !Units for November
AMT_DEC		 SHORT				 !Units for December
	     . .

PRODUCER     FILE,PRE(PRD),NAME(PRDNAME),RECLAIM,PROTECT,CREATE
	       OWNER('MjamesA'),ENCRYPT
CODE_KEY       KEY(PRD:CODE),NOCASE
NAME_KEY       KEY(PRD:NAME),DUP,NOCASE
RECORD	       RECORD
CODE		 BYTE				 !Producer Code
NAME		 STRING(25)			 !Producer Name
PROD_TYPE	 STRING(1)			 !Producer Type
BILL_YTD	 DECIMAL(11,2)			 !Billings Year to Date
BILL_JAN	 DECIMAL(11,2)			 !Billings for January
BILL_FEB	 DECIMAL(11,2)			 !Billings for February
BILL_MAR	 DECIMAL(11,2)			 !Billings for March
BILL_APR	 DECIMAL(11,2)			 !Billings for April
BILL_MAY	 DECIMAL(11,2)			 !Billings for May
BILL_JUN	 DECIMAL(11,2)			 !Billings for June
BILL_JUL	 DECIMAL(11,2)			 !Billings for July
BILL_AUG	 DECIMAL(11,2)			 !Billings for August
BILL_SEP	 DECIMAL(11,2)			 !Billings for August
BILL_OCT	 DECIMAL(11,2)			 !Billings for October
BILL_NOV	 DECIMAL(11,2)			 !Billings for November
BILL_DEC	 DECIMAL(11,2)			 !Billings for December
AMT_YTD		 LONG				 !Units Year to Date
AMT_JAN		 SHORT				 !Units for January
AMT_FEB		 SHORT				 !Units for February
AMT_MAR		 SHORT				 !Units for March
AMT_APR		 SHORT				 !Units for April
AMT_MAY		 SHORT				 !Units for May
AMT_JUN		 SHORT				 !Units for June
AMT_JUL		 SHORT				 !Units for July
AMT_AUG		 SHORT				 !Units for August
AMT_SEP		 SHORT				 !Units for September
AMT_OCT		 SHORT				 !Units for October
AMT_NOV		 SHORT				 !Units for November
AMT_DEC		 SHORT				 !Units for December
	     . .

RECALL	     FILE,PRE(RCL),NAME(RCLNAME),RECLAIM,PROTECT,CREATE
	       OWNER('MjamesA'),ENCRYPT
CODE_KEY       KEY(RCL:CODE),NOCASE
NAME_KEY       KEY(RCL:NAME),DUP,NOCASE
RECORD	       RECORD
CODE		 SHORT				 !Recall Code
NAME		 STRING(70)			 !Recall Reason
	     . .

PRTFILE	  FILE,NAME(PRTNAME),RECLAIM,PROTECT
	    OWNER('MjamesA'),ENCRYPT
PRTKEY	    KEY(PRINTER,DESCRIP)		 !PRINTER KEY
RECORD	    RECORD
KEYGRP	      GROUP				 !KEY GROUP
PRINTER		STRING(8)			 !  PRINTER CODE
DESCRIP		STRING(25)			 !  FULL DESCRIPTION OF PRINTER
	      .					 !END KEY GROUP
CODEGRP	      GROUP				 !CODE GROUP
DPPRNT		STRING(5)			 !  DATA PROCESSING MODE ON
LQPRNT		STRING(5)			 !  LETTER QUALITY MODE ON
DWON		STRING(5)			 !  DOUBLE WIDE ON
DWOFF		STRING(5)			 !  DOUBLE WIDE OFF
DHON		STRING(5)			 !  DOUBLE HIGH ON
DHOFF		STRING(5)			 !  DOUBLE HIGH OFF
ULON		STRING(5)			 !  UNDERLINE ON
ULOFF		STRING(5)			 !  UNDERLINE OFF
BOLDON		STRING(5)			 !  BOLDFACE ON
BOLDOFF		STRING(5)			 !  BOLDFACE OFF
OVERON		STRING(5)			 !  OVERSTRIKE ON
OVEROFF		STRING(5)			 !  OVERSTRIKE OFF
SUPERON		STRING(5)			 !  SUPERSCRIPT ON
SUBON		STRING(5)			 !  SUBSCRIPT ON
SSOFF		STRING(5)			 !  SUPER/SUBSCRIPT OFF
ITLICON		STRING(5)			 !  ITALICS ON
ITLICOFF	STRING(5)			 !  ITALICS OFF
CPI10		STRING(5)			 !  10 CHARACTERS PER INCH(PICA)
CPI12		STRING(5)			 !  12 CHARACTERS PER INCH(ELITE)
CPI17		STRING(5)			 !  CONDENSED MODE
CPI17CANCEL	STRING(5)			 !  CANCEL CONDENSED MODE
BACKSPC		STRING(5)			 !  BACKSPACE CHARACTER
LINEFD		STRING(5)			 !  LINEFEED
FORMFD		STRING(5)			 !  FORMFEED
CR		STRING(5)			 !  CARRIAGE RETURN
MODELFCR	STRING(5)			 !  EACH LF = LF+CR
MODELF		STRING(5)			 !  LF ONLY, NO CR
MODECR		STRING(5)			 !  CR ONLY, NO LF
MODECRLF	STRING(5)			 !  EACH CR = CR+LF
UNIDIREC	STRING(5)			 !  UNIDERECTIONAL PRINT ONLY
BIDIREC		STRING(5)			 !  BIDIRECTIONAL PRINTING
RESET		STRING(5)			 !  PRINTER RESET
DUMMY1		STRING(5)			 !
DUMMY2		STRING(5)			 !
DUMMY3		STRING(5)			 ! RESERVED FOR FUTURE
DUMMY4		STRING(5)			 !	    USE
DUMMY5		STRING(5)			 !
DUMMY6		STRING(5)			 !
REVPRT		STRING(5)			 ! REVERSE PRINT
CANREVPRT	STRING(5)			 ! CANCEL REVERSE PRINT
	  . . .					 !END FILE, RECORD, GROUP

PATIENT	     FILE,NAME(PATNAME),PRE(PAT),PROTECT,CREATE
	       OWNER('MjamesA'),ENCRYPT
CODE_KEY       KEY(PAT:CODE),NOCASE
NAME_KEY       KEY(PAT:LAST_NAME,PAT:CITY),DUP,NOCASE
ZIP_KEY	       KEY(PAT:ZIP_CODE),DUP,NOCASE
AMT_KEY	       KEY(PAT:BAL_DUE),DUP,NOCASE,OPT
BIRTH_KEY      KEY(PAT:BIRTH_DAY),DUP,NOCASE,OPT
RECORD	       RECORD
CODE		 LONG				 !Customer Code Number
FIRST_NAME	 STRING(20)			 !Patient First Name
LAST_NAME	 STRING(20)			 !Patient Last Name
NAME		 STRING(40)			 !Patient Full Name
ADDRESS_1	 STRING(25)			 !Patient Street Address Line 1
ADDRESS_2	 STRING(25)			 !Patient Address Line 2
CITY		 STRING(15)			 !Patient City
STATE		 STRING(2)			 !Patient State
ZIP_CODE	 LONG				 !Patient Zip Code
HOME_PHONE	 STRING(12)			 !Patient Home Phone Number
WORK_PHONE	 STRING(12)			 !Patient Work Phone Number
BIRTH_DAY	 LONG				 !Patient Birth Date
SEX		 STRING(1)			 !Patient's Sex
SOC_SEC		 STRING(11)			 !Patient's Social Security Nbr
MAIN_SUB	 STRING(1)			 !Is this a Main (H of H)?
MAIN_ACT	 LONG				 !Main Account Number (If sub)
RELATE		 STRING(2)			 !Patient's Relationship to Main
ACCT_TYPE	 STRING(1)			 !Account Type
RECALL_1	 SHORT				 !Recall Reason 1
RECALL_2	 SHORT				 !Recall Reason 2
RECALL_DATE	 LONG				 !Recall Date
FINANCE_CHG	 STRING(1)			 !FINANCE CHARGES
DELINQ_CODE	 STRING(4)			 !Delinquency Code
PMT_PLAN	 STRING(1)			 !Payment Plan (Budget Plan)
PLAN_AMT	 DECIMAL(5,2)			 !Budget Plan Fixed Monthly Amt
PLAN_DATE	 LONG				 !Date to Pay in full
INSUR_CO	 STRING(20)			 !Insurance Company
POLICY_NO	 STRING(20)			 !Insurance Policy Number
ADD_DATE	 LONG				 !Date Patient Added to System
SALE_DATE	 LONG				 !Date of Last Visit
PAY_DATE	 LONG				 !Date of Last Payment
YTD_CHARGES	 DECIMAL(8,2)			 !Year to Date Charges
JAN_CHARGES	 DECIMAL(7,2)			 !January Charges
FEB_CHARGES	 DECIMAL(7,2)			 !February Charges
MAR_CHARGES	 DECIMAL(7,2)			 !March Charges
APR_CHARGES	 DECIMAL(7,2)			 !April Charges
MAY_CHARGES	 DECIMAL(7,2)			 !May Charges
JUN_CHARGES	 DECIMAL(7,2)			 !June Charges
JUL_CHARGES	 DECIMAL(7,2)			 !July Charges
AUG_CHARGES	 DECIMAL(7,2)			 !August Charges
SEP_CHARGES	 DECIMAL(7,2)			 !September Charges
OCT_CHARGES	 DECIMAL(7,2)			 !October Charges
NOV_CHARGES	 DECIMAL(7,2)			 !November Charges
DEC_CHARGES	 DECIMAL(7,2)			 !December Charges
YTD_PAYMENTS	 DECIMAL(8,2)			 !Year to Date Payments
JAN_PAYMENTS	 DECIMAL(7,2)			 !January Payments
FEB_PAYMENTS	 DECIMAL(7,2)			 !February Payments
MAR_PAYMENTS	 DECIMAL(7,2)			 !March Payments
APR_PAYMENTS	 DECIMAL(7,2)			 !April Payments
MAY_PAYMENTS	 DECIMAL(7,2)			 !May Payments
JUN_PAYMENTS	 DECIMAL(7,2)			 !June Payments
JUL_PAYMENTS	 DECIMAL(7,2)			 !July Payments
AUG_PAYMENTS	 DECIMAL(7,2)			 !August Payments
SEP_PAYMENTS	 DECIMAL(7,2)			 !September Payments
OCT_PAYMENTS	 DECIMAL(7,2)			 !October Payments
NOV_PAYMENTS	 DECIMAL(7,2)			 !November Payments
DEC_PAYMENTS	 DECIMAL(7,2)			 !December Payments
YTD_INSPMTS	 DECIMAL(8,2)			 !Year to Date Ins Payments
JAN_INSPMTS	 DECIMAL(7,2)			 !January Ins Payments
FEB_INSPMTS	 DECIMAL(7,2)			 !February Ins Payments
MAR_INSPMTS	 DECIMAL(7,2)			 !March Ins Payments
APR_INSPMTS	 DECIMAL(7,2)			 !April Ins Payments
MAY_INSPMTS	 DECIMAL(7,2)			 !May Ins Payments
JUN_INSPMTS	 DECIMAL(7,2)			 !June Ins Payments
JUL_INSPMTS	 DECIMAL(7,2)			 !July Insurance Payments
AUG_INSPMTS	 DECIMAL(7,2)			 !August Ins Payments
SEP_INSPMTS	 DECIMAL(7,2)			 !September Ins Payments
OCT_INSPMTS	 DECIMAL(7,2)			 !October Ins Payments
NOV_INSPMTS	 DECIMAL(7,2)			 !November Ins Payments
DEC_INSPMTS	 DECIMAL(7,2)			 !December Ins Payments
YTD_FC		 DECIMAL(8,2)			 !Year to Date FC
JAN_FC		 DECIMAL(7,2)			 !January FC
FEB_FC		 DECIMAL(7,2)			 !February FC
MAR_FC		 DECIMAL(7,2)			 !March FC
APR_FC		 DECIMAL(7,2)			 !April FC
MAY_FC		 DECIMAL(7,2)			 !May FC
JUN_FC		 DECIMAL(7,2)			 !June FC
JUL_FC		 DECIMAL(7,2)			 !July FC
AUG_FC		 DECIMAL(7,2)			 !August FC
SEP_FC		 DECIMAL(7,2)			 !September FC
OCT_FC		 DECIMAL(7,2)			 !October FC
NOV_FC		 DECIMAL(7,2)			 !November FC
DEC_FC		 DECIMAL(7,2)			 !December FC
BAL_DUE		 DECIMAL(8,2)			 !Patient Account Balance Due
THIS_MO		 DECIMAL(8,2)			 !Charges this month
CURRENT		 DECIMAL(8,2)			 !Current Charges
DAYS_30		 DECIMAL(8,2)			 !30 Days Past Due
DAYS_60		 DECIMAL(8,2)			 !60 Days Past Due
DAYS_90		 DECIMAL(8,2)			 !90 Days Past Due
DAYS_120	 DECIMAL(8,2)			 !120+ Days Past Due
PAYMENTS	 DECIMAL(8,2)			 !Payments this Month
	     . .

TRANFILE     FILE,NAME(TRNNAME),PRE(TRN),RECLAIM,PROTECT,CREATE
	       OWNER('MjamesA'),ENCRYPT
MAIN_KEY       KEY(TRN:TRAN_CODE,TRN:TRAN_DATE,TRN:TRAN_SUB),DUP,NOCASE
SUB_KEY	       KEY(TRN:TRAN_SUB,TRN:TRAN_DATE),DUP,NOCASE
RECORD	       RECORD
TRAN_CODE	 LONG				 !Main Bill to Account
TRAN_SUB	 LONG				 !Patient Account
TRAN_DATE	 LONG				 !Transaction Date
PROC_CODE	 SHORT				 !Procedure Code
TRAN_TYPE	 STRING(1)			 !Transaction Type
TRAN_DETAIL	 STRING(15)			 !Transaction Detail
TOOTH_NBR	 STRING(10)			 !Tooth Number
TRAN_AMT	 DECIMAL(8,2)			 !Transaction Amount
	     . .

ARCHIVE	     FILE,NAME(ARCNAME),PRE(ARC),RECLAIM,PROTECT,CREATE
	       OWNER('MjamesA'),ENCRYPT
MAIN_KEY       KEY(ARC:TRAN_CODE,ARC:TRAN_DATE,ARC:TRAN_SUB),DUP,NOCASE
SUB_KEY	       KEY(ARC:TRAN_SUB,ARC:TRAN_DATE),DUP,NOCASE
RECORD	       RECORD
TRAN_CODE	 LONG				 !Bill to Account
TRAN_SUB	 LONG				 !Patient Account
TRAN_DATE	 LONG				 !Transaction Date
PROC_CODE	 SHORT				 !Procedure Code
TRAN_TYPE	 STRING(1)			 !Transaction Type
TRAN_DETAIL	 STRING(15)			 !Transaction Detail
TOOTH_NBR	 STRING(15)			 !Tooth Number
TRAN_AMT	 DECIMAL(8,2)			 !Transaction Amount
	     . .

DCHARGES     FILE,NAME(DCHNAME),PRE(DRP),RECLAIM,PROTECT,CREATE
	       OWNER('MjamesA'),ENCRYPT
REPORT_KEY     KEY(DRP:PAT_NAME,DRP:TRAN_DATE),DUP,NOCASE
RECORD	       RECORD
PAT_NAME	 STRING(40)			 !Patient Name
TRAN_DATE	 LONG				 !Transaction Date
PROC_CODE	 SHORT				 !Procedure Code
TRAN_DETAIL	 STRING(15)			 !Transaction Detail
TRAN_AMT	 DECIMAL(8,2)			 !Transaction Amount
	     . .

DPAYMENT     FILE,NAME(DPYNAME),PRE(DPY),RECLAIM,PROTECT,CREATE
	       OWNER('MjamesA'),ENCRYPT
REPORT_KEY     KEY(DPY:PAT_NAME,DPY:TRAN_DATE),DUP,NOCASE
RECORD	       RECORD
PAT_NAME	 STRING(40)			 !Patient Name
TRAN_DATE	 LONG				 !Transaction Date
CHECK_NBR	 STRING(10)			 !Check Number
PAYMENT_AMT	 DECIMAL(8,2)			 !Payment Amount
DISCOUNT_AMT	 DECIMAL(8,2)			 !Discount Amount
P_LINE		 STRING(4)			 !DEPOSIT LINE #
	     . .

DJOURNAL     FILE,NAME(JENAME),PRE(DJE),RECLAIM,PROTECT,CREATE
	       OWNER('MjamesA'),ENCRYPT
REPORT_KEY     KEY(DJE:PAT_NAME,DJE:TRAN_DATE),DUP,NOCASE
RECORD	       RECORD
PAT_NAME	 STRING(40)			 !Patient Name
TRAN_DATE	 LONG				 !Transaction Date
TRAN_DETAIL	 STRING(15)			 !Transaction Detail
TRAN_AMT	 DECIMAL(8,2)			 !Transaction Amount
	     . .

DOMS	     FILE,NAME('DOMS.DAT'),RECLAIM,PROTECT,CREATE
	       OWNER('MjamesA'),ENCRYPT
DRECORD	       RECORD
FILE1		 STRING(50)			 !FILE SPEC
FILE2		 STRING(50)			 !FILE SPEC GL FILE
FILE3		 STRING(50)			 !FILE SPEC CONTROL FILE
FILE4		 STRING(50)			 !FILE SPEC INFO FILE
FILE5		 STRING(50)			 !FILE SPEC PROCEDURE FILE
FILE6		 STRING(50)			 !FILE SPEC PRODUCER FILE
FILE7		 STRING(50)			 !FILE SPEC RECALL FILE
FILE8		 STRING(50)			 !FILE SPEC PRINTER FILE
FILE9		 STRING(50)			 !FILE SPEC PATIENT FILE
FILE10		 STRING(50)			 !FILE SPEC TRANSACTION FILE
FILE11		 STRING(50)			 !FILE SPEC ARCHIVE FILE
FILE12		 STRING(50)			 !FILE SPEC DAILY CHARGES FILE
FILE13		 STRING(50)			 !FILE SPEC DAILY PAYMENTS FILE
FILE14		 STRING(50)			 !FILE SPEC DAILY JE FILE
FILE15		 STRING(50)
DEAD_DATE	 LONG				 !DEMONSTRATION DEATH DATE
DR_NAME		 STRING(30)			 !SYSTEM LICENSED TO . . .
	     . .

GLNAME	     STRING(50)
CTLNAME	     STRING(50)
INFNAME	     STRING(50)
PRCNAME	     STRING(50)
PRDNAME	     STRING(50)
RCLNAME	     STRING(50)
PRTNAME	     STRING(50)
PATNAME	     STRING(50)
TRNNAME	     STRING(50)
ARCNAME	     STRING(50)
DCHNAME	     STRING(50)
DPYNAME	     STRING(50)
JENAME	     STRING(50)
