           PROGRAM

           INCLUDE('EQUATES.CLW')
           INCLUDE('KEYCODES.CLW')

Number     REAL                 !The current number displayed
Operand    REAL                 !The first operand for +,-,*,/,^ operations
Memory     REAL                 !The value contained in memory
Operation  REAL                 !The field number of the operation key
NewNumber  BYTE                 !True following = or %
Decimal    BYTE                 !True after pressing decimal point key
Digit      BYTE                 !Numeric digit represented by number key

!----------------------------------------------------------------------------
!
!   A WINDOW structure contains the entire layout of a window.  This is a
!   MODAL window with a SYSTEM menu, a GRAY background, and a DOUBLE frame.
!   All WINDOW structures can be "painted" with the window formatter that
!   is built-in to the Clarion text editor and application generator.
!
!   WINDOW structures contain graphic elements and control fields:
!
!   Graphic Elements             Control Fields
!     BOX                          BUTTON (command button)
!     ELLIPSE                      CHECK (box)
!     IMAGE                        COMBO (box)
!     LINE                         CUSTOM (Visual Basic custom control)
!     STRING                       ENTRY (single line text box)
!                                  GROUP (box)
!                                  LIST (box)
!                                  OPTION (group of radio buttons)
!                                  PROMPT (for control field)
!                                  RADIO (button)
!                                  REGION (for mouse detection)
!                                  SPIN (box)
!                                  TEXT (multi-line text box)
!                                  VCR (control for a list box)
!
!  Declarations use attributes to describe a window and its objects:
!     AT supplies the x,y coordinates, width, and height in dialog units.
!     FONT supplies the font type, size, and color
!     LEFT,RIGHT,DECIMAL supply justification
!     KEY names an accerlerator key
!     USE binds a variable to a control field and equates "?variable" to
!         the sequence number of the field number.  If a control field
!         does not require a value, USE assigns a label to the control
!         field (e.g. BUTTON('OK'),USE(?OK).
!
!     There are many more attributes
!
!  WINDOW structures may also contain MENUBARs and TOOLBARs.
!
!----------------------------------------------------------------------------
Calculator WINDOW('Calculator'),AT(93,45,110,140),MODAL,SYSTEM,GRAY,DOUBLE
             BUTTON('0'),AT(29,127,14,12),FONT('Arial',12,00H),USE(?Zero),KEY(KeyPad0)
             BUTTON('1'),AT(29,111,14,12),FONT('Arial',12,00H),USE(?One),KEY(KeyPad1)
             BUTTON('2'),AT(47,111,14,12),FONT('Arial',12,00H),USE(?Two),KEY(KeyPad2)
             BUTTON('3'),AT(65,111,14,12),FONT('Arial',12,00H),USE(?Three),KEY(KeyPad3)
             BUTTON('4'),AT(29,97,14,12),FONT('Arial',12,00H),USE(?Four),KEY(KeyPad4)
             BUTTON('5'),AT(47,97,14,12),FONT('Arial',12,00H),USE(?Five),KEY(KeyPad5)
             BUTTON('6'),AT(65,97,14,12),FONT('Arial',12,00H),USE(?Six),KEY(KeyPad6)
             BUTTON('7'),AT(29,82,14,12),FONT('Arial',12,00H),USE(?Seven),KEY(KeyPad7)
             BUTTON('8'),AT(47,82,14,12),FONT('Arial',12,00H),USE(?Eight),KEY(KeyPad8)
             BUTTON('9'),AT(65,82,14,12),FONT('Arial',12,00H),USE(?Nine),KEY(KeyPad9)
             BUTTON('.'),AT(47,127,14,12),FONT('Arial',12,00H),USE(?Decimal),KEY(DecimalKey)
             BUTTON('CE'),AT(10,127,14,12),FONT('Arial',10,00H),USE(?Clear)
             BUTTON('p'),AT(10,97,14,12),FONT('Symbol',12,00H),USE(?Pi)
             BUTTON('+/-'),AT(10,111,14,12),FONT('Arial',10,00H),USE(?Sign)
             BUTTON('x'),AT(47,68,14,12),FONT('Arial',10,00H),USE(?Square)
             BUTTON(''),AT(29,68,14,12),FONT('Symbol',12,00H),USE(?Root)
             BUTTON('1/x'),AT(84,68,14,12),FONT('Arial',10,00H),USE(?Reciprical)
             BUTTON('10X'),AT(10,68,14,12),FONT('Ariel',10,00H),USE(?TenTimes)
             BUTTON('%'),AT(10,82,14,12),FONT('Arial',12,00H),USE(?Percent)
             BUTTON(' lg'),AT(29,53,14,12),FONT('Arial',11,00H),USE(?Log)
             BUTTON(' ln'),AT(10,53,14,12),FONT('Arial',11,00H),USE(?Ln)
             BUTTON('MR'),AT(47,53,14,12),FONT('Arial',10,00H),USE(?Recall)
             BUTTON(' M'),AT(65,53,14,12),FONT('Arial',10,00H),USE(?Store)
             BUTTON(' M+'),AT(84,53,14,12),FONT('Arial',10,00H),USE(?Accumulate)
             BUTTON('+'),AT(84,127,14,12),FONT('Arial',12,00H),USE(?Add),KEY(PlusKey)
             BUTTON('-'),AT(84,83,14,12),FONT('Arial',12,00H),USE(?Subtract),KEY(MinusKey)
             BUTTON('x'),AT(84,111,14,12),FONT('Arial',12,00H),USE(?Multiply),KEY(AstKey)
             BUTTON('/'),AT(84,97,14,12),FONT('Arial',12,00H),USE(?Divide),KEY(DivideKey)
             BUTTON('Exp'),AT(65,68,14,12),FONT('Arial',8,00H),USE(?Power)
             BUTTON('='),AT(65,127,14,12),FONT('Arial',12,00H),USE(?Equal),KEY(EnterKey)
             STRING('Memory:'),AT(12,39,30,10),LEFT
             STRING(@S20),AT(40,39,55,10),USE(Memory),RIGHT
             ENTRY(@s20),AT(9,9,90,23),USE(Number),RIGHT(3),INS
            END

  CODE
  OPEN(Calculator)                      !Open the calculator window
  NewNumber = True                      !Start with a new number
  Decimal = False                       !No decimal point has been entered
!-----------------------------------------------------------------------------
!
!     ACCEPT...END is a control structure that processes the events
!     posted by the open window.  These events may be related to control
!     fields (e.g. a button was pressed or a text field was entered).
!     or they may be related to the window (e.g. a non-modal window is
!     about to lose focus or the window is about be be closed by the
!     system menu).  When an ACCEPT loop cycles, these functions supply
!     information about the event that is to be processed:
!
!     EVENT()    returns the event number that occurred.  EQUATES.CLW
!                contains labels for these events.
!     FIELD()    returns the field number that currently has focus.
!                Field numbers are referenced with field equate labels.
!     SELECTED() returns the field number that is to receive focus
!                during a "new field selected" event.  For any other
!                event, SELECTED() returns 0.
!     ACCEPTED() returns the field number for any control field event.
!                For other events, ACCEPTED() returns 0.
!
!-----------------------------------------------------------------------------
  ACCEPT                                !Enable windows and wait for an event
    CASE ACCEPTED()                     ! Jump to the accepted field
    OF ?Zero TO ?Nine                   ! For a numeric key
      Digit = ACCEPTED() - ?Zero        !  The digit is the field number
      IF NewNumber                      !  For the first digit
        Number = Digit                  !   Set the number to the digit
        NewNumber = False               !   Turn NewNumber flag off
        Decimal = False                 !   Turn decimal point flag off
      ELSE                              !   For any other digit
        IF Decimal                      !    For a fractional digit
          Number = CLIP(Number) & Digit !     Concatenate the digit
        ELSE                            !    For an integer digit
          Number = Number * 10 + Digit  !     Multipy by 10 and add the digit
        END                             !    End the IF
      END                               !   End the IF
      DISPLAY(?Number)                  !   Display the number

    OF ?Decimal                         ! For the decimal point key
      Decimal = True                    !  Turn decimal point flag on

    OF ?Clear                           ! For the ClearEntry/Clear key
      IF Number = 0 THEN Operand = 0.   !  Clear operand if number is zero
      Number = 0                        !  Clear number
    OF ?Pi                              ! For the Pi key
      Number = 3.141592654              !  Set number to Pi
    OF ?Sign                            ! For the Change Sign key
      Number *= -1                      !  Multiply by -1
    OF ?Square                          ! For the Square key
      Number *= Number                  !  Multilpy by itself
    OF ?Root                            ! For the Square Root key
      Number = SQRT(Number)             !  Find the square root
    OF ?TenTimes                        ! For the 10X key
      Number *= 10                      !  Multiply by 10
    OF ?Reciprical                      ! For the Reciprical key
      Number = 1/Number                 !  Find the reciprical
    OF ?Log                             ! For the logarithm key
      Number = LOG10(Number)            !  Find the base 10 logarithm
    OF ?Ln                              ! For the natural logarithm key
      Number = LOGE(Number)             !  Find the natural logarithm

    OF ?Recall                          ! For the Recall Memory key
      Number = Memory                   !  Set number to memory
    OF ?Store                           ! For the Store memory key
      Memory = Number                   !  Set memory to number
    OF ?Accumulate                      ! For the Add to Memory key
      Memory += Number                  !  Add number to memory

    OF ?Add TO ?Power                   ! For two operand operation keys
      Operation = ACCEPTED()            !  Save the operator
      Operand = Number                  !  Save the first operand
      Number = 0                        !  Clear the second operand

    OF ?Equal OROF ?Percent             ! For the Equal and Percent keys
      NewNumber = True                  !  Turn NewNumber flag on
      IF ACCEPTED() = ?Percent          !  For the percent key
        Number = Number * Operand / 100 !   Make number a percent of operand
      END                               !  End IF
      CASE Operation                    !  Jump to saved operation key
      OF ?Add                           !  For Add key
        Number += Operand               !   Add number to operand
      OF ?Subtract                      !  For Subtract key
        Number = Operand - Number       !   Subtract number from operand
      OF ?Multiply                      !  For Multiply key
        Number *= Operand               !   Multiply operand by number
      OF ?Divide                        !  For Divide key
        Number = Operand / Number       !   Divide operand by number
      OF ?Power                         !  For Raise to a Power key
        Number = Operand ^ Number       !   Raise operand to number power
      END                               !  End CASE
    END                                 ! End CASE
    IF ACCEPTED() THEN SELECT(?Zero).   ! Set focus to the Zero key
  END                                   !End ACCEPT
  CLOSE(Calculator)                     !Close the calculater window
