;
; *** Listing 7-9 ***
;
; Adds up the elements of a byte-sized array using
; base+index+displacement addressing inside the loop.
;
	jmp	Skip
;
ARRAY_LENGTH	equ	1000
TestArray	db	ARRAY_LENGTH dup (1)
TEST_START_OFFSET equ	200	;we'll add elements 200-299
TEST_LENGTH	equ	100	; of TestArray
;
Skip:
	call	ZTimerOn
	mov	bx,TEST_START_OFFSET
				;for base+index+displacement
	sub	si,si		; addressing
	sub	ax,ax		;initialize sum
	sub	dl,dl		;store 0 in DL so we can use
				; it for faster register-
				; register adds in the loop
	mov	cx,TEST_LENGTH	;# of bytes to add
SumArrayLoop:
	add	al,[TestArray+bx+si] ;add in the next byte
	adc	ah,dl		; to the 16-bit sum
	inc	si		;point to next byte 
	loop	SumArrayLoop
	call	ZTimerOff
