;
; *** Listing 7-2 ***
;
; Calculates the 16-bit sum of all bytes in a 128Kb block.
;
; Time with LZTIME.BAT, since this takes more than
; 54 ms to run.
;
	call	ZTimerOn
	sub	bx,bx	;we'll just sum the 128Kb starting
			; at DS:0
	sub	cx,cx	;count 128K bytes with SI:CX
	mov	si,2
	mov	ax,cx	;set initial sum to 0
	mov	dh,ah	;set DH to 0 for summing later
SumLoop:
	mov	dl,[bx]	;get this byte
	add	ax,dx	;add the byte to the sum
	inc	bx	;point to the next byte
	and	bx,0fh	;time to advance the segment?
	jnz	SumLoopEnd ;not yet
	mov	di,ds	;advance the segment by 1; since BX
	inc	di	; has just gone from 15 to 0, we've
	mov	ds,di	; advanced 1 byte in all
SumLoopEnd:
	loop	SumLoop
	dec	si
	jnz	SumLoop
	call	ZTimerOff
