;
; *** Listing 9-16 ***
;
; An illustration of the use of SUB AH,AH outside the
; processing loop to convert an array of byte values
; between 0 and 7Fh to an array of words. AH never changes
; from one pass through the loop to the next, so there's no
; need to continually set AH to 0.
;
	jmp	Skip
;
ARRAY_LENGTH	equ	1000
;
Array1	label	byte
ARRAY_VALUE=0
	rept	ARRAY_LENGTH
	db	ARRAY_VALUE
ARRAY_VALUE=(ARRAY_VALUE+1) and 07fh
				;cycle source array byte
				; values from 0-7Fh
	endm
;
Array2	dw	ARRAY_LENGTH dup (?)
;
Skip:
	mov	si,offset Array1 ;set up array pointers
	mov	di,offset Array2
	mov	ax,ds
	mov	es,ax		;copy to & from same segment
	cld			;make string instructions
				; increment pointers
	mov	cx,ARRAY_LENGTH
	sub	ah,ah		;set up to make each byte
				; read into AL a word in AX
				; automatically
	call	ZTimerOn
ProcessingLoop:
	lodsb			;get the next element
	stosw			;save the word value
	loop	ProcessingLoop	;do the next element
	call	ZTimerOff
