/*
 * wrap.h
 *  definitions for wrap and shift routines
 */

/* directions for rollwrap */
#define LEFT_UP		2
#define LEFT_DOWN	3
#define RIGHT_UP	0
#define RIGHT_DOWN	1

typedef struct {
    int x1, y1, x2, y2;
    char attr;
} shiftwin;

void shift    (shiftwin *win, int num);          /* horizontal shift */
void scroll   (shiftwin *win, int num);          /* vertical scroll */
void roll     (shiftwin *win, int num);          /* vertical wrap */
void wrap     (shiftwin *win, int num);          /* horizontal wrap */
void rollwrap (shiftwin *win, int num, int dir); /* diagonal wrap */
/* end of wrap.h */
