/*
 * wrapper.c - test roll and wrap routines
 */

#include <conio.h>
#include <dos.h>
#include "wrap.h"

/*
 * keyboard scan codes
 */
#define ESC	1
#define UP	72
#define LEFT	75
#define RIGHT	77
#define DOWN	80
#define PGUP	73
#define	END	79
#define	PGDN	81
#define STOP	76
#define	HOME	71
/*
 * definitions for timer interrupt routine
 */
#define TIMER	0x08		/* timer interrupt number */
unsigned long tick_count;	/* counter for ticker interrupt */
void interrupt (*old_timer) ();
void interrupt ticker();
void wait (int n);
int getkbd(void);

void main()
{
    static shiftwin win = {20, 5, 60, 20, 7};
    int dir = LEFT;
    int ch = 0;

    cputs("Press ESC to exit.  Arrow keys change directions");
    while (ch != ESC) {
        wait(5);
        switch (dir) {
	    case UP	: roll(&win, 1);    break;
            case DOWN   : roll(&win, -1);   break;
	    case LEFT   : wrap(&win, -1); break;
	    case RIGHT  : wrap(&win, 1);  break;
	    case HOME	: rollwrap(&win, 1, LEFT_UP); break;
	    case PGUP	: rollwrap(&win, 1, RIGHT_UP); break;
	    case PGDN	: rollwrap(&win, 1, RIGHT_DOWN); break;
	    case END	: rollwrap(&win, 1, LEFT_DOWN); break;
	}
        if (kbhit()) {
	    do {
	        ch = bioskey(0);
	        ch >>= 8;
	        if (ch == UP || ch == DOWN || ch == LEFT || ch == RIGHT ||
		    ch == HOME || ch == PGUP || ch == PGDN || ch == END ||
		    ch == STOP || ch == ESC)
		    dir = ch;
            } while (dir == STOP);
	}
    }
    setvect(TIMER,(*old_timer));	/* reset old timer interrupt */
}

void wait (int n)
{
  static int timer_installed = 0;

  if (!timer_installed) {
    old_timer = getvect(TIMER);		/* save old vector */
    setvect(TIMER,ticker);		/* set to ours */
    timer_installed = 1;
  }
  while (n--) {
      tick_count = 1;
      while (tick_count);		/* wait until ticker is done */
  }
}

void interrupt ticker(void)
{
  tick_count--;
  /* chain to old timer interrupt routine */
  (*old_timer)();
}
