	name	rollwrap
;
; rollwrap.asm - routine to diagonally wrap a window.
;
; void rollwrap (shiftwin *win, int num, int dir);
; where shiftwin is a structure:
; typedef struct {
;     int x1, y1, x2, y2;
;     char attr;
; } shiftwin;
;
; coordinates are 1-relative
; num is treated as a positive number
; dir is:
; LEFT_UP	2
; LEFT_DOWN	3
; RIGHT_UP	0
; RIGHT_DOWN	1
;
	dosseg

ifdef	__COMPACT__
	.model	compact
endif
ifdef	__HUGE__
	.model	huge
endif
ifdef	__LARGE__
	.model	large
endif
ifdef	__MEDIUM__
	.model	medium
endif
ifdef	__SMALL__
	.model	small
endif

LEFT_UP		equ	2
LEFT_DOWN	equ	3
RIGHT_UP	equ	0
RIGHT_DOWN	equ	1

extrn	_scrseg:word
extrn	_getscr:proc
extrn	_shift:proc
extrn	_scroll:proc
extrn	_getofs:proc

	.data
	
jump_table	label	word
	dw	go_right_up
	dw	go_right_down
	dw	go_left_up
	dw	go_left_down

	.code

_rollwrap	proc
	call	_getscr			;get screen information
	push	si
	push	di
	push	bp
	mov	bp,sp
					;[bp+8]  = &win
					;[bp+10] = num
					;[bp+12] = direction
	sub	sp,336			;space for local variables
					;dir 	   is [bp+12]
					;num 	   is [bp+10]
					;&win 	   is [bp+8]
					;save area is [bp-320]
					;nrow 	   is [bp-322]
					;ncol 	   is [bp-324]
					;	   is [bp-326]
					;base      is [bp-328]
					;save routine is [bp-330]
					;rest routine is [bp-332]
					;scroll_num is [bp-334]
					;shift_num is [bp-336]
	push	es			;save cause we're gonna use it
	mov	ax,ds
	mov	es,ax
	cmp	word ptr [bp+10],0
	jnz	rw1
	jmp	all_done		;don't do it if num is 0
rw1:
	mov	si,word ptr [bp+8]	;si points to shift window
	mov	ax,word ptr [bp+12]	;direction in AX
	and	ax,3			;mask just bits used
	add	ax,ax
	mov	bx,offset jump_table	;get address of correct routine
	add	bx,ax
	call	[bx]			;setup for wrap

do_wrap:
	mov	word ptr [bp-334],cx	;save scroll direction
	mov	word ptr [bp-336],dx	;save shift direction
	mov	word ptr [bp-330],si	;save save routine
	mov	word ptr [bp-332],di	;save restore routine
	call	_getofs			;compute base address
	mov	word ptr [bp-328],di	;and save
	mov	si,word ptr [bp+8]	;si points to shift window
					;[si+0] = x1
					;[si+2] = y1
					;[si+4] = x2
					;[si+6] = y2
					;[si+8] = attr
	mov	ax,word ptr [si+6]
	sub	ax,word ptr [si+2]
	inc	ax
	mov	word ptr [bp-322],ax	;save # rows
	mov	ax,word ptr [si+4]
	sub	ax,word ptr [si+0]
	inc	ax
	mov	word ptr [bp-324],ax	;save #columns
;
; Basic algorithm:
; For each wrap
;     save row and column
;     scroll
;     shift
;     restore row and column
;
wrap_loop:
	mov	ax,word ptr [bp-330]
	call	ax			;save row and column to be shifted out
	mov	ax,word ptr [bp-334]	;get scroll direction
	push	ax
	mov	si,word ptr [bp+8]	;and address of window
	push	si
	call	_scroll			;do the scroll
	mov	ax,word ptr [bp-336]	;get shift direction
	push	ax
	push	si			;_scroll saves si
	call	_shift			;do the shift
	mov	ax,word ptr [bp-332]
	call	ax			;restore row and col to new positions
	dec	word ptr [bp+10]	;bump down wrap count
	jnz	wrap_loop
all_done:
	pop	es
	mov	sp,bp
	pop	bp
	pop	di
	pop	si
	ret

;
; diagonal wrap right and up
go_right_up:
	mov	ax,word ptr [si+2]	;top
	mov	bx,word ptr [si+0]	;left
	mov	cx,1			;scroll up
	mov	dx,1			;shift right
	mov	si,offset cs:get_top_right
	mov	di,offset cs:put_left_bottom
	ret
;
; save top row and right column
get_top_right:
	call	near ptr get_ea_save
	mov	cx,word ptr [bp-324]	;col count
	rep	movsw			;move the columns
	mov	cx,word ptr [bp-322]	;row count
	dec	cx			;-1 cause first row is last col
	jz	gtr2
gtr1:	add	si,158			;add offset for next position
	movsw				;and save it
	loop	gtr1
gtr2:	pop	ds
	ret
;
; restore left column and bottom row 
put_left_bottom:
	call	near ptr get_ea_rest
	mov	cx,word ptr [bp-322]	;row count
plb1:	movsw
	add	di,158
	loop	plb1
	mov	cx,word ptr [bp-324]	;col count
	dec	cx
	jz	plb2
	sub	di,158
	rep	movsw
plb2:	pop	es
	ret

;
; diagonal wrap right and down
go_right_down:
	mov	ax,word ptr [si+6]	;bottom
	mov	bx,word ptr [si+0]	;left
	mov	cx,-1			;scroll down
	mov	dx,1			;shift right
	mov	si,offset cs:get_bottom_right
	mov	di,offset cs:put_left_top
	ret
;
; get bottom row and right column
get_bottom_right:
	call	near ptr get_ea_save
	mov	cx,word ptr [bp-324]	;col count
	rep	movsw
	mov	cx,word ptr [bp-322]	;row count
	dec	cx
	jz	gbr2
gbr1:	sub	si,162
	movsw
	loop	gbr1
gbr2:	pop	ds
	ret
;
; restore left column and top row
put_left_top:
	call	near ptr get_ea_rest
	mov	cx,word ptr [bp-322]	;row count
plt1:	movsw
	sub	di,162
	loop	plt1
	mov	cx,word ptr [bp-324]	;col count
	dec	cx
	jz	plt2
	add	di,162
	rep	movsw
plt2:	pop	es
	ret
	
; diagonal wrap left and up
go_left_up:
	mov	ax,word ptr [si+6]	;bottom
	mov	bx,word ptr [si+0]	;left
	mov	cx,1			;scroll up
	mov	dx,-1			;shift left
	mov	si,offset cs:get_left_top
	mov	di,offset cs:put_bottom_right
	ret
;
; save left column and top row
get_left_top:
	call	near ptr get_ea_save	;setup for move
	mov	cx,word ptr [bp-322]	;row count
glt1:	movsw
	sub	si,162			;subtract offset for next row
	loop	glt1
	mov	cx,word ptr [bp-324]	;col count
	dec	cx
	jz	glt2
	add	si,162
	rep	movsw			;move the columns
glt2:	pop	ds
	ret
;
; restore bottom row and right column
put_bottom_right:
	call	near ptr get_ea_rest
	mov	cx,word ptr [bp-324]	;col count
	rep	movsw
	mov	cx,word ptr [bp-322]	;row count
	dec	cx
	jz	pbr2
pbr1:	sub	di,162
	movsw
	loop	pbr1
pbr2:	pop	es
	ret

;
; diagonal wrap left and down
go_left_down:
	mov	ax,word ptr [si+2]	;top
	mov	bx,word ptr [si+0]	;left
	mov	cx,-1			;scroll down
	mov	dx,-1			;shift left
	mov	si,offset cs:get_left_bottom
	mov	di,offset cs:put_top_right
	ret
;
; get left column and bottom row
get_left_bottom:
	call	near ptr get_ea_save
	mov	cx,word ptr [bp-322]	;row count
glb1:	movsw
	add	si,158
	loop	glb1
	mov	cx,word ptr [bp-324]	;col count
	dec	cx
	jz	glb2
	sub	si,158
	rep	movsw
glb2:	pop	ds
	ret
;
; restore top row and right column
put_top_right:
	call	near ptr get_ea_rest
	mov	cx,word ptr [bp-324]	;col count
	rep	movsw
	mov	cx,word ptr [bp-322]	;row count
	dec	cx
	jz	ptr2
ptr1:	add	di,158
	movsw
	loop	ptr1
ptr2:	pop	es
	ret
;
; This routine MUST be accessed through a near call!!
;
get_ea_save:
	pop	bx			;return address in BX
	push	ds			;save data segment
	mov	si,word ptr [bp-328]	;source is screen base address
	lea	di,word ptr [bp-320]	;dest is save area
	mov	ax,word ptr _scrseg
	mov	ds,ax			;data segment is screen segment
	cld
	jmp	bx			;return

;
; This routine MUST be accessed through a near call!!
;
get_ea_rest:
	pop	bx			;return address in Bx
	push	es			;save ES
	lea	si,word ptr [bp-320]	;source is save area
	mov	di,word ptr [bp-328]	;dest is screen base address
	mov	ax,word ptr _scrseg
	mov	es,ax
	cld
	jmp	bx			;return
_rollwrap	endp
	public	_rollwrap
	end
