;=============================================================================
;FILE:  WHEREQ.ASM
;
;DESC:  Search default disk for files matching argument
;=============================================================================


include         MODEL.INC
include         util.inc

; - Spontaneous Assembly Functions
.codeseg        lib
.extrn          start:auto, exit:auto, exit_ok:auto
.extrn          put_str:auto,put_newline:auto
.extrn          str_cpy:auto,str_rchr:auto,str_len:auto
.extrn          find_first:auto,find_next:auto
.extrn          arg_count:auto, arg_next:auto
.extrn          dword_to_dec:auto
.ends


.dataseg
FA_NORM         equ   0000h
FA_RDONLY       equ   0001h
FA_HIDDEN       equ   0002h
FA_SYSTEM       equ   0004h
FA_SUBDIR       equ   0010h

DTA             struc
file_res        db    21 dup(?)
file_attr       db    ?
file_time       dw    ?
file_date       dw    ?
file_size       dd    ?
file_name       db    13 dup(?)
DTA             ends

clatail         equ 80h
path_mark       dw  0                       ; where to add path
path_bufr       db  "@:"                    ; space for building full
                db  128 dup(0)              ; file path names
dir_srch        db  "\*.*",0
file_srch       db  "\filename.ext",0
dta_addr        dw  0                       ; current DTA address
space2          db  "  ",0                  ; space ..
sizebufr        db  "1234567890",0          ; space for file size
datebufr        db  "mm-dd-yy",0            ;        "       date
timebufr        db  "hh:mm",0               ;        "       time
usemsg          db  "Usage: WHEREQ filespec - search current disk for files",0
.ends


.codeseg
assume        cs:@codeseg, ds:@dataseg, es:@dataseg, ss:@dataseg

.public       main
.proc         main    auto

              call    arg_count
              jcxz    argerr

loadarg:      mov     si,offset @dataseg:file_srch ; get file specs
              inc     si                    ; skip the '/'
              call    arg_next
              jc      argerr                ; if none, quit w/ error

              mov     di,offset @dataseg:path_bufr
              add     di,2                  ; where to catenate full path
              mov     [path_mark],di        ; .. and save ...

getdrive:     mov     ah,19h                ; get def drive
              int     21h                   ; .. into AL
              inc     al                    ; .. set A:=1, etc
              add     [path_bufr],al        ; stick where belong, convert
                                            ; .. to char

              mov     di,offset @dataseg:dta_bufr
              call    path_dumper


              jmp     short where_exit

argerr:       mov     si,offset @dataseg:usemsg
              call    put_str

where_exit:   ret                           ; exit to DOS with ERRORLEVEL=0
.endp         main


; -- PATH_DUMPER - dump files matching file spec
;                  ES:DI -> DTA address
.public       path_dumper
.proc         path_dumper auto

              ; first, form proper FILE search path
              push    di                    ; save DTA address
              mov     di,[path_mark]        ; where to start catentation
              mov     si,offset @dataseg:file_srch ; get file specs
              call    str_cpy               ; form initial search string

              ; load DS:SI -> FILE search path, ES:DI -> DTA
              mov     si,offset @dataseg:path_bufr
              pop     di                    ; get DTA back

              ; set up desired attributes and go ...
              mov     ax,FA_NORM+FA_RDONLY+FA_HIDDEN+FA_SYSTEM
              call    find_first
              jne     sub_path
              push    si                ; save thru below
              mov     al,'\'            ; get set to isolate path
              call    str_rchr          ; find last occurance
              inc     si                ; get past last occurance
              mov     byte ptr [si],0   ; trim string
              pop     si                ; and get SI back
              call    fbuf_print
path_loop:    call    find_next
              jne     sub_path
              call    fbuf_print
              jmp     path_loop

sub_path:     ; next, let's try any DIRs in this path
              push    di                    ; save DTA address
              mov     di,[path_mark]        ; where to start catentation
              mov     si,offset @dataseg:dir_srch ; get dir file specs
              call    str_cpy               ; form DIR search string

              ; load DS:SI -> DIR search path, ES:DI -> DTA
              mov     si,offset @dataseg:path_bufr
              pop     di                    ; get DTA back
              mov     ax,FA_SUBDIR
              call    find_first
              jmp     short subp_loopa

subp_loop:    call    find_next
subp_loopa:   jne     path_exit             ; if none, split
              cmp     al,[di].file_attr     ; find directory?
              jne     subp_loop             ; no, do somemore
              cmp     [di].file_name,'.'    ; is one of the .. names?
              je      subp_loop             ; yes, don't want it

              ; at this point would append path info and recursively call
              ; PATH_DUMPER
              push    di                    ; save this DTA addr
              push    [path_mark]           ; save current tail
              push    di                    ; save 1 more time
              ; now, form new path string ...
              mov     si,di
              add     si,file_name
              mov     di,[path_mark]        ; where to append SUBDIR name
              inc     di                    ; skip leading slash
              call    str_cpy               ; make full name
              mov     si,[path_mark]        ; where old end
              call    str_len               ; how long?
              add     [path_mark],cx        ; set new end
              pop     di                    ; gets back DTA
              add     di,2ch                ; make a 'new' DTA
              call    path_dumper
              pop     [path_mark]           ; get pointers back
              pop     di                    ; ...
              jmp     subp_loop             ; and back to try next SUBDIR

path_exit:    ret
.endp         path_dumper

; -- FBUF_PRINT - print FBUFR from FIND_FIRST/NEXT
; --              Call with ES:DI -> FBUFR
; --                        DS:SI -> PATH info ..
.public       fbuf_print
.proc         fbuf_print
              .push   ax,bx,cx,dx,si

              push    si               ; want to save path info for later
              mov     ax,word ptr [di].file_size
              mov     dx,word ptr [di].file_size + 2
              mov     si,offset @dataseg:sizebufr

              call    dword_to_dec     ; print file size ...
              mov     cx,10            ; want to right just over 10 chars
              call    str_rjust
              call    put_str
              mov     si,offset @dataseg:space2
              call    put_str

              mov     ax,[di].file_date ; print file date
              mov     si,offset @dataseg:datebufr
              call    format_fdate
              call    put_str
              mov     si,offset @dataseg:space2
              call    put_str

              mov     ax,[di].file_time ; print file time
              mov     si,offset @dataseg:timebufr
              call    format_ftime
              call    put_str
              mov     si,offset @dataseg:space2
              call    put_str

              pop     si
              call    put_str
              mov     si,di
              add     si,file_name
              call    put_str
              call    put_newline

              .pop   ax,bx,cx,dx,si
              ret
.endp         fbuf_print

; -- FORMAT_FTIME - format File Time (ie word format)
; --                Call with AX    =  time word
; --                          DS:SI -> print buffer
.public       format_ftime
.proc         format_ftime
              .push   ax,bx,cx,dx,si

              mov     cl,5
              shr     ax,cl                 ; dump seconds in time
              mov     dl,3fh
              and     dl,al                 ; mask off minutes into DL
              mov     cl,6                  ; get set to get hours
              shr     ax,cl
              call    b2dec                 ; make into ascii
              add     si,3                  ; adjust SI past hh:
              mov     al,dl                 ; get set to do hours
              call    b2dec

              .pop    ax,bx,cx,dx,si
              ret
.endp         format_ftime

; -- FORMAT_FDATE - format File Date (ie word format)
; --                Call with AX    =  date word
; --                          DS:SI -> print buffer
.public       format_fdate
.proc         format_fdate
              .push   ax,bx,cx,dx,si

              mov     dl,1fh
              and     dl,al                 ; mask off day into DL
              mov     cl,5
              shr     ax,cl
              mov     dh,0fh
              and     dh,al                 ; mask off month into DH
              mov     cl,4                  ; get set to get year
              shr     ax,cl
              mov     cl,al                 ; save year in AL

              mov     al,dh                 ; format month
              call    b2dec                 ; make into ascii
              add     si,3                  ; adjust SI past mm-
              mov     al,dl                 ; get set to do day
              call    b2dec
              add     si,3                  ; adjust SI past dd-
              mov     al,cl                 ; do year
              add     al,80                 ; adj for offset
              call    b2dec

              .pop    ax,bx,cx,dx,si
              ret
.endp         format_fdate

;---B2DEC     convert 2 digit (ONLY) binary into two ASCII chrs
; --                Call with AL    =  value
; --                          DS:SI -> print buffer
.public       b2dec
.proc         b2dec
              aam                  ; div AL by 10..1st digit in AH,2nd in AL
              add     ax,'00'      ; cnvrt to ASCII
              xchg    ah,al        ; reverse
              mov     [si],ax      ; store
              ret                  ; back to caller
.endp         b2dec


; STR_RJUST  - Right Justify an ASCIIZ string.
;              DS:SI -> string, CX has width to
;              fit. (' ' left fill)
str_rjust   proc
            .push   ax,cx,si,di,ds,es

            cld                 ; insure proper direction
            push    ds
            pop     es
            push    cx          ; load count arg
            mov     di,si       ; scans ES:DI
            sub     al,al       ; look for trailing null
            mov     cx,-1       ; max len to check
            repne   scasb       ; find trailing null
            not     cx
            dec     cx          ; now have string length
            pop     ax          ; get input width to AX
            sub     ax,cx       ; any work to do or even possible?
            jz      qexit       ; AX holds distance to move+amt to fill
            dec     di
            dec     di
            mov     si,di       ; ES:DI,DS:SI both -> string END
            add     di,ax       ; we want ES:DI -> to end of field

            std                 ; set direction flag back
            rep     movsb       ; move to end of field
            mov     cx,ax       ; load CX with amt to fill
            mov     al,' '      ; load up w/ fill char
            rep     stosb       ; and stowem
            cld                 ; finally, insure this reset

qexit:      .pop    ax,cx,si,di,ds,es
            ret
str_rjust   endp
.ends


_BSSEND       segment byte public 'STACK'
EVENDATA
dta_bufr      db  43 dup(0)                 ; allow some room
_BSSEND       ends

              end     start
