; VGAColor.Asm    --   Copyright (c) 1995 by Jannes Faber
;
; Downloaded from:
;             Professional Programmers' Pages
;              http://www.fys.ruu.nl/~faber
;
; TSR that continually copies the color attributes of the VGA screen onto the
; Hercules screen as characters.
;
        .MODEL  TINY
        .386
        .CODE
        .STARTUP
        
        jmp     Install                 ; Jump over data and resident code
; Data must be in code segment so it won't be thrown away with Install code.

OldHandler      DWORD   ?               ; Address of original timer routine

NewHandler PROC   FAR
        push    cx
        push    ds
        push    es
        push    si
        push    di

        mov     si, 1
        mov     di, 0

        mov     cx, 0B800h
        mov     ds, cx

        mov     cx, 0B000h
        mov     es, cx

        mov     cx, 2000

Loop1:  movsb
        inc     si
        inc     di
        loop    Loop1

        pop     di
        pop     si
        pop     es
        pop     ds
        pop     cx

        jmp    cs:OldHandler
NewHandler ENDP

Install PROC
        mov     ax, 351Ch               ; Request function 35h
        int     21h                     ; Get vector for timer (interrupt 08)
        mov     WORD PTR OldHandler[0], bx; Store address of original
        mov     WORD PTR OldHandler[2], es;   timer interrupt
        mov     ax, 251Ch               ; Request function 25h
        mov     dx, OFFSET NewHandler     ; DS:DX points to new timer handler
        int     21h                     ; Set vector with address of NewHandler

        mov     dx, OFFSET Install      ; DX = bytes in resident section
        mov     cl, 4
        shr     dx, cl                  ; Convert to number of paragraphs
        inc     dx                      ;   plus one
        mov     ax, 3100h               ; Request function 31h, error code=0
        int     21h                     ; Terminate-and-Stay-Resident

Install ENDP
        
        END
