;
;	Serial port driver called from basica AHA 8503.01 compiler version
;	call comport(func,byte,string)
;
; func=0 to set port, 1=send string, 2=send character, 3=receive character
; byte=character to send/receive, port setting
; string=characters to send
;
progseg segment para public 'CODE'
	assume	cs:progseg
	public	comport
sercom	equ	14h
;
comport proc	far
	push	bp
	mov	bp,sp
	push	ds
	push	es
	push	ax
	push	bx
	push	cx
	push	dx
;
	mov	bx,[bp+10]	;get function
	mov	ax,[bx]
	cmp	ax,1		;send string ?
	jz	putstring
	cmp	ax,2		;send a character ?
	jz	putchar
	cmp	ax,3		;get a character ?
	jz	getchar
setport:
	mov	bx,[bp+8]	;get byte value
	mov	ax,[bx] 	;into al
	mov	ah,0		;set port command
	mov	dx,0		;com 1
	int	sercom		;serial communications vector
;	mov	bx,[bp+8]	;return error byte value
;	mov	[bx],ah 	;only high byte of error status
	jmp	exit		;finish
putchar:
	mov	bx,[bp+8]	;get byte value
	mov	ax,[bx] 	;into al
	mov	ah,1		;put character command
	mov	dx,0		;com 1
	int	sercom		;serial communications vector
;	mov	bx,[bp+8]	;return error byte value
;	mov	[bx],ah 	;only high byte of error status
	jmp	exit		;finish
getchar:
	mov	ah,2		;get character command
	mov	dx,0		;com 1
	int	sercom		;serial communications vector
	mov	bx,[bp+8]	;no error byte value
	mov	[bx],al 	;
	jmp	exit		;finish
putstring:
	mov	bx,[bp+6]	;get string address
	mov	cl,[bx] 	;get string length
	mov	dx,[bx+2]	;get string address
	mov	bx,dx		;put address in bx
	mov	ch,0		;zero high byte
putst:
	mov	al,[bx]
	mov	ah,1		;put character command
	mov	dx,0		;com 1
	int	sercom		;serial communications vector
	CMP	AH,0
	JNZ	PUTST
	inc	bx		;bump pointer
	loop	putst		;send entire string
;	mov	bx,[bp+8]	;return error byte value
;	mov	[bx],ah 	;only high byte of error status
exit:
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	pop	es
	pop	ds
	pop	bp
	ret	6
comport endp
progseg ends
	end
